/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.IDImageIcon;
import org.appwork.utils.images.IconIO;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.gui.LAFOptions;

public class Header
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CONSTRAINT = "";
    private JLabel label;
    private JCheckBox enabled;
    private JLabel iconLabel;
    private int version;

    public Header(String name, Icon icon) {
        super((LayoutManager)new MigLayout("ins 0", "[35!]5[]10[grow,fill]"));
        this.iconLabel = icon == null ? new JLabel() : new JLabel(this.wrapIcon(icon));
        this.add((Component)this.iconLabel, "alignx right");
        if (icon == null) {
            this.setLayout((LayoutManager)new MigLayout("ins 0", "[0!]5[]10[grow,fill]"));
        }
        this.label = new JLabel("<html><u><b>" + name + "</b></u></html>");
        this.label.setBorder(null);
        LAFOptions.getInstance().applyConfigHeaderTextColor(this.label);
        this.add(this.label);
        this.add(new JSeparator());
        this.setOpaque(false);
    }

    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    public Header(String name, Icon icon, BooleanKeyHandler listener) {
        this(name, icon, listener, -1);
    }

    public Header(String name, Icon icon, BooleanKeyHandler listener, int version) {
        super((LayoutManager)new MigLayout("ins 0", "[35!]5[]10[grow,fill]10[]2[]"));
        this.iconLabel = new JLabel(this.wrapIcon(icon));
        this.add((Component)this.iconLabel, "alignx right");
        this.label = version > 0 ? new JLabel("<html><u><b>" + name + "</b></u> Version " + version + "</html>") : new JLabel("<html><u><b>" + name + "</b></u></html>");
        this.version = version;
        this.label.setBorder(null);
        this.add(this.label);
        this.add(new JSeparator());
        this.add(new JLabel(_JDT.T.configheader_enabled()));
        this.enabled = new ExtCheckBox(listener, new JComponent[]{this.label, this.iconLabel});
        this.enabled.setHorizontalTextPosition(2);
        this.add(this.enabled);
        this.setOpaque(false);
    }

    public void setHeaderEnabled(boolean isEnabled) {
        this.label.setEnabled(isEnabled);
        this.iconLabel.setEnabled(isEnabled);
        if (this.enabled != null) {
            if (this.enabled.isSelected() == isEnabled) {
                return;
            }
            this.enabled.setSelected(isEnabled);
        }
    }

    public boolean isHeaderEnabled() {
        return this.enabled.isSelected();
    }

    public void setIcon(Icon icon) {
        Icon _getIcon = this.wrapIcon(icon);
        if (this.iconLabel.getIcon() == null && _getIcon != null) {
            this.setLayout((LayoutManager)new MigLayout("ins 0", "[35!]5[]10[grow,fill]"));
        } else if (this.iconLabel.getIcon() != null && _getIcon == null) {
            this.setLayout((LayoutManager)new MigLayout("ins 0", "[0!]5[]10[grow,fill]"));
        }
        this.iconLabel.setIcon(_getIcon);
    }

    public Icon wrapIcon(Icon icon) {
        int max;
        if (icon == null) {
            return null;
        }
        int n = max = icon.getIconHeight() > 30 || icon.getIconWidth() > 30 ? 32 : 22;
        if (icon.getIconWidth() > max || icon.getIconHeight() > max) {
            icon = IconIO.getScaledInstance((Icon)icon, (int)max, (int)max);
        }
        ExtMergedIcon _getIcon = new ExtMergedIcon((Icon)new IDImageIcon((Image)IconIO.createEmptyImage((int)max, (int)max))){

            protected void idIconCheck(ExtMergedIcon.Entry entry) {
            }
        };
        _getIcon.add(icon, (max - icon.getIconWidth()) / 2, (max - icon.getIconHeight()) / 2);
        return _getIcon;
    }

    public void setText(String name) {
        if (this.version > 0) {
            this.label.setText("<html><u><b>" + name + "</b></u> Version " + this.version + "</html>");
        } else {
            this.label.setText("<html><u><b>" + name + "</b></u></html>");
        }
    }
}

