/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui;

import com.apple.eawt.Application;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Component;
import java.awt.Window;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;

public class GuiUtils {
    private static final User32 lib;

    public static void flashWindow(Window window, boolean flashTray) {
        Application application;
        if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_XP)) {
            if (lib != null) {
                System.out.println("Flash: " + flashTray);
                WinUser.FLASHWINFO flash = new WinUser.FLASHWINFO();
                WinDef.HWND hwnd = new WinDef.HWND(Native.getComponentPointer((Component)window));
                flash.hWnd = hwnd;
                flash.uCount = 100;
                flash.dwTimeout = 1000;
                flash.dwFlags = flashTray ? 15 : 0;
                flash.cbSize = flash.size();
                lib.FlashWindowEx(flash);
            }
        } else if (CrossSystem.isMac() && (application = Application.getApplication()) != null) {
            application.requestUserAttention(flashTray);
        }
    }

    public static boolean isActiveWindow(final Window mainFrame) {
        if (mainFrame == null) {
            return false;
        }
        return (Boolean)new EDTHelper<Boolean>(){

            public Boolean edtRun() {
                if (!mainFrame.isVisible()) {
                    System.out.println("Mainframe is invisible");
                    return false;
                }
                if (mainFrame.isActive() && mainFrame.isVisible()) {
                    System.out.println("Mainframe is active");
                    return true;
                }
                for (Window w : mainFrame.getOwnedWindows()) {
                    if (!w.isActive() || !w.isVisible()) continue;
                    System.out.println(w + " is active");
                    return true;
                }
                return false;
            }
        }.getReturnValue();
    }

    static {
        User32 loadedLib = null;
        try {
            loadedLib = CrossSystem.isWindows() ? (User32)Native.loadLibrary((String)"user32", User32.class) : null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        lib = loadedLib;
    }
}

