/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import org.appwork.utils.event.DefaultEvent;
import org.jdownloader.gui.event.GUIEvent;
import org.jdownloader.gui.event.GUIEventSender;

public class KeyObserver
implements AWTEventListener {
    private static final KeyObserver INSTANCE = new KeyObserver();
    private static int CLEAR_OLD_MASK = -1;
    private int modifiers;
    private KeyEvent kEvent;

    public static KeyObserver getInstance() {
        return INSTANCE;
    }

    public boolean isControlDown(boolean nootherKey) {
        return this.isModifierPressed(128, nootherKey);
    }

    public boolean isMetaDown(boolean nootherKey) {
        return this.isModifierPressed(256, nootherKey);
    }

    public boolean isModifierPressed(int modifier, boolean nootherKey) {
        int currentMod = this.fixModifiers(this.modifiers);
        modifier = this.fixModifiers(modifier);
        if (nootherKey) {
            return currentMod == modifier;
        }
        int and = currentMod & modifier;
        return and == modifier;
    }

    public int fixModifiers(int currentMod) {
        if ((currentMod & 1) != 0) {
            currentMod |= 0x40;
        }
        if ((currentMod & 8) != 0) {
            currentMod |= 0x200;
        }
        if ((currentMod & 2) != 0) {
            currentMod |= 0x80;
        }
        if ((currentMod & 4) != 0) {
            currentMod |= 0x100;
        }
        if ((currentMod & 0x20) != 0) {
            currentMod |= 0x2000;
        }
        if ((currentMod & 0x10) != 0) {
            currentMod |= 0x400;
        }
        if ((currentMod & 0x40) != 0) {
            currentMod |= 1;
        }
        if ((currentMod & 0x200) != 0) {
            currentMod |= 8;
        }
        if ((currentMod & 0x80) != 0) {
            currentMod |= 2;
        }
        if ((currentMod & 0x100) != 0) {
            currentMod |= 4;
        }
        if ((currentMod & 0x2000) != 0) {
            currentMod |= 0x20;
        }
        if ((currentMod & 0x400) != 0) {
            currentMod |= 0x10;
        }
        return currentMod;
    }

    private KeyObserver() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.kEvent = (KeyEvent)event;
        int modifier = this.kEvent.getModifiersEx();
        if (modifier != this.modifiers) {
            this.modifiers = modifier;
            GUIEventSender.getInstance().fireEvent((DefaultEvent)new GUIEvent(this, GUIEvent.Type.KEY_MODIFIER, modifier));
        }
    }
}

