/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import org.appwork.swing.MigPanel;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.gui.dialog.AskContainerPasswordDialogInterface;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class AskContainerPasswordDialog
extends InputDialog
implements AskContainerPasswordDialogInterface {
    private final File containerfile;

    public AskContainerPasswordDialog(String title, String message, File containerfile) {
        super(4, title, message, null, (Icon)new AbstractIcon("password", 32), _GUI.T.lit_continue(), null);
        this.setTimeout(600000);
        this.containerfile = containerfile;
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 1", "[]", "[][]");
        if (!StringUtils.isEmpty((String)this.message)) {
            this.textField = new JTextPane(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return !BinaryLogic.containsAll((int)AskContainerPasswordDialog.this.flagMask, (int[])new int[]{64});
                }

                @Override
                public boolean getScrollableTracksViewportHeight() {
                    return true;
                }
            };
            Font font = this.textField.getFont();
            this.textField.setContentType("text/plain");
            this.textField.setFont(font);
            this.textField.setText(this.message);
            this.textField.setEditable(false);
            this.textField.setBackground(null);
            this.textField.setOpaque(false);
            this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
            this.textField.setCaretPosition(0);
            p.add((Component)this.textField, "pushx, growx");
            this.textField.setPreferredSize(this.textField.getPreferredSize());
        }
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel("Path to container:")), "split 2,sizegroup left,alignx left");
        p.add(this.leftLabel(this.containerfile.getAbsolutePath()));
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel("Container type")), "split 2,sizegroup left,alignx left");
        String ext = Files.getExtension((String)this.containerfile.getName(), (boolean)true);
        String containerTypeText = ext != null ? ext : "unknown";
        JLabel ret = new JLabel(containerTypeText);
        ret.setHorizontalAlignment(2);
        if (ext != null) {
            try {
                ret.setIcon(CrossSystem.getMime().getFileIcon(ext, 16, 16));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        p.add(ret);
        this.input = this.getSmallInputComponent();
        this.input.setText(this.defaultMessage);
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.ExtractionListenerList_layoutDialogContent_password())), "split 2,sizegroup left,alignx left");
        p.add((Component)((JComponent)this.input), "w 450,pushx,growx");
        return p;
    }

    private Component leftLabel(String name) {
        JLabel ret = new JLabel(name);
        ret.setHorizontalAlignment(2);
        return ret;
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    @Override
    public File getFile() {
        return this.containerfile;
    }
}

