/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.dialog.AskUsernameAndPasswordDialogInterface;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;

public class AskForUserAndPasswordDialog
extends InputDialog
implements AskUsernameAndPasswordDialogInterface {
    private final DownloadLink downloadLink;
    private ExtPasswordField password;
    private JCheckBox save;
    private Color titleColor;

    public AskForUserAndPasswordDialog(String message, DownloadLink link) {
        super(260, _GUI.T.AskForUserAndPasswordDialog_AskForUserAndPasswordDialog_title_(), message, null, null, _GUI.T.lit_continue(), null);
        this.downloadLink = link;
        this.setTimeout(600000);
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 1", "[]", "[][]");
        this.titleColor = Color.DARK_GRAY;
        if (!StringUtils.isEmpty((String)this.message)) {
            this.textField = new JTextPane(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return !BinaryLogic.containsAll((int)AskForUserAndPasswordDialog.this.flagMask, (int[])new int[]{64});
                }

                @Override
                public boolean getScrollableTracksViewportHeight() {
                    return true;
                }
            };
            Font font = this.textField.getFont();
            this.textField.setContentType("text/plain");
            this.textField.setFont(font);
            this.textField.setText(this.message);
            this.textField.setEditable(false);
            this.textField.setBackground(null);
            this.textField.setOpaque(false);
            this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
            this.textField.setCaretPosition(0);
            p.add((Component)this.textField, "pushx, growx");
            this.textField.setPreferredSize(this.textField.getPreferredSize());
        }
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_filename())), "split 2,sizegroup left,alignx left");
        p.add(this.leftLabel(this.downloadLink.getView().getDisplayName()));
        String packagename = this.getPackageName();
        if (StringUtils.isNotEmpty((String)packagename)) {
            p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_package())), "split 2,sizegroup left,alignx left");
            p.add(this.leftLabel(packagename));
        }
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_hoster())), "split 2,sizegroup left,alignx left");
        DomainInfo di = this.downloadLink.getDomainInfo();
        JLabel ret = new JLabel(di.getTld());
        ret.setHorizontalAlignment(2);
        ret.setIcon(di.getFavIcon());
        p.add(ret);
        this.input = this.getSmallInputComponent();
        this.input.setText(this.defaultMessage);
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_username())), "split 2,sizegroup left,alignx left");
        p.add((Component)((JComponent)this.input), "w 450,pushx,growx");
        this.password = new ExtPasswordField();
        this.password.addKeyListener((KeyListener)((Object)this));
        this.password.addMouseListener((MouseListener)((Object)this));
        this.save = new JCheckBox();
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.lit_password())), "split 2,sizegroup left,alignx left");
        p.add((Component)this.password, "w 450,pushx,growx");
        p.add(this.addSettingName(_AWU.T.AccountNew_layoutDialogContent_save()));
        p.add((Component)this.save, "sizegroup g1");
        if (StringUtils.isNotEmpty((String)packagename)) {
            this.getDialog().addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    ArrayList<DownloadLink> selection = new ArrayList<DownloadLink>();
                    selection.add(AskForUserAndPasswordDialog.this.downloadLink);
                    DownloadsTableModel.getInstance().setSelectedObjects(selection);
                }
            });
        }
        return p;
    }

    private JLabel addSettingName(String name) {
        JLabel lbl = new JLabel(name);
        lbl.setForeground(this.titleColor);
        return lbl;
    }

    private Component leftLabel(String name) {
        JLabel ret = new JLabel(name);
        ret.setHorizontalAlignment(2);
        return ret;
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    @Override
    public long getLinkID() {
        return this.downloadLink.getUniqueID().getID();
    }

    @Override
    public String getLinkName() {
        return this.downloadLink.getView().getDisplayName();
    }

    @Override
    public String getLinkHost() {
        return this.downloadLink.getHost();
    }

    @Override
    public String getPackageName() {
        FilePackage parent = this.downloadLink.getParentNode();
        if (FilePackage.isDefaultFilePackage(parent) || parent == null) {
            return null;
        }
        return parent.getName();
    }

    @Override
    public String getUsername() {
        return (String)new EDTHelper<String>(){

            public String edtRun() {
                return AskForUserAndPasswordDialog.this.input.getText();
            }
        }.getReturnValue();
    }

    @Override
    public String getPassword() {
        return (String)new EDTHelper<String>(){

            public String edtRun() {
                return AskForUserAndPasswordDialog.this.password.getText();
            }
        }.getReturnValue();
    }

    @Override
    public boolean isRememberSelected() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return false;
        }
        return new EDTHelper<Boolean>(){

            public Boolean edtRun() {
                return AskForUserAndPasswordDialog.this.save.isSelected();
            }
        }.getReturnValue() == Boolean.TRUE;
    }
}

