/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.captcha;

import java.awt.event.MouseEvent;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solver.browser.BrowserSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogClickCaptchaSolver;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobListener;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.notify.BasicContentPanel;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.captcha.CaptchaBubbleSupport;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;

public class CaptchaNotify
extends AbstractNotifyWindow<BasicContentPanel>
implements ChallengeSolverJobListener {
    private SolverJob<?> job;

    public CaptchaNotify(CaptchaBubbleSupport captchaBubbleSupport, SolverJob<?> job) {
        super(captchaBubbleSupport, _GUI.T.CaptchaNotify_CaptchaNotify_title_(job.getChallenge().getHost()), new BasicContentPanel(_GUI.T.CaptchaNotify_CaptchaNotifyPanel_text(), NewTheme.I().getIcon("ocr", 32)));
        job.getEventSender().addListener(this, true);
        this.job = job;
    }

    @Override
    public void onSolverJobReceivedNewResponse(AbstractResponse<?> response) {
    }

    @Override
    public void onSolverDone(ChallengeSolver<?> solver) {
        if (this.job.isDone()) {
            this.close();
        }
    }

    @Override
    protected void onMouseClicked(MouseEvent m) {
        super.onMouseClicked(m);
        DialogBasicCaptchaSolver.getInstance().requestFocus(this.job.getChallenge());
        DialogClickCaptchaSolver.getInstance().requestFocus(this.job.getChallenge());
        BrowserSolver.getInstance().requestFocus(this.job.getChallenge());
        this.close();
    }

    private void close() {
        BubbleNotify.getInstance().hide(this);
        this.job.getEventSender().removeListener(this);
    }

    @Override
    public void onSolverStarts(ChallengeSolver<?> parameter) {
    }

    @Override
    public void onSolverTimedOut(ChallengeSolver<?> parameter) {
        if (this.job.isDone()) {
            this.close();
        }
    }
}

