/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.notify.gui;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import jd.gui.swing.jdgui.JDGui;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.gui.jdtrayicon.ScreenStack;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.BubbleNotifyConfig;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.logging.LogController;

public class Balloner
implements ComponentListener {
    private HashMap<GraphicsDevice, ScreenStack> stacks;
    private JFrame owner;
    private LogSource logger;
    private String screenID;
    private Point startPoint = new Point(-1, -1);
    private Point endPoint = new Point(-1, 0);
    private BubbleNotifyConfig.Anchor startAnchor = BubbleNotifyConfig.Anchor.TOP_RIGHT;
    private BubbleNotifyConfig.Anchor endAnchor = BubbleNotifyConfig.Anchor.BOTTOM_RIGHT;
    private Point anchorPoint;
    private BubbleNotifyConfig.Anchor anchor;

    public Balloner(JFrame owner) {
        this.owner = owner;
        this.stacks = new HashMap();
        this.logger = LogController.getInstance().getLogger(Balloner.class.getName());
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public void add(final AbstractNotifyWindow notify) {
        new EDTRunner(){

            protected void runInEDT() {
                ScreenStack screenStack = Balloner.this.getScreenStack();
                screenStack.add(notify);
                notify.setScreenStack(screenStack);
                notify.setController(Balloner.this);
                notify.addComponentListener(Balloner.this);
                Balloner.this.layout(screenStack);
                notify.setVisible(true);
                notify.setAlwaysOnTop(true);
            }
        };
    }

    protected void layout(ScreenStack screenStack) {
        Rectangle bounds = this.getVisibleBounds(screenStack);
        int y = 0;
        boolean x = false;
        int width = 0;
        for (AbstractNotifyWindow n : screenStack) {
            if (n.isDisposed()) continue;
            n.setPreferredSize(null);
            width = Math.max(width, n.getPreferredSize().width);
        }
        ArrayList<AbstractNotifyWindow> removes = new ArrayList<AbstractNotifyWindow>();
        for (AbstractNotifyWindow n : screenStack) {
            if (n.isDisposed()) {
                removes.add(n);
                n.removeComponentListener(this);
                continue;
            }
            Dimension ps = n.getPreferredSize();
            ps.width = width;
            n.setPreferredSize(ps);
            n.pack();
            Point sl = this.calculateLocation(bounds, ps, this.startAnchor, this.startPoint);
            Point el = this.calculateLocation(bounds, ps, this.endAnchor, this.endPoint);
            Point position = this.calculateLocation(bounds, ps, this.anchor, this.anchorPoint);
            position.y += y;
            if (el.x != position.x) {
                el.y += y;
            }
            n.setStartLocation(sl);
            n.setEndLocation(el);
            n.setPreferedLocation(position.x, position.y);
            if (this.anchorPoint.y < 0) {
                y -= ps.height + this.getMargin();
                continue;
            }
            y += ps.height + this.getMargin();
        }
        screenStack.removeAll(removes);
    }

    private Point calculateLocation(Rectangle bounds, Dimension ps, BubbleNotifyConfig.Anchor anchor, Point point) {
        int ax = 0;
        int ay = 0;
        switch (anchor) {
            case BOTTOM_LEFT: {
                ay += ps.height;
                ax += 0;
                break;
            }
            case BOTTOM_RIGHT: {
                ay += ps.height;
                ax += ps.width;
                break;
            }
            case TOP_LEFT: {
                ay += 0;
                ax += 0;
                break;
            }
            case TOP_RIGHT: {
                ay += 0;
                ax += ps.width;
            }
        }
        int px = 0;
        int py = 0;
        px = point.x < 0 ? bounds.x + bounds.width + point.x + 1 : bounds.x + this.startPoint.x;
        py = point.y < 0 ? bounds.y + bounds.height + point.y + 1 : bounds.y + point.y;
        return new Point(px - ax, py - ay);
    }

    protected int getMargin() {
        return 10;
    }

    protected Rectangle getVisibleBounds(ScreenStack screenStack) {
        if (CFG_BUBBLE.CFG.isBubbleAnchorRelativeToWindow() && JDGui.getInstance().getMainFrame().isVisible() && WindowManager.getInstance().hasFocus((Window)JDGui.getInstance().getMainFrame())) {
            Rectangle ret = JDGui.getInstance().getMainFrame().getBounds();
            return ret;
        }
        Rectangle bounds = screenStack.getScreen().getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(screenStack.getScreen().getDefaultConfiguration());
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public void hide(AbstractNotifyWindow notify) {
        notify.onClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScreenStack getScreenStack() {
        GraphicsDevice screen = this.getScreenDevice();
        HashMap<GraphicsDevice, ScreenStack> hashMap = this.stacks;
        synchronized (hashMap) {
            ScreenStack ret = this.stacks.get(screen);
            if (ret == null) {
                ret = new ScreenStack(screen);
                this.stacks.put(screen, ret);
            }
            return ret;
        }
    }

    protected GraphicsDevice getScreenDevice() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        if (this.getScreenID() != null) {
            for (GraphicsDevice screen : screens) {
                if (!StringUtils.equalsIgnoreCase((String)this.getScreenID(), (String)screen.getIDstring())) continue;
                return screen;
            }
        }
        if (this.getOwner() == null) {
            return ge.getDefaultScreenDevice();
        }
        Rectangle preferedRect = this.getOwner().getBounds();
        GraphicsDevice biggestInteresctionScreem = null;
        int biggestIntersection = -1;
        for (GraphicsDevice screen : screens) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(screen.getDefaultConfiguration());
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            Rectangle interSec = bounds.intersection(preferedRect);
            if (Math.max(interSec.width, 0) * Math.max(interSec.height, 0) <= biggestIntersection && biggestInteresctionScreem != null) continue;
            biggestIntersection = Math.max(interSec.width, 0) * Math.max(interSec.height, 0);
            biggestInteresctionScreem = screen;
            if (interSec.equals(preferedRect)) break;
        }
        return biggestInteresctionScreem;
    }

    private String getScreenID() {
        return this.screenID;
    }

    public void setScreenID(String screenID) {
        this.screenID = screenID;
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (e.getSource() instanceof AbstractNotifyWindow) {
            AbstractNotifyWindow notify = (AbstractNotifyWindow)e.getSource();
            this.remove(notify);
        }
    }

    public void remove(AbstractNotifyWindow notify) {
        ScreenStack screenStack = this.getScreenStack();
        screenStack.remove(notify);
        notify.removeComponentListener(this);
        this.layout(screenStack);
    }

    public void setStartPoint(Point point, BubbleNotifyConfig.Anchor anchor) {
        this.startPoint = point;
        this.startAnchor = anchor;
    }

    public void setEndPoint(Point point, BubbleNotifyConfig.Anchor anchor) {
        this.endPoint = point;
        this.endAnchor = anchor;
    }

    public void setAnchorPoint(Point point, BubbleNotifyConfig.Anchor anchor) {
        this.anchorPoint = point;
        this.anchor = anchor;
    }

    public void relayout() {
        ScreenStack screenStack = this.getScreenStack();
        this.layout(screenStack);
    }
}

