/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.packagehistorycontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.TaskQueue;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.gui.packagehistorycontroller.HistoryEntry;

public abstract class HistoryManager<T extends HistoryEntry> {
    protected final ArrayList<T> packageHistory;
    private final AtomicLong saveRequest = new AtomicLong(-1L);

    public HistoryManager(List<T> packageNameHistory) {
        try {
            ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

                public void onShutdown(ShutdownRequest shutdownRequest) {
                    HistoryManager.this.save(HistoryManager.this.list());
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.packageHistory = packageNameHistory == null ? new ArrayList() : new ArrayList<T>(packageNameHistory);
        Collections.sort(this.packageHistory);
        int packageHistoryIndex = 0;
        int max = Math.max(0, this.getMaxLength());
        Iterator<T> it = this.packageHistory.iterator();
        while (it.hasNext()) {
            HistoryEntry next = (HistoryEntry)it.next();
            if (next == null || StringUtils.isEmpty((String)next.getName()) || !this.isValid(next.getName())) {
                it.remove();
                continue;
            }
            if (packageHistoryIndex++ < max) continue;
            it.remove();
        }
    }

    protected abstract int getMaxLength();

    public synchronized List<T> list() {
        return new ArrayList<T>(this.packageHistory);
    }

    public synchronized void clear() {
        this.packageHistory.clear();
    }

    protected synchronized boolean contains(String packageName) {
        if (!StringUtils.isEmpty((String)packageName)) {
            for (HistoryEntry existing : this.packageHistory) {
                if (!existing.getName().equalsIgnoreCase(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    protected synchronized T get(String packageName) {
        if (!StringUtils.isEmpty((String)packageName)) {
            for (HistoryEntry existing : this.packageHistory) {
                if (!existing.getName().equalsIgnoreCase(packageName)) continue;
                return (T)existing;
            }
        }
        return null;
    }

    protected boolean isValid(String input) {
        return true;
    }

    public synchronized void add(String packageName) {
        if (!StringUtils.isEmpty((String)packageName) && this.isValid(packageName)) {
            boolean found = false;
            for (HistoryEntry existing : this.packageHistory) {
                if (!existing.getName().equalsIgnoreCase(packageName)) continue;
                existing.setTime(System.currentTimeMillis());
                found = true;
                break;
            }
            if (!found) {
                T newOne = this.createNew(packageName);
                newOne.setTime(System.currentTimeMillis());
                this.packageHistory.add(0, newOne);
            } else {
                Collections.sort(this.packageHistory);
            }
            int max = Math.max(0, this.getMaxLength());
            while (this.packageHistory.size() > max) {
                this.packageHistory.remove(this.packageHistory.size() - 1);
            }
            final long saveRequest = this.saveRequest.incrementAndGet();
            TaskQueue.getQueue().addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    if (saveRequest == HistoryManager.this.saveRequest.get()) {
                        HistoryManager.this.save(HistoryManager.this.list());
                    }
                    return null;
                }
            });
        }
    }

    protected abstract T createNew(String var1);

    protected abstract void save(List<T> var1);
}

