/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.toolbar.action;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;

public abstract class AbstractToolbarToggleAction
extends AbstractToolBarAction
implements GenericConfigEventListener<Boolean> {
    private final BooleanKeyHandler keyHandler;

    protected BooleanKeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public AbstractToolbarToggleAction(BooleanKeyHandler keyHandler) {
        this.keyHandler = keyHandler;
        keyHandler.getEventSender().addListener((EventListener)this, true);
        this.setSelected(keyHandler.isEnabled());
    }

    public void setSelected(final boolean selected) {
        new EDTRunner(){

            protected void runInEDT() {
                AbstractToolbarToggleAction.super.setSelected(selected);
                if (selected) {
                    AbstractToolbarToggleAction.this.setName(AbstractToolbarToggleAction.this.getNameWhenEnabled());
                } else {
                    AbstractToolbarToggleAction.this.setName(AbstractToolbarToggleAction.this.getNameWhenDisabled());
                }
            }
        };
    }

    protected abstract String getNameWhenDisabled();

    protected abstract String getNameWhenEnabled();

    public void actionPerformed(ActionEvent e) {
        boolean sel = !this.keyHandler.isEnabled();
        this.keyHandler.setValue((Object)sel);
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        if (keyHandler == this.keyHandler) {
            this.setSelected(newValue);
        }
    }
}

