/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.toolbar.action;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import jd.controlling.captcha.CaptchaSettings;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.EnumKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;

public class CaptchaModeChangeAction
extends AbstractToolBarAction
implements GenericConfigEventListener<Enum> {
    private final EnumKeyHandler keyHandler;

    public CaptchaModeChangeAction() {
        this.setIconKey("dialogOCR");
        this.keyHandler = CFG_CAPTCHA.CAPTCHA_MODE;
        this.keyHandler.getEventSender().addListener((EventListener)this, true);
        this.setSelected((CaptchaSettings.MODE)((Object)this.keyHandler.getValue()));
    }

    public void setSelected(final CaptchaSettings.MODE mode) {
        new EDTRunner(){

            protected void runInEDT() {
                CaptchaSettings.MODE finalMode = mode == null ? CaptchaSettings.MODE.NORMAL : mode;
                CaptchaModeChangeAction.this.keyHandler.setValue((Object)finalMode);
                switch (finalMode) {
                    case NORMAL: {
                        CaptchaModeChangeAction.this.setSelected(true);
                        break;
                    }
                    case SKIP_ALL: {
                        CaptchaModeChangeAction.this.setSelected(false);
                    }
                }
                CaptchaModeChangeAction.this.setName(finalMode.name());
            }
        };
    }

    public void actionPerformed(ActionEvent e) {
        boolean sel = this.isSelected();
        if (sel) {
            this.setSelected(CaptchaSettings.MODE.NORMAL);
        } else {
            this.setSelected(CaptchaSettings.MODE.SKIP_ALL);
        }
    }

    public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
        this.setSelected((CaptchaSettings.MODE)newValue);
    }

    @Override
    protected String createTooltip() {
        return _GUI.T.CaptchaMode_createTooltip_();
    }
}

