/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jd.gui.swing.jdgui.views.settings.components.FolderChooser;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DownloadFolderChooserDialog
extends ExtFileChooserDialog {
    private JCheckBox cbPackage;
    private final File path;
    private boolean packageSubFolderSelectionVisible = false;
    private boolean subfolderFlag = false;

    public DownloadFolderChooserDialog(File path, String title, String okOption, String cancelOption) {
        super(0, title, okOption, cancelOption);
        StackTraceElement[] st = new Exception().getStackTrace();
        String id = "DownloadFolderChooserDialog-";
        try {
            for (int i = 1; i < st.length; ++i) {
                StackTraceElement ste = new Exception().getStackTrace()[i];
                if (ste.getClassName().contains(DownloadFolderChooserDialog.class.getName())) continue;
                id = id + ste.getClassName();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension(id));
        GraphicalUserInterfaceSettings.DownloadFolderChooserDialogSubfolder subfolderSettings = CFG_GUI.CFG.getDownloadFolderChooserDialogSubfolder();
        if (subfolderSettings == null) {
            subfolderSettings = GraphicalUserInterfaceSettings.DownloadFolderChooserDialogSubfolder.AUTO;
        }
        if (path != null) {
            if (path.getAbsolutePath().endsWith("<jd:packagename>")) {
                this.subfolderFlag = true;
                path = path.getParentFile();
            }
            this.setPreSelection(path);
        }
        this.path = path;
        switch (subfolderSettings) {
            case ENABLED: {
                this.subfolderFlag = true;
                break;
            }
            case DISABLED: {
                this.subfolderFlag = false;
                break;
            }
        }
        this.setView(CFG_GUI.CFG.getFileChooserView());
    }

    public void dispose() {
        try {
            File[] dest;
            if (this.isInitialized() && (dest = this.createReturnValue()) != null && dest.length > 0) {
                dest[0] = FolderChooser.checkPath((File)dest[0], null);
                if (dest[0] != null) {
                    DownloadPathHistoryManager.getInstance().add(dest[0].getAbsolutePath());
                }
            }
        }
        finally {
            super.dispose();
        }
    }

    protected File[] createReturnValue() {
        CFG_GUI.CFG.setFileChooserView(this.getView());
        if (this.isMultiSelection()) {
            File[] files = this.fc.getSelectedFiles();
            return files;
        }
        File f = this.fc.getSelectedFile();
        if (f == null) {
            String path = this.getText();
            if (!StringUtils.isEmpty((String)path) && this.isAllowedPath(path)) {
                f = new File(path);
                if (this.isSambaFolder(f)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (this.cbPackage != null) {
            if (this.cbPackage.isSelected()) {
                if (f.getAbsolutePath().endsWith("<jd:packagename>")) {
                    return new File[]{f};
                }
                return new File[]{new File(f, "<jd:packagename>")};
            }
            if (f.getAbsolutePath().endsWith("<jd:packagename>")) {
                return new File[]{f.getParentFile()};
            }
            return new File[]{f};
        }
        return new File[]{f};
    }

    public JComponent layoutDialogContent() {
        MigPanel ret;
        if (this.path != null) {
            ret = new MigPanel("ins 0,wrap 2", "[grow,fill][]", "[][][][grow,fill]");
            ExtTextField lbl = new ExtTextField();
            lbl.setText(_GUI.T.OpenDownloadFolderAction_layoutDialogContent_current_(this.path.getAbsolutePath()));
            lbl.setEditable(false);
            if (CrossSystem.isOpenFileSupported()) {
                ret.add((Component)lbl);
                ret.add((Component)new JButton((Action)((Object)new AppAction(){
                    {
                        this.setName(_GUI.T.OpenDownloadFolderAction_actionPerformed_button_());
                    }

                    public void actionPerformed(ActionEvent e) {
                        CrossSystem.openFile((File)DownloadFolderChooserDialog.this.path);
                    }
                })), (Object)"height 20!");
            } else {
                ret.add((Component)lbl, (Object)"spanx");
            }
            ret.add((Component)new JSeparator(), (Object)"spanx");
        } else {
            ret = new MigPanel("ins 0,wrap 2", "[grow,fill][]", "[][grow,fill]");
        }
        ret.add((Component)new JLabel(_GUI.T.OpenDownloadFolderAction_layoutDialogContent_object_()), (Object)"spanx");
        ret.add((Component)super.layoutDialogContent(), (Object)"spanx");
        return ret;
    }

    protected void modifiyNamePanel(JPanel namePanel) {
        if (this.isPackageSubFolderSelectionVisible()) {
            namePanel.setLayout((LayoutManager)new MigLayout("ins 0, wrap 2", "[][grow,fill]", "[][]"));
            namePanel.add(new JLabel(_GUI.T.SetDownloadFolderInDownloadTableAction_modifiyNamePanel_package_()));
            this.cbPackage = new JCheckBox();
            this.cbPackage.setSelected(this.subfolderFlag);
            namePanel.add(this.cbPackage);
        }
    }

    public static File open(File path, boolean packager, String title) throws DialogClosedException, DialogCanceledException {
        if (path != null && !CrossSystem.isAbsolutePath((String)path.getPath())) {
            path = new File(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue(), path.getPath());
        }
        boolean lastUsedPathMode = false;
        switch (CFG_GUI.CFG.getDownloadFolderChooserDefaultPath()) {
            case CURRENT_PATH: {
                break;
            }
            case GLOBAL_DOWNLOAD_DIRECTORY: {
                path = new File(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue());
                break;
            }
            case LAST_USED_PATH: {
                lastUsedPathMode = true;
                path = null;
            }
        }
        final File finalPath = path;
        final DownloadFolderChooserDialog d = new DownloadFolderChooserDialog(path, title, _GUI.T.OpenDownloadFolderAction_actionPerformed_save_(), null);
        d.setPackageSubFolderSelectionVisible(packager);
        if (CrossSystem.isOpenFileSupported()) {
            d.setLeftActions(new AbstractAction[]{new AppAction(){
                {
                    this.setName(_GUI.T.OpenDownloadFolderAction_actionPerformed_button_());
                }

                public void actionPerformed(ActionEvent e) {
                    CrossSystem.openFile((File)(d.getSelection()[0] == null ? finalPath : d.getSelection()[0]));
                }
            }});
        }
        List<String> quick = DownloadPathHistoryManager.getInstance().listPaths(path != null ? path.getAbsolutePath() : null);
        d.setQuickSelectionList(quick);
        if (lastUsedPathMode && quick != null && quick.size() > 0) {
            d.setPreSelection(new File(quick.get(0)));
        }
        d.setFileSelectionMode(FileChooserSelectionMode.DIRECTORIES_ONLY);
        File[] dest = (File[])Dialog.getInstance().showDialog((AbstractDialog)d);
        if (dest == null || dest.length == 0) {
            return null;
        }
        dest[0] = FolderChooser.checkPath((File)dest[0], null);
        if (dest[0] == null) {
            return null;
        }
        return dest[0];
    }

    private void setPackageSubFolderSelectionVisible(boolean packager) {
        this.packageSubFolderSelectionVisible = packager;
    }

    public boolean isPackageSubFolderSelectionVisible() {
        return this.packageSubFolderSelectionVisible;
    }
}

