/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.controlling.packagecontroller.PackageControllerQueue;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.gui.views.BadContextException;

public class SelectionInfo<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>> {
    protected final List<AbstractNode> rawSelection;
    private final AbstractNode contextObject;
    protected final PackageController<PackageType, ChildrenType> controller;
    protected final ArrayList<ChildrenType> children = new ArrayList();
    protected final HashMap<PluginForHost, PluginView<ChildrenType>> pluginViews = new HashMap();
    protected final AtomicBoolean pluginViewsInitiated = new AtomicBoolean(false);
    protected final List<PackageView<PackageType, ChildrenType>> packageViewList = new ArrayList<PackageView<PackageType, ChildrenType>>();
    protected final HashMap<PackageType, PackageView<PackageType, ChildrenType>> packageViews = new HashMap();

    public PackageController<PackageType, ChildrenType> getController() {
        return this.controller;
    }

    public SelectionInfo(AbstractNode contextObject) {
        this(contextObject, new ArrayList(0));
    }

    protected SelectionInfo(PackageController<PackageType, ChildrenType> controller) {
        this.contextObject = null;
        this.rawSelection = new ArrayList<AbstractNode>();
        this.controller = controller;
    }

    public SelectionInfo(AbstractNode contextObject, List<? extends AbstractNode> selection) {
        this.contextObject = contextObject;
        if (selection == null || selection.size() == 0) {
            if (contextObject == null) {
                this.rawSelection = new ArrayList<AbstractNode>(0);
            } else {
                ArrayList<AbstractNode> rawSelection = new ArrayList<AbstractNode>(1);
                rawSelection.add(contextObject);
                this.rawSelection = rawSelection;
            }
        } else {
            this.rawSelection = selection;
        }
        PackageController controller = contextObject != null ? (contextObject instanceof DownloadLink || contextObject instanceof FilePackage ? DownloadController.getInstance() : LinkCollector.getInstance()) : (this.rawSelection != null && this.rawSelection.size() > 0 && this.rawSelection.get(0) != null ? (this.rawSelection.get(0) instanceof DownloadLink || this.rawSelection.get(0) instanceof FilePackage ? DownloadController.getInstance() : LinkCollector.getInstance()) : null);
        if (controller != null) {
            this.aggregate(controller.getQueue());
        } else {
            this.aggregate(null);
        }
        this.controller = controller;
    }

    protected void aggregate(Queue queue) {
        if (queue != null) {
            queue.addWait((QueueAction)new PackageControllerQueue.ReadOnlyQueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

                protected Void run() throws RuntimeException {
                    SelectionInfo.this.aggregate();
                    return null;
                }
            });
        } else {
            this.aggregate();
        }
    }

    public List<ChildrenType> getUnselectedChildren() {
        return null;
    }

    public boolean contains(AbstractPackageChildrenNode<?> child) {
        Object parentNode = child.getParentNode();
        PackageView<PackageType, ChildrenType> packageView = this.getPackageViewsMap().get(parentNode);
        return packageView != null && packageView.getChildren().contains(child) || this.getChildren().contains(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aggregate() {
        boolean isExpanded;
        PackageView packageView;
        ArrayList packages = new ArrayList();
        ArrayList children = new ArrayList();
        int rawSize = this.getRawSelection().size();
        for (int rawIndex = 0; rawIndex < rawSize; ++rawIndex) {
            AbstractPackageChildrenNode child;
            AbstractNode node = this.getRawSelection().get(rawIndex);
            if (node instanceof AbstractPackageNode) {
                packages.add(new IndexedContainer((AbstractPackageNode)node, rawIndex));
                continue;
            }
            if (!(node instanceof AbstractPackageChildrenNode) || (child = (AbstractPackageChildrenNode)node).getParentNode() == null) continue;
            children.add(new IndexedContainer((AbstractPackageChildrenNode)node, rawIndex));
        }
        Comparator<IndexedContainer<? extends AbstractNode>> uniqueCmp = new Comparator<IndexedContainer<? extends AbstractNode>>(){

            @Override
            public int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(IndexedContainer<? extends AbstractNode> o1, IndexedContainer<? extends AbstractNode> o2) {
                return this.compare(o1.getObject().getUniqueID().getID(), o2.getObject().getUniqueID().getID());
            }
        };
        Comparator indexCmp = new Comparator<IndexedContainer<?>>(){

            @Override
            public int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(IndexedContainer<?> o1, IndexedContainer<?> o2) {
                return this.compare(o1.getIndex(), o2.getIndex());
            }
        };
        Collections.sort(packages, uniqueCmp);
        AbstractPackageNode lastPackage = null;
        HashSet<UniqueAlltimeID> selectedPackages = new HashSet<UniqueAlltimeID>();
        for (IndexedContainer indexedContainer : packages) {
            if (lastPackage != null && lastPackage == indexedContainer.getObject()) continue;
            lastPackage = (AbstractPackageNode)indexedContainer.getObject();
            selectedPackages.add(lastPackage.getUniqueID());
        }
        Collections.sort(children, uniqueCmp);
        AbstractPackageChildrenNode lastChild = null;
        ArrayList<IndexedContainer> arrayList = new ArrayList<IndexedContainer>();
        for (IndexedContainer indexedContainer : children) {
            if (lastChild != null && lastChild == indexedContainer.getObject()) continue;
            lastChild = (AbstractPackageChildrenNode)indexedContainer.getObject();
            arrayList.add(indexedContainer);
        }
        children.clear();
        children = null;
        Collections.sort(arrayList, indexCmp);
        Collections.sort(arrayList, new Comparator<IndexedContainer<ChildrenType>>(){

            @Override
            public int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(IndexedContainer<ChildrenType> o1, IndexedContainer<ChildrenType> o2) {
                return this.compare(((AbstractPackageNode)((AbstractPackageChildrenNode)o1.getObject()).getParentNode()).getUniqueID().getID(), ((AbstractPackageNode)((AbstractPackageChildrenNode)o2.getObject()).getParentNode()).getUniqueID().getID());
            }
        });
        lastPackage = null;
        int index = 0;
        ArrayList arrayList2 = new ArrayList();
        final ArrayList<Object> fillChildren = new ArrayList<Object>();
        int packageIndex = 0;
        for (IndexedContainer indexedContainer : arrayList) {
            if (lastPackage == null) {
                lastPackage = (AbstractPackageNode)((AbstractPackageChildrenNode)indexedContainer.getObject()).getParentNode();
                index = fillChildren.size();
                packageIndex = indexedContainer.getIndex();
                fillChildren.add(indexedContainer.getObject());
                continue;
            }
            if (lastPackage != ((AbstractPackageChildrenNode)indexedContainer.getObject()).getParentNode()) {
                final int finalIndex = index;
                final int finalSize = fillChildren.size() - finalIndex;
                final boolean isPackageSelected = selectedPackages.remove((Object)lastPackage.getUniqueID());
                final boolean isExpanded2 = lastPackage.isExpanded();
                final AbstractPackageNode pkg = lastPackage;
                packageView = new PackageView<PackageType, ChildrenType>(){

                    @Override
                    public boolean isPackageSelected() {
                        return isPackageSelected;
                    }

                    @Override
                    public boolean isExpanded() {
                        return isExpanded2;
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return fillChildren.subList(finalIndex, finalIndex + finalSize);
                    }

                    @Override
                    public PackageType getPackage() {
                        return pkg;
                    }

                    @Override
                    public List<ChildrenType> getChildren() {
                        return fillChildren.subList(finalIndex, finalIndex + finalSize);
                    }
                };
                arrayList2.add(new IndexedContainer(packageView, packageIndex));
                index = fillChildren.size();
                fillChildren.add(indexedContainer.getObject());
                lastPackage = (AbstractPackageNode)((AbstractPackageChildrenNode)indexedContainer.getObject()).getParentNode();
                packageIndex = indexedContainer.getIndex();
                continue;
            }
            fillChildren.add(indexedContainer.getObject());
        }
        if (lastPackage != null) {
            final int finalIndex = index;
            final int n = fillChildren.size() - finalIndex;
            final boolean isPackageSelected = selectedPackages.remove((Object)lastPackage.getUniqueID());
            isExpanded = lastPackage.isExpanded();
            final AbstractPackageNode pkg = lastPackage;
            PackageView packageView2 = new PackageView<PackageType, ChildrenType>(){

                @Override
                public boolean isPackageSelected() {
                    return isPackageSelected;
                }

                @Override
                public boolean isExpanded() {
                    return isExpanded;
                }

                @Override
                public List<ChildrenType> getSelectedChildren() {
                    return fillChildren.subList(finalIndex, finalIndex + n);
                }

                @Override
                public PackageType getPackage() {
                    return pkg;
                }

                @Override
                public List<ChildrenType> getChildren() {
                    return fillChildren.subList(finalIndex, finalIndex + n);
                }
            };
            arrayList2.add(new IndexedContainer(packageView2, packageIndex));
        }
        for (IndexedContainer indexedContainer : packages) {
            int finalSize;
            if (!selectedPackages.remove((Object)((AbstractPackageNode)indexedContainer.getObject()).getUniqueID())) continue;
            final AbstractPackageNode pkgO = (AbstractPackageNode)indexedContainer.getObject();
            isExpanded = pkgO.isExpanded();
            final int finalIndex = fillChildren.size();
            boolean readL = pkgO.getModifyLock().readLock();
            try {
                finalSize = pkgO.getChildren().size();
                fillChildren.addAll(pkgO.getChildren());
            }
            finally {
                pkgO.getModifyLock().readUnlock(readL);
            }
            packageView = new PackageView<PackageType, ChildrenType>(){

                @Override
                public boolean isPackageSelected() {
                    return true;
                }

                @Override
                public boolean isExpanded() {
                    return isExpanded;
                }

                @Override
                public List<ChildrenType> getSelectedChildren() {
                    return new ArrayList(0);
                }

                @Override
                public PackageType getPackage() {
                    return pkgO;
                }

                @Override
                public List<ChildrenType> getChildren() {
                    return fillChildren.subList(finalIndex, finalIndex + finalSize);
                }
            };
            arrayList2.add(new IndexedContainer(packageView, indexedContainer.getIndex()));
        }
        Collections.sort(arrayList2, indexCmp);
        for (IndexedContainer indexedContainer : arrayList2) {
            PackageView packageView2;
            int finalSize;
            PackageView fillPackageView = (PackageView)indexedContainer.getObject();
            final boolean selected = fillPackageView.isPackageSelected();
            final boolean expanded = fillPackageView.isExpanded();
            Object pkg = fillPackageView.getPackage();
            final int finalIndex = this.children.size();
            boolean readL = pkg.getModifyLock().readLock();
            try {
                List viewChildren = fillPackageView.getChildren();
                finalSize = viewChildren.size();
                this.children.addAll(viewChildren);
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
            if (fillPackageView.getSelectedChildren().size() == 0) {
                PackageView packageView3 = new PackageView<PackageType, ChildrenType>((AbstractPackageNode)pkg, finalIndex, finalSize){
                    final /* synthetic */ AbstractPackageNode val$pkg;
                    final /* synthetic */ int val$finalIndex;
                    final /* synthetic */ int val$finalSize;
                    {
                        this.val$pkg = abstractPackageNode;
                        this.val$finalIndex = n;
                        this.val$finalSize = n2;
                    }

                    @Override
                    public boolean isPackageSelected() {
                        return selected;
                    }

                    @Override
                    public boolean isExpanded() {
                        return expanded;
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return new ArrayList(0);
                    }

                    @Override
                    public PackageType getPackage() {
                        return this.val$pkg;
                    }

                    @Override
                    public List<ChildrenType> getChildren() {
                        return SelectionInfo.this.children.subList(this.val$finalIndex, this.val$finalIndex + this.val$finalSize);
                    }
                };
            } else {
                packageView2 = new PackageView<PackageType, ChildrenType>((AbstractPackageNode)pkg){
                    final /* synthetic */ AbstractPackageNode val$pkg;
                    {
                        this.val$pkg = abstractPackageNode;
                    }

                    @Override
                    public boolean isPackageSelected() {
                        return selected;
                    }

                    @Override
                    public boolean isExpanded() {
                        return expanded;
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return SelectionInfo.this.children.subList(finalIndex, finalIndex + finalSize);
                    }

                    @Override
                    public PackageType getPackage() {
                        return this.val$pkg;
                    }

                    @Override
                    public List<ChildrenType> getChildren() {
                        return SelectionInfo.this.children.subList(finalIndex, finalIndex + finalSize);
                    }
                };
            }
            this.addPackageView(packageView2, pkg);
        }
    }

    protected PluginView<ChildrenType> internalPluginView(ChildrenType node, PluginView<ChildrenType> lastPluginView) {
        PluginForHost plugin;
        PluginForHost pluginForHost = plugin = node instanceof CrawledLink ? ((CrawledLink)node).gethPlugin() : ((DownloadLink)node).getDefaultPlugin();
        if (lastPluginView != null && lastPluginView.getPlugin() == plugin) {
            return lastPluginView;
        }
        PluginView<ChildrenType> pv = this.pluginViews.get(plugin);
        if (pv == null) {
            pv = new PluginView(plugin);
            this.pluginViews.put(plugin, pv);
        }
        return pv;
    }

    public synchronized Collection<PluginView<ChildrenType>> getPluginViews() {
        if (!this.pluginViewsInitiated.get()) {
            PluginView<AbstractPackageChildrenNode> lastPluginView = null;
            for (AbstractPackageChildrenNode child : this.getChildren()) {
                lastPluginView = this.internalPluginView(child, lastPluginView);
                lastPluginView.add(child);
            }
            this.pluginViewsInitiated.set(true);
        }
        return this.pluginViews.values();
    }

    protected void addPackageView(PackageView<PackageType, ChildrenType> packageView, PackageType pkg) {
        this.getPackageViews().add(packageView);
        this.getPackageViewsMap().put(pkg, packageView);
    }

    public ChildrenType getLink() {
        return this.getContextLink();
    }

    public ChildrenType getContextLink() {
        if (this.isLinkContext()) {
            return (ChildrenType)((AbstractPackageChildrenNode)this.getRawContext());
        }
        throw new BadContextException("Not available in Packagecontext");
    }

    public AbstractNode getRawContext() {
        return this.contextObject;
    }

    public PackageType getContextPackage() {
        AbstractNode context = this.getRawContext();
        if (context == null) {
            throw new BadContextException("Context is null");
        }
        if (this.isPackageContext()) {
            return (PackageType)((AbstractPackageNode)context);
        }
        return (PackageType)((AbstractPackageNode)((AbstractPackageChildrenNode)context).getParentNode());
    }

    public PackageType getFirstPackage() {
        AbstractNode context = this.getRawContext();
        if (context == null) {
            List<PackageView<PackageType, ChildrenType>> packageViews = this.getPackageViews();
            if (packageViews.size() == 0) {
                throw new BadContextException("Invalid Context");
            }
            return packageViews.get(0).getPackage();
        }
        return this.getContextPackage();
    }

    public PackageType getPackage() {
        return this.getContextPackage();
    }

    public List<AbstractNode> getRawSelection() {
        return this.rawSelection;
    }

    public List<ChildrenType> getChildren() {
        return this.children;
    }

    public boolean isLinkContext() {
        AbstractNode context = this.getRawContext();
        return context != null && context instanceof AbstractPackageChildrenNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPackageSelectionComplete(PackageType pkg) {
        PackageView<PackageType, ChildrenType> packageView = this.getPackageViewsMap().get(pkg);
        if (packageView != null) {
            long[] pkgUUIDs;
            int index;
            int size;
            long checkSumPackage;
            block13: {
                checkSumPackage = 0L;
                boolean readL = pkg.getModifyLock().readLock();
                size = packageView.getChildren().size();
                index = 0;
                try {
                    if (pkg.getChildren().size() == size) {
                        if (size == 0) {
                            boolean bl = true;
                            return bl;
                        }
                        pkgUUIDs = new long[size];
                        for (AbstractPackageChildrenNode child : pkg.getChildren()) {
                            long childUUID = child.getUniqueID().getID();
                            pkgUUIDs[index++] = childUUID;
                            checkSumPackage += childUUID;
                        }
                        break block13;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    pkg.getModifyLock().readUnlock(readL);
                }
            }
            long checkSumView = 0L;
            for (AbstractPackageChildrenNode child : packageView.getChildren()) {
                checkSumView += child.getUniqueID().getID();
            }
            if (checkSumPackage == checkSumView) {
                long[] viewUUIDS = new long[size];
                index = 0;
                for (AbstractPackageChildrenNode child : packageView.getChildren()) {
                    viewUUIDS[index++] = child.getUniqueID().getID();
                }
                Arrays.sort(viewUUIDS);
                Arrays.sort(pkgUUIDs);
                if (viewUUIDS[0] == pkgUUIDs[0] && viewUUIDS[size - 1] == pkgUUIDs[size - 1]) {
                    for (index = 0; index < size; ++index) {
                        if (viewUUIDS[index] == pkgUUIDs[index]) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEmpty(SelectionInfo<?, ?> selectionInfo) {
        return selectionInfo == null || selectionInfo.isEmpty();
    }

    public static boolean isNotEmpty(SelectionInfo<?, ?> selectionInfo) {
        return selectionInfo != null && !selectionInfo.isEmpty();
    }

    public boolean isEmpty() {
        return this.getPackageViews().size() == 0 || this.getChildren().size() == 0;
    }

    public boolean isPackageContext() {
        AbstractNode context = this.getRawContext();
        return context != null && context instanceof AbstractPackageNode;
    }

    public List<PackageView<PackageType, ChildrenType>> getPackageViews() {
        return this.packageViewList;
    }

    protected Map<PackageType, PackageView<PackageType, ChildrenType>> getPackageViewsMap() {
        return this.packageViews;
    }

    public PackageView<PackageType, ChildrenType> getPackageView(PackageType entry) {
        return this.getPackageViewsMap().get(entry);
    }

    private static class IndexedContainer<E> {
        private final E object;
        private final int index;

        public E getObject() {
            return this.object;
        }

        public int getIndex() {
            return this.index;
        }

        private IndexedContainer(E object, int index) {
            this.object = object;
            this.index = index;
        }
    }

    public static interface PackageView<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>> {
        public List<ChildrenType> getChildren();

        public PackageType getPackage();

        public boolean isPackageSelected();

        public List<ChildrenType> getSelectedChildren();

        public boolean isExpanded();
    }

    public static class PluginView<ChildrenType>
    extends ArrayList<ChildrenType> {
        private final PluginForHost plugin;

        public PluginView(PluginForHost pkg) {
            this.plugin = pkg;
        }

        public List<ChildrenType> getChildren() {
            return this;
        }

        public PluginForHost getPlugin() {
            return this.plugin;
        }
    }
}

