/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import jd.gui.swing.laf.LookAndFeelController;
import org.appwork.app.gui.BasicGui;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberPanel;
import org.jdownloader.updatev2.gui.LAFOptions;
import org.jdownloader.updatev2.gui.LookAndFeelExtension;

public class HeaderScrollPane
extends JScrollPane {
    private LookAndFeelExtension lafExtension = LAFOptions.getInstance().getExtension();

    public static void main(String[] args) {
        LookAndFeelController.getInstance().setUIManager();
        new BasicGui("TEst"){

            protected void requestExit() {
            }

            protected void layoutPanel() {
                this.getFrame().add((Component)((Object)new LinkGrabberPanel()));
            }
        };
    }

    public HeaderScrollPane(JComponent sidebar) {
        super(sidebar);
        JScrollBar sb = new JScrollBar(){
            {
                this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
            }

            @Override
            public void setBounds(Rectangle rec) {
                if (rec != null) {
                    if (HeaderScrollPane.this.getColumnHeader() != null && HeaderScrollPane.this.getBorder() != null) {
                        int newY = HeaderScrollPane.this.getColumnHeader().getHeight() + HeaderScrollPane.this.getBorder().getBorderInsets((Component)HeaderScrollPane.this).top;
                        int newHeight = rec.height + (rec.y - newY);
                        rec.y = newY;
                        rec.height = newHeight;
                        super.setBounds(rec);
                    } else {
                        super.setBounds(rec);
                    }
                }
            }
        };
        this.setVerticalScrollBar(sb);
        this.getVerticalScrollBar().setBlockIncrement(15);
        JTableHeader tableHeader = new JTableHeader();
        tableHeader.setTable(new JTable());
        this.setCorner("UPPER_RIGHT_CORNER", tableHeader);
        LAFOptions.getInstance().getExtension().customizeHeaderScrollPane((JComponent)this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        this.lafExtension.customizePaintHeaderScrollPaneBorder((JComponent)this, g);
        super.paintBorder(g);
    }

    @Override
    public void setColumnHeader(JViewport columnHeader) {
        super.setColumnHeader(columnHeader);
    }

    protected int getPrefHeaderHeight() {
        return this.getColumnHeader() == null ? 0 : this.getColumnHeader().getPreferredSize().height;
    }

    public int getHeaderHeight() {
        return this.getColumnHeader() == null ? 0 : this.getColumnHeader().getHeight();
    }
}

