/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import org.jdownloader.actions.AppAction;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public class PseudoCombo<Type>
extends JButton {
    protected volatile Type selectedItem = null;
    private Type[] values;
    private boolean popDown = false;
    private long lastHide = 0L;
    private boolean closed = true;

    public PseudoCombo(Type[] values) {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PseudoCombo.this.onPopup();
            }
        });
        this.setHorizontalAlignment(2);
        this.setValues(values);
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    public void setValues(Type[] values) {
        this.values = values;
        Insets m = this.getMargin();
        if (m == null) {
            m = new Insets(0, 0, 0, 0);
        }
        m.right = this.getPopIcon(true).getIconWidth() + 5;
        this.setMargin(m);
        int width = 0;
        for (Type v : values) {
            this.setText(this.getLabel(v, true));
            this.setIcon(this.getIcon(v, true));
            width = Math.max(width, this.getPreferredSize().width);
        }
        this.setPreferredSize(new Dimension(width, 24));
    }

    protected Icon getPopIcon(boolean closed) {
        if (closed) {
            if (this.isPopDown()) {
                return NewTheme.I().getIcon("popDownSmall", -1);
            }
            return NewTheme.I().getIcon("popUpSmall", -1);
        }
        if (this.isPopDown()) {
            return NewTheme.I().getIcon("popUpSmall", -1);
        }
        return NewTheme.I().getIcon("popDownSmall", -1);
    }

    public boolean isPopDown() {
        return this.popDown;
    }

    public void setPopDown(boolean popDown) {
        this.popDown = popDown;
    }

    protected Icon getIcon(Type v, boolean closed) {
        return null;
    }

    protected String getLabel(Type v, boolean closed) {
        return v + "";
    }

    protected void onPopup() {
        long timeSinceLastHide = System.currentTimeMillis() - this.lastHide;
        if (timeSinceLastHide < 250L) {
            return;
        }
        JPopupMenu popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                if (!b) {
                    PseudoCombo.this.lastHide = System.currentTimeMillis();
                }
                super.setVisible(b);
                PseudoCombo.this.closed = true;
                PseudoCombo.this.repaint();
            }
        };
        for (final Type sc : this.values) {
            if (sc == this.selectedItem && this.isHideSelf()) continue;
            popup.add((Action)((Object)new AppAction(){
                private Type value;
                {
                    this.value = sc;
                    this.setName(PseudoCombo.this.getLabel(sc, false));
                    this.setSmallIcon(PseudoCombo.this.getIcon(sc, false));
                }

                public void actionPerformed(ActionEvent e) {
                    PseudoCombo.this.setSelectedItem(this.value);
                }
            }));
        }
        Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
        Dimension pref = popup.getPreferredSize();
        popup.setPreferredSize(new Dimension((int)Math.max((double)(this.getWidth() + insets.left + insets.right), pref.getWidth()), (int)pref.getHeight()));
        if (this.isPopDown()) {
            popup.show(this, -insets.left, this.getHeight() + insets.top);
        } else {
            popup.show(this, -insets.left, -popup.getPreferredSize().height + insets.bottom);
        }
        this.closed = false;
    }

    protected boolean isHideSelf() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Icon icon = this.getPopIcon(this.closed);
        if (!this.isEnabled()) {
            icon = NewTheme.I().getDisabledIcon(icon);
        }
        icon.paintIcon(this, g, this.getWidth() - icon.getIconWidth() - 5, (this.getHeight() - icon.getIconHeight()) / 2);
    }

    public void setSelectedItem(Type value) {
        if (this.selectedItem != value) {
            this.selectedItem = value;
            this.onChanged(value);
        }
        this.setText(this.getLabel(value, true));
        this.setIcon(this.getIcon(value, true));
        this.setToolTipText(this.getLabel(value, false));
    }

    public void onChanged(Type newValue) {
    }

    public Type getSelectedItem() {
        return this.selectedItem;
    }
}

