/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.TooltipInterface;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.JScrollPopupMenu;
import org.appwork.utils.CompareUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.ExtRealCheckBoxMenuItem;
import org.jdownloader.gui.views.components.MergedIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public class PseudoMultiCombo<Type>
extends ExtButton {
    protected HashSet<Type> selectedItems = new HashSet();
    private List<Type> values = new ArrayList<Type>();
    private boolean popDown = true;
    private long lastHide = 0L;
    private boolean closed = true;
    private String orgText;

    public PseudoMultiCombo(List<Type> values) {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PseudoMultiCombo.this.onPopup();
            }
        });
        this.setHorizontalAlignment(2);
        Insets m = this.getMargin();
        if (m == null) {
            m = new Insets(0, 0, 0, 0);
        }
        m.right = this.getPopIcon(true).getIconWidth() + 5;
        m.left = 1;
        this.setMargin(m);
        this.setValues(values);
    }

    public PseudoMultiCombo(Type[] values) {
        this(Arrays.asList(values));
    }

    public void setValues(List<Type> values) {
        this.values.clear();
        for (Type v : values) {
            this.values.add(v);
        }
        this.updateLabel();
    }

    public void setValues(Type[] values) {
        this.setValues(Arrays.asList(values));
    }

    public List<Type> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    protected Icon getPopIcon(boolean closed) {
        if (closed) {
            if (this.isPopDown()) {
                return NewTheme.I().getIcon("popDownLarge", -1);
            }
            return NewTheme.I().getIcon("popUpLarge", -1);
        }
        if (this.isPopDown()) {
            return NewTheme.I().getIcon("popUpLarge", -1);
        }
        return NewTheme.I().getIcon("popDownLarge", -1);
    }

    public boolean isPopDown() {
        return this.popDown;
    }

    public void setPopDown(boolean popDown) {
        this.popDown = popDown;
    }

    protected Icon getIcon(Type[] value) {
        return null;
    }

    public ExtRealCheckBoxMenuItem createMenuItem(final Type sc, BasicAction appAction) {
        return new ExtRealCheckBoxMenuItem((AbstractAction)appAction){

            @Override
            protected void updateIcon() {
                Icon icon = PseudoMultiCombo.this.getIcon(sc);
                if (icon == null) {
                    super.updateIcon();
                } else if (this.isSelected()) {
                    this.setIcon((Icon)((Object)new MergedIcon(this.selIcon, icon)));
                } else {
                    this.setIcon((Icon)((Object)new MergedIcon(this.unselIcon, icon)));
                }
            }
        };
    }

    protected void onPopup() {
        long timeSinceLastHide = System.currentTimeMillis() - this.lastHide;
        if (timeSinceLastHide < 250L) {
            return;
        }
        JScrollPopupMenu popup = new JScrollPopupMenu(){

            public void setVisible(boolean b) {
                if (!b) {
                    PseudoMultiCombo.this.lastHide = System.currentTimeMillis();
                }
                super.setVisible(b);
                PseudoMultiCombo.this.closed = true;
                PseudoMultiCombo.this.repaint();
            }
        };
        final AtomicInteger integer = new AtomicInteger(0);
        for (final Type sc : this.values) {
            ExtRealCheckBoxMenuItem mi = this.createMenuItem(sc, new AppAction(){
                private Type value;
                {
                    this.value = sc;
                    this.setName(PseudoMultiCombo.this.getLabel(integer.get(), sc));
                    this.setSmallIcon(PseudoMultiCombo.this.getIcon(integer.get(), sc));
                    this.setSelected(PseudoMultiCombo.this.isItemSelected(sc));
                    integer.incrementAndGet();
                }

                public void setSelected(boolean selected) {
                    super.setSelected(selected);
                }

                public void actionPerformed(ActionEvent e) {
                    this.setSelected(this.isSelected());
                    System.out.println(this.isSelected());
                    PseudoMultiCombo.this.setItemSelected(this.value, this.isSelected());
                }
            });
            popup.add((JMenuItem)mi);
            mi.setHideOnClick(false);
        }
        Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
        Dimension pref = popup.getPreferredSize();
        popup.setPreferredSize(new Dimension((int)Math.max((double)(this.getWidth() + insets.left + insets.right), pref.getWidth()), (int)pref.getHeight()));
        if (this.isPopDown()) {
            popup.show((Component)((Object)this), -insets.left, this.getHeight() + insets.top);
        } else {
            popup.show((Component)((Object)this), -insets.left, -popup.getPreferredSize().height + insets.bottom);
        }
        this.closed = false;
    }

    public boolean isItemSelected(Type sc) {
        return this.selectedItems.contains(sc);
    }

    public void setItemSelected(Type value, boolean b) {
        if (b) {
            if (this.selectedItems.add(value)) {
                this.updateLabel();
                this.onChanged();
            }
        } else if (this.selectedItems.remove(value)) {
            this.updateLabel();
            this.onChanged();
        }
    }

    protected Icon getIcon(int i, Type sc) {
        return this.getIcon(sc);
    }

    protected Icon getIcon(Type sc) {
        return null;
    }

    protected String getLabel(int i, Type sc) {
        return this.getLabel(sc);
    }

    protected String getLabel(Type sc) {
        if (sc instanceof LabelInterface) {
            return ((LabelInterface)sc).getLabel();
        }
        return sc + "";
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Icon icon = this.getPopIcon(this.closed);
        if (!this.isEnabled()) {
            icon = NewTheme.I().getDisabledIcon(icon);
        }
        icon.paintIcon((Component)((Object)this), g, this.getWidth() - icon.getIconWidth() - 5, (this.getHeight() - icon.getIconHeight()) / 2);
    }

    public void setSelectedItems(Type ... value) {
        this.selectedItems.clear();
        if (value != null) {
            for (Type t : value) {
                this.selectedItems.add(t);
            }
        }
        this.onChanged();
        this.updateLabel();
    }

    public void setSelectedItems(List<Type> value) {
        this.selectedItems.clear();
        if (value != null) {
            for (Type t : value) {
                this.selectedItems.add(t);
            }
        }
        this.onChanged();
        this.updateLabel();
    }

    public void setText(String text) {
        String oldValue = this.orgText;
        this.orgText = text;
        this.firePropertyChange("text", oldValue, text);
        if (text == null || oldValue == null || !text.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        Dimension ret = super.getMinimumSize();
        ret.width = ret.height;
        return ret;
    }

    public String getText() {
        if (this.orgText == null) {
            return null;
        }
        return SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)((Object)this), (FontMetrics)this.getFontMetrics(this.getFont()), (String)this.orgText, (int)(this.getWidth() - this.getMargin().left - this.getMargin().right - 10));
    }

    private void updateLabel() {
        ArrayList<Type> list = new ArrayList<Type>(this.selectedItems);
        Collections.sort(list, this.getComparator());
        this.setText(this.getLabel((List<Type>)list));
        this.setIcon(this.getIcon((List<Type>)list));
        this.setToolTipText(this.getToolTip(list));
    }

    protected String getToolTip(List<Type> list) {
        if (list.size() == 0) {
            return _GUI.T.PseudoMultiCombo_nothing();
        }
        StringBuilder sb = new StringBuilder();
        for (Type t : list) {
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            if (t instanceof TooltipInterface) {
                sb.append(((TooltipInterface)t).getTooltip());
                continue;
            }
            sb.append(this.getLabel(t));
        }
        return sb.toString();
    }

    protected Icon getIcon(List<Type> list) {
        return null;
    }

    protected String getLabel(List<Type> list) {
        if (list.size() == 0) {
            return _GUI.T.PseudoMultiCombo_nothing();
        }
        StringBuilder sb = new StringBuilder();
        for (Type t : list) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getLabel(t));
        }
        return sb.toString();
    }

    private Comparator<? super Type> getComparator() {
        return new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                return CompareUtils.compareInt((int)PseudoMultiCombo.this.values.indexOf(o1), (int)PseudoMultiCombo.this.values.indexOf(o2));
            }
        };
    }

    public void onChanged() {
    }

    public List<Type> getSelectedItems() {
        ArrayList<Type> ret = new ArrayList<Type>(this.selectedItems);
        Collections.sort(ret, this.getComparator());
        return ret;
    }
}

