/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeVisitor;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.jdownloader.gui.views.SelectionInfo;

public class PackageControllerSelectionInfo<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends SelectionInfo<PackageType, ChildrenType> {
    private volatile long backendVersion = -1L;
    private final AtomicBoolean rawSelectionInitiated = new AtomicBoolean(false);

    public long getBackendVersion() {
        return this.backendVersion;
    }

    public PackageControllerSelectionInfo(PackageController<PackageType, ChildrenType> packageController) {
        super(packageController);
        this.aggregate(packageController.getQueue());
    }

    @Override
    protected void aggregate() {
        PackageController controller = this.getController();
        this.backendVersion = controller.getBackendChanged();
        controller.visitNodes(new AbstractNodeVisitor<ChildrenType, PackageType>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean visitPackageNode(PackageType currentPackage) {
                int size;
                int index;
                boolean isExpanded = currentPackage.isExpanded();
                boolean readL = currentPackage.getModifyLock().readLock();
                try {
                    index = PackageControllerSelectionInfo.this.children.size();
                    size = currentPackage.getChildren().size();
                    PackageControllerSelectionInfo.this.children.addAll(currentPackage.getChildren());
                }
                finally {
                    currentPackage.getModifyLock().readUnlock(readL);
                }
                SelectionInfo.PackageView packageView = new SelectionInfo.PackageView<PackageType, ChildrenType>((AbstractPackageNode)currentPackage, isExpanded){
                    final /* synthetic */ AbstractPackageNode val$currentPackage;
                    final /* synthetic */ boolean val$isExpanded;
                    {
                        this.val$currentPackage = abstractPackageNode;
                        this.val$isExpanded = bl;
                    }

                    @Override
                    public List<ChildrenType> getChildren() {
                        return PackageControllerSelectionInfo.this.children.subList(index, index + size);
                    }

                    @Override
                    public PackageType getPackage() {
                        return this.val$currentPackage;
                    }

                    @Override
                    public boolean isPackageSelected() {
                        return true;
                    }

                    @Override
                    public boolean isExpanded() {
                        return this.val$isExpanded;
                    }

                    @Override
                    public List<ChildrenType> getSelectedChildren() {
                        return PackageControllerSelectionInfo.this.children.subList(index, index + size);
                    }
                };
                PackageControllerSelectionInfo.this.addPackageView(packageView, currentPackage);
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitChildrenNode(ChildrenType node) {
                return Boolean.FALSE;
            }
        }, true);
    }

    @Override
    public synchronized List<AbstractNode> getRawSelection() {
        if (!this.rawSelectionInitiated.get()) {
            for (SelectionInfo.PackageView packageView : this.getPackageViews()) {
                this.rawSelection.add(packageView.getPackage());
                this.rawSelection.addAll(packageView.getChildren());
            }
            this.rawSelectionInitiated.set(true);
        }
        return super.getRawSelection();
    }
}

