/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeVisitor;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.ChildrenView;
import jd.controlling.packagecontroller.PackageController;
import jd.controlling.packagecontroller.PackageControllerComparator;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.Storage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelCustomizer;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelFilter;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public abstract class PackageControllerTableModel<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends ExtTableModel<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private boolean tristateSorterEnabled = true;
    private static final String SORT_ORIGINAL = "ORIGINAL";
    private final DelayedRunnable asyncRefresh;
    protected final PackageController<PackageType, ChildrenType> pc;
    private final DelayedRunnable asyncRecreate;
    private CopyOnWriteArrayList<TableDataModification> tableModifiers = new CopyOnWriteArrayList();
    private ScheduledExecutorService queue = DelayedRunnable.getNewScheduledExecutorService();
    private final DelayedRunnable asyncRecreateFast;
    private final Storage storage;
    private final AtomicLong repaintFiredCounter = new AtomicLong(0L);
    private final AtomicLong structureChangedCounter = new AtomicLong(0L);
    private final AtomicLong repaintRequested = new AtomicLong(0L);
    private final AtomicLong structureChangeRequested = new AtomicLong(0L);
    private final AtomicLong structureChangeProcessed = new AtomicLong(0L);
    private volatile boolean hideSinglePackage = false;
    private volatile PackageControllerTableModelData<PackageType, ChildrenType> packageControllertableModelData = new PackageControllerTableModelData();
    private boolean scrollPositionRestoreDone;
    private final Comparator<PackageControllerTableModelFilter<PackageType, ChildrenType>> tableFilterComparator = new Comparator<PackageControllerTableModelFilter<PackageType, ChildrenType>>(){

        @Override
        public int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(PackageControllerTableModelFilter<PackageType, ChildrenType> o1, PackageControllerTableModelFilter<PackageType, ChildrenType> o2) {
            return this.compare(o1.getComplexity(), o2.getComplexity());
        }
    };
    private final Object tableFiltersLock = new Object();
    private volatile ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>> tableFilters = new ArrayList();

    protected int[] guessSelectedRows(List<AbstractNode> oldTableData, int leadIndex, int anchorIndex, BitSet selectedRowsBitSet) {
        block18: {
            try {
                if (!(oldTableData instanceof PackageControllerTableModelData) || this.getRowCount() <= 0) break block18;
                PackageControllerTableModelData oldTableModelData = (PackageControllerTableModelData)oldTableData;
                List currentTableModelData = this.getTableData();
                HashSet<UniqueAlltimeID> skip = new HashSet<UniqueAlltimeID>();
                int selectedRowIndex = selectedRowsBitSet.length();
                PackageControllerTableModelData.PackageControllerTableModelDataPackage currentPackageData = null;
                PackageControllerTableModelData.PackageControllerTableModelDataPackage oldPackageData = null;
                PackageController<PackageType, ChildrenType> controller = this.getController();
                int lastOldRowIndex = -1;
                block2: while (selectedRowIndex >= 0) {
                    int row;
                    List oldChildren;
                    int oldChildIndex;
                    UniqueAlltimeID previousParentNodeID;
                    int oldRowIndex;
                    if (Application.getJavaVersion() >= Application.JAVA17) {
                        oldRowIndex = selectedRowsBitSet.previousSetBit(selectedRowIndex);
                    } else {
                        int index;
                        for (index = selectedRowIndex; index >= 0 && !selectedRowsBitSet.get(index); --index) {
                        }
                        oldRowIndex = index;
                    }
                    selectedRowIndex = oldRowIndex - 1;
                    if (oldRowIndex < 0) continue;
                    lastOldRowIndex = oldRowIndex;
                    AbstractNode oldNode = (AbstractNode)oldTableModelData.get(oldRowIndex);
                    if (oldNode instanceof AbstractPackageChildrenNode) {
                        int row2;
                        AbstractPackageNode parent;
                        previousParentNodeID = ((AbstractPackageChildrenNode)oldNode).getPreviousParentNodeID();
                        Iterator parentNode = ((AbstractPackageChildrenNode)oldNode).getParentNode();
                        if (parentNode != null && (parent = (AbstractPackageNode)((Object)parentNode)).getControlledBy() != null && parent.getControlledBy() == controller && (row2 = this.getRowforObject(parent)) >= 0) {
                            return new int[]{row2};
                        }
                    } else {
                        for (PackageControllerTableModelData.PackageControllerTableModelDataPackage dataPackage : oldTableModelData.getModelDataPackages()) {
                            if (dataPackage.getPackage() != oldNode) continue;
                            List oldChildren2 = dataPackage.getVisibleChildren();
                            for (AbstractNode oldChildrenNode : oldChildren2) {
                                int row3;
                                AbstractPackageNode parent;
                                Object parentNode = ((AbstractPackageChildrenNode)oldChildrenNode).getParentNode();
                                if (parentNode == null || (parent = (AbstractPackageNode)parentNode).getControlledBy() == null || parent.getControlledBy() != controller || (row3 = this.getRowforObject(parent)) < 0) continue;
                                return new int[]{row3};
                            }
                            continue block2;
                        }
                        continue;
                    }
                    if (skip.contains((Object)previousParentNodeID)) continue;
                    if (currentPackageData == null || !((AbstractPackageNode)currentPackageData.getPackage()).getUniqueID().equals((Object)previousParentNodeID)) {
                        currentPackageData = null;
                        for (PackageControllerTableModelData.PackageControllerTableModelDataPackage dataPackage : ((PackageControllerTableModelData)currentTableModelData).getModelDataPackages()) {
                            if (!((AbstractPackageNode)dataPackage.getPackage()).getUniqueID().equals((Object)previousParentNodeID)) continue;
                            currentPackageData = dataPackage;
                            break;
                        }
                    }
                    if (currentPackageData == null) {
                        skip.add(previousParentNodeID);
                        continue;
                    }
                    if (oldPackageData == null || !((AbstractPackageNode)oldPackageData.getPackage()).getUniqueID().equals((Object)previousParentNodeID)) {
                        oldPackageData = null;
                        for (PackageControllerTableModelData.PackageControllerTableModelDataPackage dataPackage : oldTableModelData.getModelDataPackages()) {
                            if (!((AbstractPackageNode)dataPackage.getPackage()).getUniqueID().equals((Object)previousParentNodeID)) continue;
                            oldPackageData = dataPackage;
                            break;
                        }
                        if (oldPackageData == null) {
                            skip.add(previousParentNodeID);
                            continue;
                        }
                    }
                    if ((oldChildIndex = (oldChildren = oldPackageData.getVisibleChildren()).indexOf(oldNode)) < 0) continue;
                    AbstractNode searchChild = oldChildIndex + 1 < oldChildren.size() ? (AbstractNode)oldChildren.get(oldChildIndex + 1) : (oldChildIndex - 1 >= 0 ? (AbstractNode)oldChildren.get(oldChildIndex - 1) : null);
                    List currentChildren = currentPackageData.getVisibleChildren();
                    if (searchChild == null || !currentChildren.contains(searchChild) || (row = this.getRowforObject(searchChild)) < 0) continue;
                    return new int[]{row};
                }
                if ((lastOldRowIndex = Math.max(0, lastOldRowIndex - 1)) >= 0) {
                    return new int[]{Math.min(lastOldRowIndex, this.getRowCount() - 1)};
                }
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        return super.guessSelectedRows(oldTableData, leadIndex, anchorIndex, selectedRowsBitSet);
    }

    public int getRowforObject(AbstractNode node) {
        return ((PackageControllerTableModelData)this.getTableData()).getRowforObject(node, this.getController());
    }

    public boolean contains(AbstractNode node) {
        return ((PackageControllerTableModelData)this.getTableData()).getRowforObject(node, this.getController()) >= 0;
    }

    public PackageControllerTable<PackageType, ChildrenType> getTable() {
        return (PackageControllerTable)super.getTable();
    }

    public boolean isTristateSorterEnabled() {
        return this.tristateSorterEnabled;
    }

    public void setTristateSorterEnabled(boolean tristateSorterEnabled) {
        this.tristateSorterEnabled = tristateSorterEnabled;
    }

    public boolean isHideSinglePackage() {
        return this.hideSinglePackage;
    }

    public PackageControllerTableModel(final PackageController<PackageType, ChildrenType> pc, String id) {
        super(id);
        this.storage = this.getStorage();
        this.resetSorting();
        CFG_GUI.HIDE_SINGLE_CHILD_PACKAGES.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                PackageControllerTableModel.this.hideSinglePackage = Boolean.TRUE.equals(newValue);
                PackageControllerTableModel.this.recreateModel(true);
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        }, false);
        CFG_GENERAL.URL_ORDER.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                PackageControllerTableModel.this.recreateModel(true);
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        }, true);
        this.hideSinglePackage = CFG_GUI.HIDE_SINGLE_CHILD_PACKAGES.isEnabled();
        this.pc = pc;
        this.asyncRefresh = new DelayedRunnable(this.queue, 150L, 500L){

            public String getID() {
                return "PackageControllerTableModel_Refresh" + pc.getClass().getName();
            }

            public void delayedrun() {
                PackageControllerTableModel.this.fireRepaint();
            }
        };
        this.asyncRecreate = new DelayedRunnable(this.queue, 50L, 1000L){

            public String getID() {
                return "PackageControllerTableModel_Recreate" + pc.getClass().getName();
            }

            public void delayedrun() {
                PackageControllerTableModel.this.fireStructureChange();
            }
        };
        this.asyncRecreateFast = new DelayedRunnable(this.queue, 10L, 50L){

            public String getID() {
                return "PackageControllerTableModel_RecreateFast" + pc.getClass().getName();
            }

            public void delayedrun() {
                PackageControllerTableModel.this.fireStructureChange();
            }
        };
        this.scrollPositionRestoreDone = false;
    }

    private void fireRepaint() {
        if (this.repaintRequested.get() > this.structureChangeRequested.get()) {
            ArrayList viewUpdates = new ArrayList();
            for (AbstractNode abstractNode : this.getTableData()) {
                ChildrenView view;
                if (!(abstractNode instanceof AbstractPackageNode) || !(view = ((AbstractPackageNode)abstractNode).getView()).updateRequired()) continue;
                viewUpdates.add(view);
            }
            for (ChildrenView childrenView : viewUpdates) {
                childrenView.aggregate();
            }
            new EDTRunner(){

                protected void runInEDT() {
                    if (PackageControllerTableModel.this.repaintRequested.get() > PackageControllerTableModel.this.structureChangeRequested.get()) {
                        try {
                            PackageControllerTableModel.this.getTable().repaint();
                        }
                        finally {
                            PackageControllerTableModel.this.getTable().firePropertyChange("repaintFired", PackageControllerTableModel.this.repaintFiredCounter.get(), PackageControllerTableModel.this.repaintFiredCounter.incrementAndGet());
                        }
                    }
                }
            };
        }
    }

    public void fireStructureChange(boolean force) {
        if (this.structureChangeRequested.get() > this.structureChangeProcessed.getAndSet(System.currentTimeMillis()) || force) {
            try {
                this._fireTableStructureChanged(this.getTableData(), true);
            }
            finally {
                this.getTable().firePropertyChange("structureChangedFired", this.structureChangedCounter.get(), this.structureChangedCounter.incrementAndGet());
            }
        }
    }

    private void fireStructureChange() {
        this.fireStructureChange(false);
    }

    public void resetSorting() {
        this.sortColumn = null;
        try {
            this.storage.put("SORT_ORDER_ID", (String)null);
            this.storage.put("SORTCOLUMN", (String)null);
        }
        catch (Exception e) {
            LogController.CL(true).log((Throwable)e);
        }
    }

    public ScheduledExecutorService getThreadPool() {
        return this.queue;
    }

    public void recreateModel(boolean delay) {
        this.structureChangeRequested.set(System.currentTimeMillis());
        if (delay) {
            this.asyncRecreate.run();
        } else {
            this.asyncRecreateFast.run();
        }
    }

    public void recreateModel() {
        this.recreateModel(true);
    }

    public void refreshModel(boolean delay) {
        this.repaintRequested.set(System.currentTimeMillis());
        if (delay) {
            this.asyncRefresh.run();
        } else {
            this.queue.schedule(new Runnable(){

                @Override
                public void run() {
                    PackageControllerTableModel.this.fireRepaint();
                }
            }, 0L, TimeUnit.SECONDS);
        }
    }

    public void refreshModel() {
        this.refreshModel(true);
    }

    public void sortPackageChildren(AbstractPackageNode pkg, PackageControllerComparator<AbstractNode> comparator) {
        this.resetSorting();
        this.pc.sortPackageChildren(pkg, comparator);
    }

    public PackageController<PackageType, ChildrenType> getController() {
        return this.pc;
    }

    public void addTableModifier(TableDataModification tableModifier, boolean delay) {
        this.tableModifiers.add(tableModifier);
        this.recreateModel(delay);
    }

    public void toggleFilePackageExpand(final AbstractPackageNode fp2, final TOGGLEMODE mode) {
        final boolean currentExpandedState = !fp2.isExpanded();
        switch (mode) {
            case CURRENT: {
                this.tableModifiers.add(new TableDataModification(){

                    @Override
                    protected void modifyPackageData(PackageType pkg, List<ChildrenType> unfilteredChildren) {
                        if (fp2 == pkg && unfilteredChildren.size() > 0) {
                            pkg.setExpanded(currentExpandedState);
                        }
                    }
                });
                break;
            }
            default: {
                final SelectionInfo<AbstractPackageNode, ChildrenType> selectionInfo = this.getTable().getSelectionInfo(true, true);
                int count = 0;
                SelectionInfo.PackageView<AbstractPackageNode, ChildrenType> view = selectionInfo.getPackageView(fp2);
                if (view != null && view.isPackageSelected()) {
                    for (SelectionInfo.PackageView<PackageType, ChildrenType> packageView : selectionInfo.getPackageViews()) {
                        if (packageView.isPackageSelected() && ++count > 1) break;
                    }
                }
                if (count > 1) {
                    this.tableModifiers.add(new TableDataModification(){

                        @Override
                        protected void modifyPackageData(PackageType pkg, List<ChildrenType> unfilteredChildren) {
                            SelectionInfo.PackageView view;
                            if (unfilteredChildren.size() > 0 && (view = selectionInfo.getPackageView(pkg)) != null && view.isPackageSelected()) {
                                pkg.setExpanded(currentExpandedState);
                            }
                        }
                    });
                    break;
                }
                this.tableModifiers.add(new TableDataModification(){
                    boolean doToggle = false;
                    {
                        switch (mode) {
                            case TOP: {
                                this.doToggle = true;
                                break;
                            }
                            case BOTTOM: {
                                this.doToggle = false;
                            }
                        }
                    }

                    @Override
                    protected void modifyPackageData(PackageType pkg, List<ChildrenType> unfilteredChildren) {
                        if (this.doToggle) {
                            if (unfilteredChildren.size() > 0) {
                                pkg.setExpanded(currentExpandedState);
                            }
                            if (pkg == fp2) {
                                this.doToggle = false;
                            }
                        } else if (pkg == fp2) {
                            this.doToggle = true;
                            if (unfilteredChildren.size() > 0) {
                                pkg.setExpanded(currentExpandedState);
                            }
                        }
                    }
                });
            }
        }
        this.recreateModel(false);
    }

    public void setFilePackageExpand(final boolean expanded, final AbstractPackageNode ... fp2) {
        this.tableModifiers.add(new TableDataModification(){

            @Override
            protected void modifyPackageData(PackageType pkg, List<ChildrenType> unfilteredChildren) {
                for (AbstractPackageNode fp : fp2) {
                    if (fp != pkg) continue;
                    fp.setExpanded(expanded);
                }
            }
        });
        this.recreateModel(false);
    }

    public boolean isFilteredView() {
        return ((PackageControllerTableModelData)this.getTableData()).isFiltered();
    }

    public PackageControllerTableModelData<PackageType, ChildrenType> getTableData() {
        return this.packageControllertableModelData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(PackageControllerTableModelFilter<PackageType, ChildrenType> filter) {
        if (filter != null && this.tableFilters.contains(filter)) {
            Object object = this.tableFiltersLock;
            synchronized (object) {
                ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>> availableTableFilters = new ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>>(this.tableFilters);
                availableTableFilters.remove(filter);
                this.tableFilters = availableTableFilters;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(PackageControllerTableModelFilter<PackageType, ChildrenType> filter) {
        if (filter != null && !this.tableFilters.contains(filter)) {
            ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>> arrayList = this.tableFilters;
            synchronized (arrayList) {
                if (!this.tableFilters.contains(filter)) {
                    ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>> availableTableFilters = new ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>>(this.tableFilters);
                    availableTableFilters.add(filter);
                    try {
                        Collections.sort(availableTableFilters, this.tableFilterComparator);
                    }
                    catch (Throwable e) {
                        LogController.CL(true).log(e);
                    }
                    this.tableFilters = availableTableFilters;
                }
            }
        }
    }

    protected void initColumns() {
    }

    protected CompiledFilterList compileTableFilters(Collection<PackageControllerTableModelFilter<PackageType, ChildrenType>> filters) {
        if (filters == null || filters.size() == 0) {
            return new CompiledFilterList();
        }
        ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>> packageFilters = new ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>>();
        ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>> childrendFilters = new ArrayList<PackageControllerTableModelFilter<PackageType, ChildrenType>>();
        for (PackageControllerTableModelFilter<PackageType, ChildrenType> filter : filters) {
            if (filter.isFilteringPackageNodes()) {
                packageFilters.add(filter);
            }
            if (!filter.isFilteringChildrenNodes()) continue;
            childrendFilters.add(filter);
        }
        if (packageFilters.size() > 0 || childrendFilters.size() > 0) {
            if (packageFilters.size() > 0) {
                try {
                    Collections.sort(packageFilters, this.tableFilterComparator);
                }
                catch (Throwable e) {
                    LogController.CL(true).log(e);
                }
            }
            if (childrendFilters.size() > 0) {
                try {
                    Collections.sort(childrendFilters, this.tableFilterComparator);
                }
                catch (Throwable e) {
                    LogController.CL(true).log(e);
                }
            }
        }
        return new CompiledFilterList(packageFilters, childrendFilters);
    }

    protected List<PackageControllerTableModelFilter<PackageType, ChildrenType>> getTableFilters() {
        return this.tableFilters;
    }

    public List<AbstractNode> refreshUnSort(List<AbstractNode> data) {
        if (data instanceof PackageControllerTableModelData) {
            return data;
        }
        throw new IllegalArgumentException("data must be instanceof PackageControllerTableModelData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractNode> sort(List<AbstractNode> data, ExtColumn<AbstractNode> column) {
        ArrayList<TableDataModification> appliedTableDataModifier;
        ArrayList<Object> packages;
        boolean hideSingleChildPackages = this.isHideSinglePackage();
        if (column == null || column.getSortOrderIdentifier() == SORT_ORIGINAL) {
            column = null;
            this.sortColumn = null;
            try {
                this.storage.put("SORT_ORDER_ID", (String)null);
                this.storage.put("SORTCOLUMN", (String)null);
            }
            catch (Exception e) {
                LogController.CL(true).log((Throwable)e);
            }
        } else {
            this.sortColumn = column;
            String id = column.getSortOrderIdentifier();
            try {
                this.storage.put("SORT_ORDER_ID", id);
                this.storage.put("SORTCOLUMN", column.getID());
            }
            catch (Exception e) {
                LogController.CL(true).log((Throwable)e);
            }
        }
        final CompiledFilterList tableFiltersCompiled = this.compileTableFilters(this.getTableFilters());
        if (tableFiltersCompiled.getPackageFilters().size() > 0) {
            packages = new ArrayList();
            this.pc.visitNodes(new AbstractNodeVisitor<ChildrenType, PackageType>(){

                @Override
                public Boolean visitPackageNode(PackageType pkg) {
                    for (PackageControllerTableModelFilter filter : tableFiltersCompiled.getPackageFilters()) {
                        if (!filter.isFiltered(pkg)) continue;
                        return Boolean.FALSE;
                    }
                    packages.add(pkg);
                    return Boolean.FALSE;
                }

                @Override
                public Boolean visitChildrenNode(ChildrenType node) {
                    return Boolean.FALSE;
                }
            }, true);
        } else {
            packages = this.pc.getPackagesCopy();
        }
        if (column != null) {
            try {
                ExtDefaultRowSorter comparator = column.getRowSorter();
                if (comparator != null) {
                    Collections.sort(packages, comparator);
                }
            }
            catch (Throwable e) {
                LogController.CL(true).log(e);
            }
        }
        if (this.tableModifiers.size() > 0) {
            appliedTableDataModifier = new ArrayList<TableDataModification>(this.tableModifiers);
            this.tableModifiers.removeAll(appliedTableDataModifier);
        } else {
            appliedTableDataModifier = null;
        }
        final PackageControllerTableModelData newData = new PackageControllerTableModelData(Math.max(data.size(), packages.size()));
        ArrayList<PackageControllerTableModelData.PackageControllerTableModelDataPackage> modelDataPackages = new ArrayList<PackageControllerTableModelData.PackageControllerTableModelDataPackage>(0);
        ArrayList<AbstractPackageChildrenNode<Object>> visibleChildren = new ArrayList<AbstractPackageChildrenNode<Object>>(0);
        ArrayList<AbstractPackageChildrenNode> filteredChildren = new ArrayList<AbstractPackageChildrenNode>(0);
        for (final AbstractPackageNode abstractPackageNode : packages) {
            int filteredSize;
            int filteredIndex;
            PackageControllerTableModelData.PackageControllerTableModelDataPackage modelDataPackage;
            boolean readL;
            visibleChildren.clear();
            filteredChildren.clear();
            if (tableFiltersCompiled.getChildrenFilters().size() > 0) {
                readL = abstractPackageNode.getModifyLock().readLock();
                try {
                    block15: for (AbstractPackageChildrenNode child : abstractPackageNode.getChildren()) {
                        for (PackageControllerTableModelFilter filter : tableFiltersCompiled.getChildrenFilters()) {
                            if (!filter.isFiltered(child)) continue;
                            filteredChildren.add(child);
                            continue block15;
                        }
                        visibleChildren.add(child);
                    }
                }
                finally {
                    abstractPackageNode.getModifyLock().readUnlock(readL);
                }
            }
            readL = abstractPackageNode.getModifyLock().readLock();
            try {
                visibleChildren.addAll(abstractPackageNode.getChildren());
            }
            finally {
                abstractPackageNode.getModifyLock().readUnlock(readL);
            }
            if (appliedTableDataModifier != null && visibleChildren.size() > 0) {
                for (TableDataModification modifier : appliedTableDataModifier) {
                    modifier.modifyPackageData(abstractPackageNode, visibleChildren);
                }
            }
            final boolean expanded = abstractPackageNode.isExpanded();
            if (abstractPackageNode.getView() != null && visibleChildren.size() == 0) {
                if (filteredChildren.size() <= 0) continue;
                final int filteredIndex2 = newData.getInvisibleChildren().size();
                final int filteredSize2 = filteredChildren.size();
                newData.getInvisibleChildren().addAll(filteredChildren);
                PackageControllerTableModelData.PackageControllerTableModelDataPackage modelDataPackage2 = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                    @Override
                    public boolean isExpanded() {
                        return expanded;
                    }

                    public List<? extends AbstractNode> getVisibleChildren() {
                        return null;
                    }

                    public List<? extends AbstractNode> getInvisibleChildren() {
                        return newData.getInvisibleChildren().subList(filteredIndex2, filteredIndex2 + filteredSize2);
                    }

                    @Override
                    public PackageType getPackage() {
                        return abstractPackageNode;
                    }

                    @Override
                    public int getPackageIndex() {
                        return -1;
                    }

                    @Override
                    public int getVisibleChildrenSize() {
                        return 0;
                    }

                    @Override
                    public int getInvisibleChildrenSize() {
                        return filteredSize2;
                    }
                };
                modelDataPackages.add(modelDataPackage2);
                continue;
            }
            if (visibleChildren.size() == 1 && hideSingleChildPackages) {
                PackageControllerTableModelData.PackageControllerTableModelDataPackage modelDataPackage2;
                final int visibleIndex = newData.size();
                final int packageNodeIndex = newData.addHiddenPackageSingleChild((AbstractPackageChildrenNode)visibleChildren.get(0));
                if (filteredChildren.size() == 0) {
                    modelDataPackage2 = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                        @Override
                        public boolean isExpanded() {
                            return true;
                        }

                        public List<? extends AbstractNode> getVisibleChildren() {
                            return newData.subList(visibleIndex, visibleIndex + 1);
                        }

                        public List<? extends AbstractNode> getInvisibleChildren() {
                            return null;
                        }

                        @Override
                        public PackageType getPackage() {
                            return abstractPackageNode;
                        }

                        @Override
                        public int getPackageIndex() {
                            return packageNodeIndex;
                        }

                        @Override
                        public int getVisibleChildrenSize() {
                            return 1;
                        }

                        @Override
                        public int getInvisibleChildrenSize() {
                            return 0;
                        }
                    };
                } else {
                    final int filteredIndex3 = newData.getFilteredChildren().size();
                    final int filteredSize3 = filteredChildren.size();
                    newData.getFilteredChildren().addAll(filteredChildren);
                    modelDataPackage2 = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                        @Override
                        public boolean isExpanded() {
                            return true;
                        }

                        public List<? extends AbstractNode> getVisibleChildren() {
                            return newData.subList(visibleIndex, visibleIndex + 1);
                        }

                        public List<? extends AbstractNode> getInvisibleChildren() {
                            return newData.getFilteredChildren().subList(filteredIndex3, filteredIndex3 + filteredSize3);
                        }

                        @Override
                        public PackageType getPackage() {
                            return abstractPackageNode;
                        }

                        @Override
                        public int getPackageIndex() {
                            return packageNodeIndex;
                        }

                        @Override
                        public int getVisibleChildrenSize() {
                            return 1;
                        }

                        @Override
                        public int getInvisibleChildrenSize() {
                            return filteredSize3;
                        }
                    };
                }
                modelDataPackages.add(modelDataPackage2);
                continue;
            }
            final int packageNodeIndex = newData.addPackageNode(abstractPackageNode);
            if (expanded) {
                if (column != null && visibleChildren.size() > 1) {
                    try {
                        ExtDefaultRowSorter comparator = column.getRowSorter();
                        if (comparator != null) {
                            Collections.sort(visibleChildren, comparator);
                        }
                    }
                    catch (Throwable e) {
                        LogController.CL(true).log(e);
                    }
                }
                final int visibleIndex = newData.size();
                newData.addAll(visibleChildren);
                final int visibleSize = visibleChildren.size();
                if (filteredChildren.size() == 0) {
                    modelDataPackage = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                        @Override
                        public boolean isExpanded() {
                            return true;
                        }

                        public List<? extends AbstractNode> getVisibleChildren() {
                            return newData.subList(visibleIndex, visibleIndex + visibleSize);
                        }

                        public List<? extends AbstractNode> getInvisibleChildren() {
                            return null;
                        }

                        @Override
                        public PackageType getPackage() {
                            return abstractPackageNode;
                        }

                        @Override
                        public int getPackageIndex() {
                            return packageNodeIndex;
                        }

                        @Override
                        public int getVisibleChildrenSize() {
                            return visibleSize;
                        }

                        @Override
                        public int getInvisibleChildrenSize() {
                            return 0;
                        }
                    };
                } else {
                    filteredIndex = newData.getFilteredChildren().size();
                    filteredSize = filteredChildren.size();
                    newData.getFilteredChildren().addAll(filteredChildren);
                    modelDataPackage = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                        @Override
                        public boolean isExpanded() {
                            return true;
                        }

                        public List<? extends AbstractNode> getVisibleChildren() {
                            return newData.subList(visibleIndex, visibleIndex + visibleSize);
                        }

                        public List<? extends AbstractNode> getInvisibleChildren() {
                            return newData.getFilteredChildren().subList(filteredIndex, filteredIndex + filteredSize);
                        }

                        @Override
                        public PackageType getPackage() {
                            return abstractPackageNode;
                        }

                        @Override
                        public int getPackageIndex() {
                            return packageNodeIndex;
                        }

                        @Override
                        public int getVisibleChildrenSize() {
                            return visibleSize;
                        }

                        @Override
                        public int getInvisibleChildrenSize() {
                            return filteredSize;
                        }
                    };
                }
            } else {
                final int hiddenIndex = newData.getHiddenChildren().size();
                final int hiddenSize = visibleChildren.size();
                newData.getHiddenChildren().addAll(visibleChildren);
                if (filteredChildren.size() == 0) {
                    modelDataPackage = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                        @Override
                        public boolean isExpanded() {
                            return false;
                        }

                        public List<? extends AbstractNode> getVisibleChildren() {
                            return newData.getHiddenChildren().subList(hiddenIndex, hiddenIndex + hiddenSize);
                        }

                        public List<? extends AbstractNode> getInvisibleChildren() {
                            return null;
                        }

                        @Override
                        public PackageType getPackage() {
                            return abstractPackageNode;
                        }

                        @Override
                        public int getPackageIndex() {
                            return packageNodeIndex;
                        }

                        @Override
                        public int getVisibleChildrenSize() {
                            return hiddenSize;
                        }

                        @Override
                        public int getInvisibleChildrenSize() {
                            return 0;
                        }
                    };
                } else {
                    filteredIndex = newData.getFilteredChildren().size();
                    filteredSize = filteredChildren.size();
                    newData.getFilteredChildren().addAll(filteredChildren);
                    modelDataPackage = new PackageControllerTableModelData.PackageControllerTableModelDataPackage(){

                        @Override
                        public boolean isExpanded() {
                            return false;
                        }

                        public List<? extends AbstractNode> getVisibleChildren() {
                            return newData.getHiddenChildren().subList(hiddenIndex, hiddenIndex + hiddenSize);
                        }

                        public List<? extends AbstractNode> getInvisibleChildren() {
                            return newData.getFilteredChildren().subList(filteredIndex, filteredIndex + filteredSize);
                        }

                        @Override
                        public PackageType getPackage() {
                            return abstractPackageNode;
                        }

                        @Override
                        public int getPackageIndex() {
                            return packageNodeIndex;
                        }

                        @Override
                        public int getVisibleChildrenSize() {
                            return hiddenSize;
                        }

                        @Override
                        public int getInvisibleChildrenSize() {
                            return filteredSize;
                        }
                    };
                }
            }
            modelDataPackages.add(modelDataPackage);
        }
        ArrayList<PackageControllerTableModelCustomizer> tableDataCustomizer = new ArrayList<PackageControllerTableModelCustomizer>();
        if (appliedTableDataModifier != null) {
            for (TableDataModification modifier : appliedTableDataModifier) {
                PackageControllerTableModelCustomizer customizer = modifier.finalizeTableModification();
                if (customizer == null) continue;
                tableDataCustomizer.add(customizer);
            }
        }
        newData.setPackageFilters(tableFiltersCompiled.getPackageFilters());
        newData.setChildrenFilters(tableFiltersCompiled.getChildrenFilters());
        newData.setTableModelCustomizer(tableDataCustomizer);
        for (PackageControllerTableModelData.PackageControllerTableModelDataPackage modelDataPackage : modelDataPackages) {
            newData.add(modelDataPackage);
        }
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postSetTableData(List<AbstractNode> newtableData) {
        boolean ret = true;
        if (!(newtableData instanceof PackageControllerTableModelData)) {
            throw new IllegalArgumentException("data must be instanceof PackageControllerTableModelData");
        }
        PackageControllerTableModelData data = (PackageControllerTableModelData)newtableData;
        try {
            if (data.getTableModelCustomizer() != null) {
                for (PackageControllerTableModelCustomizer customizer : data.getTableModelCustomizer()) {
                    ret = customizer.customizedTableData();
                }
            }
        }
        finally {
            data.setTableModelCustomizer(null);
        }
        boolean bl = ret = ret && super.postSetTableData(newtableData);
        if (!this.scrollPositionRestoreDone && newtableData.size() > 0) {
            this.scrollPositionRestoreDone = true;
            int[] rows = this.getScrollPositionFromConfig();
            if (rows != null && rows.length == 2) {
                this.getTable().scrollToRow(rows[0], rows[1]);
            }
        }
        return ret;
    }

    protected abstract int[] getScrollPositionFromConfig();

    protected void setTableData(List<AbstractNode> data) {
        if (!(data instanceof PackageControllerTableModelData)) {
            throw new IllegalArgumentException("data must be instanceof PackageControllerTableModelData");
        }
        this.packageControllertableModelData = (PackageControllerTableModelData)data;
        boolean vs = false;
        for (AbstractNode node : data) {
            if (!(node instanceof AbstractPackageChildrenNode) || !((AbstractPackageChildrenNode)node).hasVariantSupport()) continue;
            vs = true;
            break;
        }
        this.setVariantsSupport(vs);
    }

    protected void setVariantsSupport(boolean vs) {
    }

    protected ExtColumn<AbstractNode> getDefaultSortColumn() {
        return null;
    }

    protected boolean isSortStateSaverEnabled() {
        return false;
    }

    public String getNextSortIdentifier(String sortOrderIdentifier) {
        if (sortOrderIdentifier == null) {
            sortOrderIdentifier = CFG_GUI.CFG.isPrimaryTableSorterDesc() ? "DESC" : "ASC";
        }
        if (!this.isTristateSorterEnabled()) {
            if (sortOrderIdentifier.equals("ASC")) {
                return "DESC";
            }
            return "ASC";
        }
        if (CFG_GUI.CFG.isPrimaryTableSorterDesc()) {
            if (sortOrderIdentifier.equals(SORT_ORIGINAL)) {
                return "DESC";
            }
            if (sortOrderIdentifier.equals("DESC")) {
                return "ASC";
            }
            return SORT_ORIGINAL;
        }
        if (sortOrderIdentifier.equals(SORT_ORIGINAL)) {
            return "ASC";
        }
        if (sortOrderIdentifier.equals("ASC")) {
            return "DESC";
        }
        return SORT_ORIGINAL;
    }

    public Icon getSortIcon(String sortOrderIdentifier) {
        if (SORT_ORIGINAL.equals(sortOrderIdentifier)) {
            return null;
        }
        return super.getSortIcon(sortOrderIdentifier);
    }

    public long getTableDataVersion() {
        return ((PackageControllerTableModelData)this.getTableData()).getVersion();
    }

    private class CompiledFilterList {
        private final List<PackageControllerTableModelFilter<PackageType, ChildrenType>> packageFilters;
        private final List<PackageControllerTableModelFilter<PackageType, ChildrenType>> childrenFilters;

        public List<PackageControllerTableModelFilter<PackageType, ChildrenType>> getPackageFilters() {
            return this.packageFilters;
        }

        public List<PackageControllerTableModelFilter<PackageType, ChildrenType>> getChildrenFilters() {
            return this.childrenFilters;
        }

        private CompiledFilterList() {
            this(new ArrayList(), new ArrayList());
        }

        private CompiledFilterList(List<PackageControllerTableModelFilter<PackageType, ChildrenType>> packageFilters, List<PackageControllerTableModelFilter<PackageType, ChildrenType>> childrenFilters) {
            this.packageFilters = packageFilters;
            this.childrenFilters = childrenFilters;
        }
    }

    public abstract class TableDataModification {
        protected abstract void modifyPackageData(PackageType var1, List<ChildrenType> var2);

        protected PackageControllerTableModelCustomizer finalizeTableModification() {
            return null;
        }
    }

    public static enum TOGGLEMODE {
        CURRENT,
        TOP,
        BOTTOM;

    }
}

