/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.TaskQueue;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerEvent;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkchecker.LinkCheckerListener;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import jd.plugins.PluginProgress;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.PluginTaskID;

public class CheckStatusAction
extends CustomizableTableContextAppAction {
    private static final long serialVersionUID = 6821943398259956694L;

    public CheckStatusAction() {
        this.setIconKey("ok");
        this.setName(_GUI.T.gui_table_contextmenu_check());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        final List children = this.getSelection().getChildren();
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                final ArrayList<CheckableLink> checkableLinks = new ArrayList<CheckableLink>(children.size());
                final LinkCheckProgress linkCheckProgress = new LinkCheckProgress();
                for (Object l : children) {
                    if (l instanceof DownloadLink || l instanceof CrawledLink) {
                        checkableLinks.add((CheckableLink)l);
                    }
                    if (!(l instanceof DownloadLink)) continue;
                    DownloadLink link = (DownloadLink)l;
                    link.addPluginProgress(linkCheckProgress);
                }
                final LinkChecker<Object> linkChecker = new LinkChecker<Object>(true);
                LinkChecker.getEventSender().addListener(new LinkCheckerListener(){

                    @Override
                    public void onLinkCheckerEvent(LinkCheckerEvent event) {
                        if (event.getCaller() == linkChecker && LinkCheckerEvent.Type.STOPPED.equals(event.getType())) {
                            LinkChecker.getEventSender().removeListener(this);
                            for (CheckableLink checkableLink : checkableLinks) {
                                if (!(checkableLink instanceof DownloadLink)) continue;
                                ((DownloadLink)checkableLink).removePluginProgress(linkCheckProgress);
                            }
                        }
                    }
                });
                linkChecker.setLinkCheckHandler(new LinkCheckerHandler<CheckableLink>(){

                    @Override
                    public void linkCheckDone(CheckableLink checkableLink) {
                        if (checkableLink instanceof DownloadLink) {
                            ((DownloadLink)checkableLink).removePluginProgress(linkCheckProgress);
                        }
                    }
                });
                linkChecker.check(checkableLinks);
                return null;
            }
        });
        DownloadsTableModel.getInstance().setAvailableColumnVisible(true);
    }

    public static final class LinkCheckProgress
    extends PluginProgress {
        public LinkCheckProgress() {
            super(-1L, 100L, Color.ORANGE);
            this.icon = new AbstractIcon("help", 18);
        }

        @Override
        public String getMessage(Object requestor) {
            if (requestor instanceof ETAColumn) {
                return null;
            }
            return _GUI.T.CheckStatusAction_getMessage_checking();
        }

        @Override
        public PluginTaskID getID() {
            return PluginTaskID.DECRYPTING;
        }
    }
}

