/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.gui.swing.jdgui.interfaces.View;
import jd.plugins.DownloadLink;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.KeyObserver;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.images.AbstractIcon;

public class EnabledAction
extends CustomizableTableContextAppAction
implements GUIListener,
ActionContext {
    private static final long serialVersionUID = -1733286276459073749L;
    private State state = State.MIXED_ENABLE;
    private boolean metaCtrl = false;
    private EnableActionMode mode = EnableActionMode.AUTO;

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.updateStateAndLabelAndIcon();
    }

    private void updateStateAndLabelAndIcon() {
        SelectionInfo selectionInfo = this.getSelection();
        if (selectionInfo != null) {
            this.state = this.getState(selectionInfo);
            switch (this.state) {
                case MIXED_DISABLE: {
                    this.setSmallIcon(this.state.icon);
                    this.setName(_GUI.T.EnabledAction_EnabledAction_disable());
                    break;
                }
                case MIXED_ENABLE: {
                    this.setSmallIcon(this.state.icon);
                    this.setName(_GUI.T.EnabledAction_EnabledAction_enable());
                    break;
                }
                case ALL_DISABLED: {
                    this.setSmallIcon(this.state.icon);
                    this.setName(_GUI.T.EnabledAction_EnabledAction_enable());
                    break;
                }
                case ALL_ENABLED: {
                    this.setSmallIcon(this.state.icon);
                    this.setName(_GUI.T.EnabledAction_EnabledAction_disable());
                }
            }
        } else {
            this.setSmallIcon(State.MIXED_ENABLE.icon);
            this.setName(_GUI.T.EnabledAction_EnabledAction_empty());
        }
    }

    public static String getTranslationForMode() {
        return _GUI.T.EnabledAction_EnabledAction_mode();
    }

    @Customizer(link="#getTranslationForMode")
    public EnableActionMode getMode() {
        return this.mode;
    }

    public void setMode(EnableActionMode mode) {
        this.mode = mode == null ? EnableActionMode.AUTO : mode;
    }

    public EnabledAction() {
        this.setSmallIcon(EnabledAction.getCheckBoxedIcon("select", true, true));
        this.setName(_GUI.T.EnabledAction_EnabledAction_disable());
        GUIEventSender.getInstance().addListener(this, true);
        this.metaCtrl = KeyObserver.getInstance().isMetaDown(true) || KeyObserver.getInstance().isControlDown(true);
    }

    @Override
    public void onKeyModifier(int parameter) {
        boolean before = this.metaCtrl;
        this.metaCtrl = KeyObserver.getInstance().isControlDown(false) || KeyObserver.getInstance().isMetaDown(false);
        if (before != this.metaCtrl) {
            this.updateStateAndLabelAndIcon();
        }
    }

    private State getState(SelectionInfo<?, ?> selection) {
        switch (this.getMode()) {
            default: {
                if (selection.isEmpty()) {
                    return State.ALL_DISABLED;
                }
                Boolean first = null;
                List<?> children = selection.getChildren();
                for (Object a : children) {
                    AbstractNode node = (AbstractNode)a;
                    if (first == null) {
                        first = node.isEnabled();
                        continue;
                    }
                    if (node.isEnabled() == first.booleanValue()) continue;
                    if (selection.getRawContext() == null) break;
                    node = selection.getRawContext();
                    if (this.metaCtrl) {
                        return node.isEnabled() ? State.MIXED_DISABLE : State.MIXED_ENABLE;
                    }
                    return node.isEnabled() ? State.MIXED_ENABLE : State.MIXED_DISABLE;
                }
                return first != false ? State.ALL_ENABLED : State.ALL_DISABLED;
            }
            case DISABLE: {
                return this.metaCtrl ? State.ALL_DISABLED : State.ALL_ENABLED;
            }
            case ENABLE: 
        }
        return this.metaCtrl ? State.ALL_ENABLED : State.ALL_DISABLED;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final SelectionInfo lSelection = this.getSelection();
        if (!this.isEnabled() && this.hasSelection(lSelection)) {
            return;
        }
        final State lState = this.state;
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                final boolean enable = lState.enable;
                if (!enable) {
                    int count = 0;
                    long i = 0L;
                    if (DownloadWatchDog.getInstance().isRunning()) {
                        for (Object a : lSelection.getChildren()) {
                            DownloadLink link;
                            SingleDownloadController slc;
                            if (!(a instanceof DownloadLink) || (slc = (link = (DownloadLink)a).getDownloadLinkController()) == null || slc.getDownloadInstance() == null || link.isResumeable()) continue;
                            ++count;
                            DownloadInterface dl = slc.getDownloadInstance();
                            if (dl == null || slc.getDownloadLink().isResumeable()) continue;
                            i += slc.getDownloadLink().getView().getBytesLoaded();
                        }
                    }
                    final long bytesToDelete = i;
                    if (count > 0) {
                        final int finalCount = count;
                        new EDTRunner(){

                            protected void runInEDT() {
                                if (bytesToDelete > 0L ? JDGui.bugme((WarnLevel)WarnLevel.SEVERE) && !UIOManager.I().showConfirmDialog(32, _GUI.T.lit_are_you_sure(), _GUI.T.EnableAction_run_msg_(SizeFormatter.formatBytes((long)bytesToDelete), finalCount), (Icon)new AbstractIcon("stop", 32), _GUI.T.lit_yes(), _GUI.T.lit_no()) : JDGui.bugme((WarnLevel)WarnLevel.LOW) && !UIOManager.I().showConfirmDialog(32, _GUI.T.lit_are_you_sure(), _GUI.T.EnableAction_run_msg_(SizeFormatter.formatBytes((long)bytesToDelete), finalCount), (Icon)new AbstractIcon("stop", 32), _GUI.T.lit_yes(), _GUI.T.lit_no())) {
                                    return;
                                }
                                EnabledAction.this.setEnabled(enable, lSelection.getChildren());
                            }
                        };
                        return null;
                    }
                }
                EnabledAction.this.setEnabled(enable, lSelection.getChildren());
                return null;
            }
        });
    }

    private void setEnabled(final boolean b, final List<?> aggregatedLinkList) {
        if (aggregatedLinkList != null && aggregatedLinkList.size() > 0) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    for (Object a : aggregatedLinkList) {
                        ((AbstractNode)a).setEnabled(b);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
    }

    static /* synthetic */ ImageIcon access$100(String x0, boolean x1, boolean x2) {
        return EnabledAction.getCheckBoxedIcon(x0, x1, x2);
    }

    static /* synthetic */ ImageIcon access$200(String x0, boolean x1, boolean x2) {
        return EnabledAction.getCheckBoxedIcon(x0, x1, x2);
    }

    static /* synthetic */ ImageIcon access$300(String x0, boolean x1, boolean x2) {
        return EnabledAction.getCheckBoxedIcon(x0, x1, x2);
    }

    static /* synthetic */ ImageIcon access$400(String x0, boolean x1, boolean x2) {
        return EnabledAction.getCheckBoxedIcon(x0, x1, x2);
    }

    public static enum State {
        ALL_ENABLED(false, EnabledAction.access$100("select", true, true)),
        ALL_DISABLED(true, EnabledAction.access$200("select", false, true)),
        MIXED_ENABLE(true, EnabledAction.access$300("select", true, false)),
        MIXED_DISABLE(false, EnabledAction.access$400("select", false, false));

        private final ImageIcon icon;
        private final boolean enable;

        private State(boolean enable, ImageIcon icon) {
            this.icon = icon;
            this.enable = enable;
        }
    }

    public static enum EnableActionMode implements LabelInterface
    {
        ENABLE{

            @Override
            public String getLabel() {
                return _GUI.T.EnabledAction_EnabledAction_enable();
            }
        }
        ,
        DISABLE{

            @Override
            public String getLabel() {
                return _GUI.T.EnabledAction_EnabledAction_disable();
            }
        }
        ,
        AUTO;


        public String getLabel() {
            return this.name();
        }
    }
}

