/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.DownloadsPanelWidgetContainer;
import org.jdownloader.gui.views.downloads.MenuManagerDownloadTabBottomBar;
import org.jdownloader.gui.views.downloads.WidgetContainer;
import org.jdownloader.gui.views.downloads.bottombar.CustomizeableActionBar;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.gui.views.downloads.table.HorizontalScrollbarAction;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class DownloadsPanel
extends SwitchPanel
implements DownloadControllerListener,
GenericConfigEventListener<Boolean>,
ExtractionListener {
    private static final long serialVersionUID = -2610465878903778445L;
    private final DownloadsTable table;
    private final JScrollPane tableScrollPane;
    private final DownloadsTableModel tableModel;
    private ScheduledFuture<?> timer = null;
    private CustomizeableActionBar bottomBar;
    private WidgetContainer panelContainer;
    public static DownloadsPanel INSTANCE;

    public DownloadsPanel() {
        super((LayoutManager)new MigLayout("ins 0, wrap 2", "[grow,fill]2[fill]", "[grow, fill]2[]2[]"));
        INSTANCE = this;
        this.tableModel = DownloadsTableModel.getInstance();
        this.table = new DownloadsTable(this.tableModel);
        this.tableScrollPane = new JScrollPane((Component)((Object)this.table));
        this.tableScrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                DownloadsPanel.this.table.scrollToSelection(-1);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        LAFOptions.getInstance().getExtension().customizeLinksTable((JComponent)((Object)this.table), this.tableScrollPane);
        HorizontalScrollbarAction.setup(CFG_GUI.HORIZONTAL_SCROLLBARS_IN_DOWNLOAD_TABLE_ENABLED, (ExtTable)this.table);
        this.bottomBar = new CustomizeableActionBar(MenuManagerDownloadTabBottomBar.getInstance()){

            @Override
            public void updateGui() {
                super.updateGui();
                DownloadsPanel.this.table.updateContextShortcuts();
            }
        };
        DownloadController.DOWNLOADLIST_LOADED.executeWhen(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        DownloadsPanel.this.removeAll();
                        DownloadsPanel.this.layoutComponents(true);
                        DownloadsPanel.this.revalidate();
                    }
                };
            }
        }, new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        DownloadsPanel.this.removeAll();
                        DownloadsPanel.this.layoutComponents(false);
                        DownloadsPanel.this.revalidate();
                    }
                };
            }
        });
    }

    private MigPanel createLoaderPanel() {
        MigPanel loaderPanel = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[20%][][]");
        loaderPanel.setOpaque(true);
        loaderPanel.setBackground(LAFOptions.getInstance().getColorForPanelBackground());
        CircledProgressBar loader = new CircledProgressBar(){

            public int getAnimationFPS() {
                return 25;
            }
        };
        loader.setValueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("botty/robot", 256), 1.0f));
        loader.setNonvalueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("botty/robot", 256), 0.1f));
        ((ImagePainter)loader.getValueClipPainter()).setBackground(null);
        ((ImagePainter)loader.getValueClipPainter()).setForeground(null);
        loader.setIndeterminate(true);
        final JProgressBar ph = new JProgressBar();
        ph.setString(_GUI.T.DownloadsTable_DownloadsTable_init_plugins());
        SecondLevelLaunch.HOST_PLUGINS_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        ph.setString(_GUI.T.DownloadsTable_DownloadsTable_object_wait_for_loading_links());
                    }
                };
            }
        });
        ph.setStringPainted(true);
        ph.setIndeterminate(true);
        loaderPanel.add(Box.createHorizontalGlue());
        loaderPanel.add((Component)loader);
        loaderPanel.add((Component)ph, (Object)"alignx center,  width 256!");
        return loaderPanel;
    }

    public DownloadsTable getTable() {
        return this.table;
    }

    private void layoutComponents(boolean downloadListLoaded) {
        if (!downloadListLoaded) {
            MigPanel loader = this.createLoaderPanel();
            this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[grow,fill]"));
            this.add(new JScrollPane((Component)loader), "alignx center,aligny 20%");
        } else {
            this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[grow,fill]0[]0[]"));
            this.add(this.tableScrollPane);
            this.panelContainer = new DownloadsPanelWidgetContainer(this.table, this.bottomBar);
            this.panelContainer.relayout();
            this.add((Component)((Object)this.panelContainer), "hidemode 3,gaptop " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap());
            this.add((Component)((Object)this.bottomBar), "height 24!,gaptop " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onShow() {
        this.tableModel.recreateModel(false);
        DownloadsPanel downloadsPanel = this;
        synchronized (downloadsPanel) {
            if (this.timer != null) {
                this.timer.cancel(false);
            }
            this.timer = this.tableModel.getThreadPool().scheduleWithFixedDelay(new Runnable(){
                long lastContentChanges = -1L;

                @Override
                public void run() {
                    if (!DownloadsPanel.this.getTable().isEditing()) {
                        long contentChanges = DownloadController.getInstance().getContentChanges();
                        if (this.lastContentChanges != contentChanges && DownloadsPanel.this.tableModel.isFilteredView()) {
                            DownloadsPanel.this.tableModel.recreateModel();
                        } else {
                            DownloadsPanel.this.tableModel.refreshModel();
                        }
                        this.lastContentChanges = contentChanges;
                    }
                }
            }, 250L, CFG_GUI.CFG.getDownloadsTableRefreshInterval(), TimeUnit.MILLISECONDS);
        }
        DownloadController.getInstance().addListener(this);
        this.table.requestFocusInWindow();
        if (this.panelContainer != null) {
            this.panelContainer.refreshAfterTabSwitch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHide() {
        Point point = this.tableScrollPane.getViewport().getViewRect().getLocation();
        CFG_GUI.CFG.setDownloadListScrollPosition(new int[]{this.table.getRowIndexByPoint(point), point.x});
        DownloadsPanel downloadsPanel = this;
        synchronized (downloadsPanel) {
            if (this.timer != null) {
                this.timer.cancel(false);
                this.timer = null;
            }
        }
        DownloadController.getInstance().removeListener(this);
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
        this.tableModel.recreateModel();
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
        this.tableModel.recreateModel();
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
        this.tableModel.recreateModel();
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
        this.tableModel.recreateModel();
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        this.tableModel.refreshModel();
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
        this.tableModel.refreshModel();
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
        this.tableModel.refreshModel();
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
        this.tableModel.refreshModel();
    }

    public void onExtractionEvent(ExtractionEvent event) {
    }
}

