/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.settings.GeneralSettings;

public class CleanupDownloadFolderAction
extends CustomizableAppAction {
    public CleanupDownloadFolderAction() {
        this.setName("Cleanup download folder: Delete empty folders");
        this.setIconKey("trash");
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        Thread thread = new Thread("CleanupDownloadFolderAction"){

            @Override
            public void run() {
                String path = PackagizerController.replaceDynamicTags(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder(), null, null);
                File folder = new File(path);
                if (folder == null || !folder.isDirectory()) {
                    return;
                }
                File[] files = folder.listFiles();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    String[] list;
                    if (!file.isDirectory() || (list = file.list()) == null || list.length != 0) continue;
                    file.delete();
                }
            }
        };
        thread.setName("CleanupDownloadFolderAction");
        thread.setDaemon(true);
        thread.start();
    }
}

