/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.TaskQueue;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.download.HashInfo;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.bottombar.IncludedSelectionSetup;

public class ConfirmHashValuesDownloadAction
extends CustomizableTableContextAppAction<FilePackage, DownloadLink>
implements ActionContext,
ExtTableListener,
ExtTableModelListener {
    private IncludedSelectionSetup includedSelection;

    public ConfirmHashValuesDownloadAction() {
        super(true, true);
        this.setIconKey("hashsum");
        this.setName(_GUI.T.ConfirmHashValuesAction());
        this.includedSelection = new IncludedSelectionSetup(DownloadsTable.getInstance(), this, this);
        this.addContextSetup(this.includedSelection);
    }

    @Override
    protected void getSelection(PackageControllerTable.SelectionInfoCallback<FilePackage, DownloadLink> callback, PackageControllerTable.SelectionType selectionType) {
        DownloadsTable.getInstance().getSelectionInfo(callback, selectionType);
    }

    @Override
    protected PackageControllerTable.SelectionType getSelectionType() {
        return this.includedSelection.getSelectionType();
    }

    @Override
    protected void onActionPerformed(ActionEvent e, PackageControllerTable.SelectionType selectionType, SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
        List<DownloadLink> links;
        switch (selectionType) {
            case NONE: {
                return;
            }
            case SELECTED: {
                links = selectionInfo.getChildren();
                break;
            }
            case UNSELECTED: {
                if (selectionInfo.getUnselectedChildren() != null) {
                    links = selectionInfo.getUnselectedChildren();
                    break;
                }
                links = null;
                break;
            }
            default: {
                links = selectionInfo.getChildren();
            }
        }
        if (links == null || links.size() == 0) {
            return;
        }
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                ArrayList<DownloadLink> list;
                HashMap<String, ArrayList<DownloadLink>> map = new HashMap<String, ArrayList<DownloadLink>>();
                for (DownloadLink downloadLink : links) {
                    list = (ArrayList<DownloadLink>)map.get(downloadLink.getName());
                    if (list == null) {
                        list = new ArrayList<DownloadLink>();
                        map.put(downloadLink.getName(), list);
                    }
                    list.add(downloadLink);
                }
                block1: for (Map.Entry entry : map.entrySet()) {
                    list = (List)entry.getValue();
                    HashMap<HashInfo.TYPE, HashInfo> knownHashInfos = new HashMap<HashInfo.TYPE, HashInfo>();
                    for (DownloadLink cl : list) {
                        HashInfo hashInfo = cl.getDownloadLink().getHashInfo();
                        if (hashInfo == null) continue;
                        HashInfo existing = (HashInfo)knownHashInfos.get((Object)hashInfo.getType());
                        if (existing == null) {
                            knownHashInfos.put(hashInfo.getType(), hashInfo);
                            continue;
                        }
                        if (existing.equals(hashInfo)) continue;
                        continue block1;
                    }
                    if (knownHashInfos.size() <= 0) continue;
                    for (HashInfo.TYPE type : HashInfo.TYPE.values()) {
                        HashInfo existing = (HashInfo)knownHashInfos.get((Object)type);
                        if (existing == null) continue;
                        HashInfo newHashInfo = HashInfo.newInstanceSafe(existing.getHash(), existing.getType(), existing.isTrustworthy(), true);
                        for (DownloadLink cl : list) {
                            cl.getDownloadLink().setHashInfo(newHashInfo);
                        }
                        continue block1;
                    }
                }
                return null;
            }
        });
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper event) {
    }
}

