/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.TransferHandler;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.CrawledPackageView;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import jd.plugins.download.HashInfo;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.dragdrop.PackageControllerTableTransferHandler;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.UrlDisplayType;
import org.jdownloader.translate._JDT;

public class CopyGenericContextAction
extends CustomizableTableContextAppAction
implements ActionContext {
    private static final String PATTERN_NAME = "{name}";
    private static final String PATTERN_PACKAGE_NAME = "{packagename}";
    private static final String PATTERN_NAME_NOEXT = "{name_noext}";
    private static final String PATTERN_NEWLINE = "{newline}";
    private static final String PATTERN_TAB = "{tab}";
    private static final String PATTERN_DOWNLOADLINK_PROPERTY = "{jd:prop:yourWishedProperty}";
    private static final String PATTERN_COMMENT = "{comment}";
    private static final String PATTERN_HASH = "{hash}";
    private static final String PATTERN_FILESIZE_RAW = "{filesize_raw}";
    private static final String PATTERN_FILESIZE_B = "{filesize}";
    private static final String PATTERN_FILESIZE_KIB = "{filesize_kib}";
    private static final String PATTERN_FILESIZE_MIB = "{filesize_mib}";
    private static final String PATTERN_FILESIZE_GIB = "{filesize_gib}";
    private static final String PATTERN_URL = "{url}";
    private static final String PATTERN_HOST = "{host}";
    private static final String PATTERN_URL_CONTAINER = "{url.container}";
    private static final String PATTERN_URL_ORIGIN = "{url.origin}";
    private static final String PATTERN_URL_CONTENT = "{url.content}";
    private static final String PATTERN_URL_REFERRER = "{url.referrer}";
    private static final String PATTERN_ARCHIVE_PASSWORD = "{archive.password}";
    private static final String PATTERN_TYPE = "{type}";
    private static final String PATTERN_EXTENSION = "{ext}";
    private static final String PATTERN_PATH = "{path}";
    private String patternPackages;
    private String patternLinks;
    private boolean smartSelection;
    private static final Pattern PROPERTIES_TAG_PATTERN = Pattern.compile("(?i)(\\{jd:prop:([^\\}]+)\\})");

    public CopyGenericContextAction() {
        super(true, true);
        this.setIconKey("copy");
        this.setName(_GUI.T.CopyGenericContextAction());
        this.setAccelerator(67);
    }

    public static String getTranslationForPatternPackages() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(_JDT.T.CopyGenericContextAction_getTranslationForPatternPackages_v3());
        sb.append("<br><ul>");
        for (String pattern : new String[]{PATTERN_TYPE, PATTERN_PATH, PATTERN_COMMENT, PATTERN_FILESIZE_RAW, PATTERN_FILESIZE_B, PATTERN_FILESIZE_KIB, PATTERN_FILESIZE_MIB, PATTERN_FILESIZE_GIB, PATTERN_NEWLINE, PATTERN_TAB, PATTERN_NAME, PATTERN_PACKAGE_NAME}) {
            sb.append("<li>").append(pattern).append("</li>");
        }
        sb.append("</ul></html>");
        return sb.toString();
    }

    public static String getTranslationForPatternLinks() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(_JDT.T.CopyGenericContextAction_getTranslationForPatternLinks_v3());
        sb.append("<br><ul>");
        for (String pattern : new String[]{PATTERN_TYPE, PATTERN_PATH, PATTERN_COMMENT, PATTERN_FILESIZE_RAW, PATTERN_FILESIZE_B, PATTERN_FILESIZE_KIB, PATTERN_FILESIZE_MIB, PATTERN_FILESIZE_GIB, PATTERN_NEWLINE, PATTERN_TAB, PATTERN_NAME, PATTERN_PACKAGE_NAME, PATTERN_HOST, PATTERN_NAME_NOEXT, PATTERN_EXTENSION, PATTERN_HASH, PATTERN_URL, PATTERN_URL_CONTAINER, PATTERN_URL_CONTENT, PATTERN_URL_ORIGIN, PATTERN_URL_REFERRER, PATTERN_ARCHIVE_PASSWORD, PATTERN_DOWNLOADLINK_PROPERTY}) {
            sb.append("<li>").append(pattern).append("</li>");
        }
        sb.append("</ul></html>");
        return sb.toString();
    }

    public static String getTranslationForSmartSelection() {
        return _JDT.T.CopyGenericContextAction_getTranslationForSmartSelection();
    }

    @Customizer(link="#getTranslationForPatternPackages")
    public String getPatternPackages() {
        return this.patternPackages;
    }

    public void setPatternPackages(String copyPattern) {
        this.patternPackages = copyPattern;
        this.setTooltipText(_GUI.T.CopyGenericContextAction_tt(this.getPatternPackages() + " - " + this.getPatternLinks()));
    }

    @Customizer(link="#getTranslationForPatternLinks")
    public String getPatternLinks() {
        return this.patternLinks;
    }

    public void setPatternLinks(String patternLinks) {
        this.patternLinks = patternLinks;
        this.setTooltipText(_GUI.T.CopyGenericContextAction_tt(this.getPatternPackages() + " - " + this.getPatternLinks()));
    }

    @Customizer(link="#getTranslationForSmartSelection")
    public boolean isSmartSelection() {
        return this.smartSelection;
    }

    public void setSmartSelection(boolean smartSelection) {
        this.smartSelection = smartSelection;
    }

    @Override
    protected void initTableContext(boolean empty, boolean selection) {
    }

    @Override
    public void initContextDefaults() {
        super.initContextDefaults();
        this.patternPackages = "";
        this.patternLinks = "{type};{name};{url}";
        this.smartSelection = true;
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
    }

    public <ParentType extends AbstractPackageNode<ChildrenType, ParentType>, ChildrenType extends AbstractPackageChildrenNode<ParentType>> PackageControllerTable.SelectionInfoCallback<ParentType, ChildrenType> getCallback(final PackageControllerTable<ParentType, ChildrenType> table) {
        return new PackageControllerTable.SelectionInfoCallback<ParentType, ChildrenType>(){

            @Override
            public void onSelectionInfo(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                TransferHandler transferHandler;
                StringBuilder sb = new StringBuilder();
                if (CopyGenericContextAction.this.isSmartSelection()) {
                    SelectionInfo.PackageView pv;
                    List childs;
                    int children = 0;
                    Iterator iterator = selectionInfo.getPackageViews().iterator();
                    while (iterator.hasNext() && (children += (childs = (pv = iterator.next()).getChildren()).size()) <= 1) {
                    }
                    boolean contentPermission = children == 1;
                    for (SelectionInfo.PackageView pv2 : selectionInfo.getPackageViews()) {
                        Object pkg = pv2.getPackage();
                        CopyGenericContextAction.this.add(sb, (AbstractNode)pkg, false);
                        List childs2 = pv2.getChildren();
                        for (AbstractPackageChildrenNode c : childs2) {
                            CopyGenericContextAction.this.add(sb, c, contentPermission);
                        }
                    }
                } else {
                    List<AbstractNode> selection = selectionInfo.getRawSelection();
                    boolean contentPermission = selection.size() == 1 && selection.get(0) instanceof AbstractPackageChildrenNode;
                    for (AbstractNode pv : selection) {
                        CopyGenericContextAction.this.add(sb, pv, contentPermission);
                    }
                }
                if ((transferHandler = table.getTransferHandler()) instanceof PackageControllerTableTransferHandler) {
                    ((PackageControllerTableTransferHandler)transferHandler).setTransferableStringContent(sb.toString());
                    transferHandler.getCopyAction().actionPerformed(new ActionEvent((Object)table, 1001, "copy"));
                } else {
                    ClipboardMonitoring.getINSTANCE().setCurrentContent(sb.toString());
                }
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (MainTabbedPane.getInstance().isDownloadView()) {
            DownloadsTable.getInstance().getSelectionInfo(this.getCallback(DownloadsTable.getInstance()), PackageControllerTable.SelectionType.SELECTED);
        } else if (MainTabbedPane.getInstance().isLinkgrabberView()) {
            LinkGrabberTable.getInstance().getSelectionInfo(this.getCallback(LinkGrabberTable.getInstance()), PackageControllerTable.SelectionType.SELECTED);
        }
    }

    private final String getUrlByType(UrlDisplayType dt, AbstractNode node) {
        DownloadLink link;
        if (node instanceof DownloadLink) {
            link = (DownloadLink)node;
        } else if (node instanceof CrawledLink) {
            link = ((CrawledLink)node).getDownloadLink();
        } else {
            return null;
        }
        switch (dt) {
            case CUSTOM: {
                return link.getCustomUrl();
            }
            case REFERRER: {
                return link.getReferrerUrl();
            }
            case CONTAINER: {
                return link.getContainerUrl();
            }
            case ORIGIN: {
                return link.getOriginUrl();
            }
            case CONTENT: {
                String contentURL = link.getContentUrl();
                if (contentURL != null) {
                    return contentURL;
                }
                return link.getPluginPatternMatcher();
            }
        }
        return null;
    }

    private final String formatFileSize(long fileSize, GraphicalUserInterfaceSettings.SIZEUNIT sizeUnit) {
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(sizeUnit, fileSize);
    }

    private final String toUpperCase(String input) {
        if (input != null) {
            return input.toUpperCase(Locale.ENGLISH);
        }
        return null;
    }

    private final String replaceDate(String line) {
        String[] timeFormat;
        while ((timeFormat = new Regex(line, "(\\{date_(.*?)\\})").getRow(0)) != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(timeFormat[1], Locale.ENGLISH);
                line = line.replace(timeFormat[0], dateFormat.format(new Date(System.currentTimeMillis())));
            }
            catch (Throwable e) {
                line = line.replace(timeFormat[0], "");
            }
        }
        return line;
    }

    private final String replaceArchiveInfos(AbstractNode pv, String line) {
        if (StringUtils.contains((String)line, (String)PATTERN_ARCHIVE_PASSWORD)) {
            List archives = ArchiveValidator.getArchivesFromPackageChildren(Arrays.asList(pv), (int)1);
            line = archives != null && archives.size() == 1 ? line.replace(PATTERN_ARCHIVE_PASSWORD, this.nulltoString(((Archive)archives.get(0)).getFinalPassword())) : line.replace(PATTERN_ARCHIVE_PASSWORD, this.nulltoString(null));
        }
        return line;
    }

    public void add(StringBuilder sb, AbstractNode pv, boolean contentPermission) {
        String line = null;
        if (pv instanceof FilePackage) {
            line = this.getPatternPackages();
            line = this.replaceDate(line);
            FilePackage pkg = (FilePackage)pv;
            FilePackageView fpv = new FilePackageView(pkg);
            fpv.aggregate();
            line = line.replace(PATTERN_TYPE, "Package");
            line = line.replace(PATTERN_PATH, this.nulltoString(LinkTreeUtils.getDownloadDirectory(pkg)));
            line = line.replace(PATTERN_COMMENT, this.nulltoString(pkg.getComment()));
            long fileSize = fpv.getSize();
            line = line.replace(PATTERN_FILESIZE_RAW, this.nulltoString(Long.toString(fileSize)));
            line = line.replace(PATTERN_FILESIZE_B, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.B)));
            line = line.replace(PATTERN_FILESIZE_KIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.KiB)));
            line = line.replace(PATTERN_FILESIZE_MIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.MiB)));
            line = line.replace(PATTERN_FILESIZE_GIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.GiB)));
            line = line.replace(PATTERN_NEWLINE, CrossSystem.getNewLine());
            line = line.replace(PATTERN_TAB, "\t");
            String name = pkg.getName();
            line = line.replace(PATTERN_NAME, this.nulltoString(name));
            line = line.replace(PATTERN_PACKAGE_NAME, this.nulltoString(name));
        } else if (pv instanceof DownloadLink) {
            line = this.getPatternLinks();
            line = this.replaceDate(line);
            line = this.replaceArchiveInfos(pv, line);
            DownloadLink link = (DownloadLink)pv;
            FilePackage fp = link.getFilePackage();
            line = line.replace(PATTERN_TYPE, "Link");
            line = line.replace(PATTERN_HOST, this.nulltoString(link.getHost()));
            line = line.replace(PATTERN_PATH, this.nulltoString(LinkTreeUtils.getDownloadDirectory(link)));
            line = line.replace(PATTERN_COMMENT, this.nulltoString(link.getComment()));
            long fileSize = link.getView().getBytesTotalEstimated();
            line = line.replace(PATTERN_FILESIZE_RAW, this.nulltoString(Long.toString(fileSize)));
            line = line.replace(PATTERN_FILESIZE_B, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.B)));
            line = line.replace(PATTERN_FILESIZE_KIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.KiB)));
            line = line.replace(PATTERN_FILESIZE_MIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.MiB)));
            line = line.replace(PATTERN_FILESIZE_GIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.GiB)));
            line = line.replace(PATTERN_NEWLINE, CrossSystem.getNewLine());
            line = line.replace(PATTERN_TAB, "\t");
            line = this.replaceDownloadLinkProperties(link, line);
            String name = link.getView().getDisplayName();
            line = line.replace(PATTERN_NAME, this.nulltoString(name));
            line = line.replace(PATTERN_PACKAGE_NAME, this.nulltoString(fp.getName()));
            line = line.replace(PATTERN_NAME_NOEXT, this.nulltoString(Files.getFileNameWithoutExtension((String)name)));
            line = line.replace(PATTERN_EXTENSION, this.nulltoString(this.toUpperCase(Files.getExtension((String)name))));
            HashInfo hashInfo = link.getHashInfo();
            for (HashInfo.TYPE hashType : HashInfo.TYPE.values()) {
                String hashString = hashInfo != null && hashInfo.getType() == hashType ? hashInfo.getHash() : null;
                line = line.replace("{" + hashType.name().replace("-", "").toLowerCase(Locale.ENGLISH) + "}", this.nulltoString(hashString));
            }
            line = line.replace(PATTERN_HASH, this.nulltoString(hashInfo != null ? hashInfo.getHash() : null));
            line = line.replace(PATTERN_URL, this.nulltoString(link.getView().getDisplayUrl()));
            line = line.replace(PATTERN_URL_CONTAINER, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.CONTAINER, link)));
            line = contentPermission ? line.replace(PATTERN_URL_CONTENT, this.nulltoString(this.getUrlByType(UrlDisplayType.CONTENT, link))) : line.replace(PATTERN_URL_CONTENT, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.CONTENT, link)));
            line = line.replace(PATTERN_URL_ORIGIN, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.ORIGIN, link)));
            line = line.replace(PATTERN_URL_REFERRER, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.REFERRER, link)));
        } else if (pv instanceof CrawledLink) {
            line = this.getPatternLinks();
            line = this.replaceDate(line);
            line = this.replaceArchiveInfos(pv, line);
            CrawledLink link = (CrawledLink)pv;
            CrawledPackage cp = link.getParentNode();
            line = line.replace(PATTERN_TYPE, "Link");
            line = line.replace(PATTERN_HOST, this.nulltoString(link.getHost()));
            line = line.replace(PATTERN_COMMENT, this.nulltoString(link.getComment()));
            line = line.replace(PATTERN_PATH, this.nulltoString(LinkTreeUtils.getDownloadDirectory(link)));
            long fileSize = link.getSize();
            line = line.replace(PATTERN_FILESIZE_RAW, this.nulltoString(Long.toString(fileSize)));
            line = line.replace(PATTERN_FILESIZE_B, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.B)));
            line = line.replace(PATTERN_FILESIZE_KIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.KiB)));
            line = line.replace(PATTERN_FILESIZE_MIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.MiB)));
            line = line.replace(PATTERN_FILESIZE_GIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.GiB)));
            line = line.replace(PATTERN_NEWLINE, CrossSystem.getNewLine());
            line = line.replace(PATTERN_TAB, "\t");
            line = this.replaceDownloadLinkProperties(link.getDownloadLink(), line);
            String name = link.getName();
            line = line.replace(PATTERN_NAME, this.nulltoString(name));
            line = line.replace(PATTERN_PACKAGE_NAME, this.nulltoString(cp.getName()));
            line = line.replace(PATTERN_NAME_NOEXT, this.nulltoString(Files.getFileNameWithoutExtension((String)name)));
            line = line.replace(PATTERN_EXTENSION, this.nulltoString(this.toUpperCase(Files.getExtension((String)name))));
            HashInfo hashInfo = link.getDownloadLink().getHashInfo();
            for (HashInfo.TYPE hashType : HashInfo.TYPE.values()) {
                String hashString = hashInfo != null && hashInfo.getType() == hashType ? hashInfo.getHash() : null;
                line = line.replace("{" + hashType.name().replace("-", "").toLowerCase(Locale.ENGLISH) + "}", this.nulltoString(hashString));
            }
            line = line.replace(PATTERN_HASH, this.nulltoString(hashInfo != null ? hashInfo.getHash() : null));
            line = line.replace(PATTERN_URL, this.nulltoString(link.getDownloadLink().getView().getDisplayUrl()));
            line = line.replace(PATTERN_URL_CONTAINER, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.CONTAINER, link)));
            line = contentPermission ? line.replace(PATTERN_URL_CONTENT, this.nulltoString(this.getUrlByType(UrlDisplayType.CONTENT, link))) : line.replace(PATTERN_URL_CONTENT, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.CONTENT, link)));
            line = line.replace(PATTERN_URL_ORIGIN, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.ORIGIN, link)));
            line = line.replace(PATTERN_URL_REFERRER, this.nulltoString(LinkTreeUtils.getUrlByType(UrlDisplayType.REFERRER, link)));
        } else if (pv instanceof CrawledPackage) {
            line = this.getPatternPackages();
            line = this.replaceDate(line);
            CrawledPackage pkg = (CrawledPackage)pv;
            CrawledPackageView fpv = new CrawledPackageView(pkg).aggregate();
            line = line.replace(PATTERN_TYPE, "Package");
            line = line.replace(PATTERN_COMMENT, this.nulltoString(pkg.getComment()));
            line = line.replace(PATTERN_PATH, this.nulltoString(LinkTreeUtils.getDownloadDirectory(pkg)));
            long fileSize = fpv.getFileSize();
            line = line.replace(PATTERN_FILESIZE_RAW, this.nulltoString(Long.toString(fileSize)));
            line = line.replace(PATTERN_FILESIZE_B, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.B)));
            line = line.replace(PATTERN_FILESIZE_KIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.KiB)));
            line = line.replace(PATTERN_FILESIZE_MIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.MiB)));
            line = line.replace(PATTERN_FILESIZE_GIB, this.nulltoString(this.formatFileSize(fileSize, GraphicalUserInterfaceSettings.SIZEUNIT.GiB)));
            line = line.replace(PATTERN_NEWLINE, CrossSystem.getNewLine());
            line = line.replace(PATTERN_TAB, "\t");
            String name = pkg.getName();
            line = line.replace(PATTERN_NAME, this.nulltoString(name));
            line = line.replace(PATTERN_PACKAGE_NAME, this.nulltoString(name));
        }
        if (StringUtils.isNotEmpty((String)line)) {
            if (sb.length() > 0) {
                sb.append(CrossSystem.getNewLine());
            }
            sb.append(line);
        }
    }

    private final String replaceDownloadLinkProperties(DownloadLink link, String input) {
        String[][] propertiesToReplace;
        String line = input;
        for (String[] propertyInfo : propertiesToReplace = new Regex((Object)input, PROPERTIES_TAG_PATTERN).getMatches()) {
            String completeStringToReplace = propertyInfo[0];
            String property = propertyInfo[1];
            String content = this.nulltoString(link.getProperty(property));
            line = line.replace(completeStringToReplace, content);
        }
        return line;
    }

    private final String nulltoString(Object comment) {
        return StringUtils.valueOrEmpty((String)StringUtils.valueOfOrNull((Object)comment));
    }
}

