/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.uio.CloseReason;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.controlling.DownloadLinkAggregator;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.downloads.action.ConfirmDeleteLinksDialog;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.utils.JDFileUtils;

public class DownloadTabActionUtils {
    public static void deleteLinksRequest(final SelectionInfo<FilePackage, DownloadLink> si, final String msg, final GraphicalUserInterfaceSettings.DeleteFileOptions mode, final boolean byPassDialog) {
        final DownloadLinkAggregator agg = new DownloadLinkAggregator();
        agg.setMirrorHandlingEnabled(false);
        agg.setLocalFileUsageEnabled(true);
        agg.update(si.getChildren());
        if (agg.getTotalCount() > 0) {
            new EDTHelper<Void>(){

                public Void edtRun() {
                    WarnLevel level = WarnLevel.LOW;
                    switch (mode) {
                        case REMOVE_LINKS_AND_DELETE_FILES: {
                            if (agg.getBytesLoaded() > 0L) {
                                level = WarnLevel.SEVERE;
                                break;
                            }
                            level = WarnLevel.NORMAL;
                            break;
                        }
                        case REMOVE_LINKS_AND_RECYCLE_FILES: {
                            if (agg.getBytesLoaded() > 0L) {
                                level = WarnLevel.SEVERE;
                                break;
                            }
                            if (agg.getFinishedCount() == agg.getTotalCount()) break;
                            level = WarnLevel.NORMAL;
                            break;
                        }
                        case REMOVE_LINKS_ONLY: {
                            if (agg.getBytesLoaded() > 0L) {
                                level = WarnLevel.SEVERE;
                                break;
                            }
                            if (agg.getFinishedCount() == agg.getTotalCount()) break;
                            level = WarnLevel.NORMAL;
                        }
                    }
                    boolean finalByPassDialog = !JDGui.bugme((WarnLevel)level) ? true : byPassDialog;
                    if (!finalByPassDialog && !CFG_GUI.CFG.isBypassAllRlyDeleteDialogsEnabled()) {
                        ConfirmDeleteLinksDialog dialog = new ConfirmDeleteLinksDialog(msg + "\r\n" + _GUI.T.DeleteSelectionAction_actionPerformed_affected2(agg.getTotalCount(), SizeFormatter.formatBytes((long)agg.getBytesLoaded()), DownloadController.getInstance().getChildrenCount() - agg.getTotalCount(), agg.getLocalFileCount()), agg.getBytesLoaded());
                        dialog.setRecycleSupported(JDFileUtils.isTrashSupported());
                        dialog.setMode(mode);
                        dialog.show();
                        if (dialog.getCloseReason() == CloseReason.OK) {
                            switch (dialog.getMode()) {
                                case REMOVE_LINKS_ONLY: {
                                    DownloadController.getInstance().removeChildren(si.getChildren());
                                    break;
                                }
                                case REMOVE_LINKS_AND_DELETE_FILES: {
                                    DownloadController.getInstance().removeChildren(si.getChildren());
                                    DownloadWatchDog.getInstance().delete(si.getChildren(), FileCreationManager.DeleteOption.NULL);
                                    break;
                                }
                                case REMOVE_LINKS_AND_RECYCLE_FILES: {
                                    DownloadController.getInstance().removeChildren(si.getChildren());
                                    DownloadWatchDog.getInstance().delete(si.getChildren(), FileCreationManager.DeleteOption.RECYCLE);
                                }
                            }
                        }
                    } else {
                        switch (mode) {
                            case REMOVE_LINKS_ONLY: {
                                DownloadController.getInstance().removeChildren(si.getChildren());
                                break;
                            }
                            case REMOVE_LINKS_AND_DELETE_FILES: {
                                DownloadController.getInstance().removeChildren(si.getChildren());
                                DownloadWatchDog.getInstance().delete(si.getChildren(), FileCreationManager.DeleteOption.NULL);
                                break;
                            }
                            case REMOVE_LINKS_AND_RECYCLE_FILES: {
                                DownloadController.getInstance().removeChildren(si.getChildren());
                                DownloadWatchDog.getInstance().delete(si.getChildren(), JDFileUtils.isTrashSupported() ? FileCreationManager.DeleteOption.RECYCLE : FileCreationManager.DeleteOption.NULL);
                            }
                        }
                    }
                    return null;
                }
            }.start(true);
        }
    }
}

