/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableSelectionAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.translate._JDT;

public class GenericChunksAction
extends CustomizableSelectionAppAction
implements ActionContext {
    private static final long serialVersionUID = 1L;
    public static final String CHUNKS = "CHUNKS";
    private int chunks = 0;

    public GenericChunksAction() {
        this.setName(Integer.toString(Math.max(0, this.chunks)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final SelectionInfo selectionInfo = this.getSelection();
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (selectionInfo != null) {
                    for (Object child : selectionInfo.getChildren()) {
                        DownloadLink downloadLink;
                        if (child instanceof DownloadLink) {
                            ((DownloadLink)child).setChunks(GenericChunksAction.this.chunks);
                            continue;
                        }
                        if (!(child instanceof CrawledLink) || (downloadLink = ((CrawledLink)child).getDownloadLink()) == null) continue;
                        downloadLink.setChunks(GenericChunksAction.this.chunks);
                    }
                }
                return null;
            }
        });
    }

    public void setChunks(int chunks) {
        this.chunks = Math.max(0, chunks);
    }

    public static String getTranslationChunks() {
        return _JDT.T.GenericChunksAction_getTranslationChunks();
    }

    @Customizer(link="#getTranslationChunks")
    public int getChunks() {
        return this.chunks;
    }

    @Override
    public void loadContextSetups() {
        super.loadContextSetups();
        new EDTRunner(){

            protected void runInEDT() {
                GenericChunksAction.this.setName(Integer.toString(Math.max(0, GenericChunksAction.this.chunks)));
            }
        }.start();
    }
}

