/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;

public class ResumeToolbarAction
extends AbstractToolBarAction
implements ExtTableListener {
    private static final long serialVersionUID = 1L;
    private static final String NAME = _GUI.T.gui_table_contextmenu_resume();

    public ResumeToolbarAction() {
        this.setIconKey("resume");
        this.setName(NAME);
        GUIEventSender.getInstance().addListener(this, true);
        this.onGuiMainTabSwitch(null, MainTabbedPane.getInstance().getSelectedView());
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            DownloadsTable.getInstance().getSelectionInfo(new PackageControllerTable.SelectionInfoCallback<FilePackage, DownloadLink>(){

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public void onSelectionInfo(SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
                    DownloadWatchDog.getInstance().resume(selectionInfo.getChildren());
                }
            }, PackageControllerTable.SelectionType.SELECTED);
        }
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
        if (newView instanceof DownloadsView) {
            DownloadsTableModel.getInstance().getTable().getEventSender().addListener((EventListener)this, true);
            this.updateState();
        } else {
            DownloadsTableModel.getInstance().getTable().getEventSender().removeListener((EventListener)this);
            this.setEnabled(false);
        }
    }

    private void updateState() {
        DownloadsTable.getInstance().getSelectionInfo(new PackageControllerTable.SelectionInfoCallback<FilePackage, DownloadLink>(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void onSelectionInfo(final SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
                new EDTRunner(){

                    protected void runInEDT() {
                        ResumeToolbarAction.this.setEnabled(!selectionInfo.isEmpty());
                    }
                };
            }
        }, PackageControllerTable.SelectionType.SELECTED);
    }

    @Override
    protected String createTooltip() {
        return NAME;
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
        switch ((ExtTableEvent.Types)event.getType()) {
            case SELECTION_CHANGED: {
                this.updateState();
                break;
            }
        }
    }
}

