/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.overviewpanel;

import java.awt.Component;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.menu.ChunksEditor;
import jd.gui.swing.jdgui.menu.ParalellDownloadsEditor;
import jd.gui.swing.jdgui.menu.ParallelDownloadsPerHostEditor;
import jd.gui.swing.jdgui.menu.SpeedlimitEditor;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.controlling.AggregatedNumbers;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.overviewpanel.AbstractOverviewPanel;
import org.jdownloader.gui.views.downloads.overviewpanel.DataEntry;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class DownloadOverview
extends AbstractOverviewPanel<AggregatedNumbers, FilePackage, DownloadLink>
implements DownloadControllerListener,
HierarchyListener,
GenericConfigEventListener<Boolean>,
GUIListener {
    private static final long serialVersionUID = 7849517111823717677L;
    private ListSelectionListener listSelection;
    private TableModelListener tableListener;
    private StateEventListener stateListener;
    private GenericConfigEventListener<Boolean> settingsListener;

    private boolean isIncludeDisabled() {
        return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_PANEL_INCLUDE_DISABLED_LINKS.isEnabled();
    }

    @Override
    public void onKeyModifier(int parameter) {
    }

    public DownloadOverview(DownloadsTable table) {
        super(table.getModel());
        CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_PANEL_INCLUDE_DISABLED_LINKS.getEventSender().addListener((EventListener)this, true);
        final MigPanel settings = new MigPanel("ins 2 0 0 0 ,wrap 3", "[][fill][fill]", "[]2[]");
        SwingUtils.setOpaque((JComponent)settings, (boolean)false);
        settings.add((Component)new JSeparator(1), (Object)"spany,pushy,growy");
        settings.add((Component)new ChunksEditor(true));
        settings.add((Component)new ParalellDownloadsEditor(true));
        settings.add((Component)new ParallelDownloadsPerHostEditor(true));
        settings.add((Component)new SpeedlimitEditor(true));
        this.settingsListener = new GenericConfigEventListener<Boolean>(){

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                settings.setVisible(newValue.booleanValue());
            }
        };
        CFG_GUI.DOWNLOAD_PANEL_OVERVIEW_SETTINGS_VISIBLE.getEventSender().addListener((EventListener)this.settingsListener);
        settings.setVisible(CFG_GUI.DOWNLOAD_PANEL_OVERVIEW_SETTINGS_VISIBLE.isEnabled());
        CFG_GUI.DOWNLOAD_TAB_OVERVIEW_VISIBLE.getEventSender().addListener((EventListener)this, true);
        this.add(Box.createHorizontalGlue());
        this.add((Component)settings, "hidemode 3");
        DownloadController.getInstance().addListener(this, true);
        this.tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DownloadOverview.this.slowDelayer.run();
            }
        };
        this.tableModel.addTableModelListener(this.tableListener);
        this.stateListener = new StateEventListener(){

            public void onStateUpdate(StateEvent event) {
            }

            public void onStateChange(final StateEvent event) {
                new EDTRunner(){

                    protected void runInEDT() {
                        if (event.getNewState() == DownloadWatchDog.RUNNING_STATE || event.getNewState() == DownloadWatchDog.PAUSE_STATE) {
                            DownloadOverview.this.startUpdateTimer();
                        } else {
                            DownloadOverview.this.stopUpdateTimer();
                        }
                    }
                };
            }
        };
        DownloadWatchDog.getInstance().getStateMachine().addListener(this.stateListener);
        this.listSelection = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e == null || e.getValueIsAdjusting() || DownloadOverview.this.tableModel.isTableSelectionClearing()) {
                    return;
                }
                DownloadOverview.this.onConfigValueModified(null, null);
            }
        };
        this.tableModel.getTable().getSelectionModel().addListSelectionListener(this.listSelection);
    }

    @Override
    protected List<DataEntry<AggregatedNumbers>> createDataEntries() {
        PackagesEntry packageCount = new PackagesEntry(_GUI.T.DownloadOverview_DownloadOverview_packages());
        BytesTotalEntry size = new BytesTotalEntry(_GUI.T.DownloadOverview_DownloadOverview_size());
        BytesLoadedEntry bytesLoaded = new BytesLoadedEntry(_GUI.T.DownloadOverview_DownloadOverview_loaded());
        BytesRemainingEntry bytesRemaining = new BytesRemainingEntry(_GUI.T.DownloadOverview_DownloadOverview_remaining());
        DownloadsEntry runningDownloads = new DownloadsEntry(_GUI.T.DownloadOverview_DownloadOverview_running_downloads());
        LinksCountEntry linkCount = new LinksCountEntry(_GUI.T.DownloadOverview_DownloadOverview_links());
        SpeedEntry speed = new SpeedEntry(_GUI.T.DownloadOverview_DownloadOverview_speed());
        ETAEntry eta = new ETAEntry(_GUI.T.DownloadOverview_DownloadOverview_eta());
        ConnectionsEntry connections = new ConnectionsEntry(_GUI.T.DownloadOverview_DownloadOverview_connections());
        FinishedEntry finishedDownloads = new FinishedEntry(_GUI.T.DownloadOverview_DownloadOverview_finished_downloads());
        SkippedEntry skippedDownloads = new SkippedEntry(_GUI.T.DownloadOverview_DownloadOverview_skipped_downloads());
        FailedEntry failedDownloads = new FailedEntry(_GUI.T.DownloadOverview_DownloadOverview_failed_downloads());
        ArrayList<DataEntry<AggregatedNumbers>> entries = new ArrayList<DataEntry<AggregatedNumbers>>();
        entries.add(packageCount);
        entries.add(linkCount);
        entries.add(size);
        entries.add(speed);
        entries.add(bytesLoaded);
        entries.add(bytesRemaining);
        entries.add(eta);
        entries.add(runningDownloads);
        entries.add(connections);
        entries.add(finishedDownloads);
        entries.add(skippedDownloads);
        entries.add(failedDownloads);
        return entries;
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        new EDTRunner(){

            protected void runInEDT() {
                CFG_GUI.DOWNLOAD_PANEL_OVERVIEW_SETTINGS_VISIBLE.getEventSender().removeListener((EventListener)DownloadOverview.this.settingsListener);
                CFG_GUI.DOWNLOAD_TAB_OVERVIEW_VISIBLE.getEventSender().removeListener((EventListener)DownloadOverview.this);
                DownloadController.getInstance().removeListener(DownloadOverview.this);
                DownloadOverview.this.tableModel.removeTableModelListener(DownloadOverview.this.tableListener);
                DownloadOverview.this.tableModel.getTable().getSelectionModel().removeListSelectionListener(DownloadOverview.this.listSelection);
                DownloadWatchDog.getInstance().getStateMachine().removeListener(DownloadOverview.this.stateListener);
            }
        };
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
        this.slowDelayer.run();
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
        this.slowDelayer.run();
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
        this.slowDelayer.run();
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        this.slowDelayer.run();
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
        this.slowDelayer.run();
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
        this.slowDelayer.run();
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
        this.slowDelayer.run();
    }

    @Override
    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        if (CFG_GUI.DOWNLOAD_TAB_OVERVIEW_VISIBLE == keyHandler && Boolean.FALSE.equals(newValue)) {
            this.removeListeners();
            this.visible.set(false);
        } else {
            super.onConfigValueModified(keyHandler, newValue);
        }
    }

    @Override
    protected boolean isActiveView(View newView) {
        return newView instanceof DownloadsView;
    }

    @Override
    protected AggregatedNumbers createSelected() {
        return new AggregatedNumbers(this.tableModel.getTable().getSelectionInfo(true, true));
    }

    @Override
    protected AggregatedNumbers createFiltered() {
        return new AggregatedNumbers(this.tableModel.getTable().getSelectionInfo(false, true));
    }

    @Override
    protected AggregatedNumbers createTotal() {
        return new AggregatedNumbers(this.tableModel.getTable().getSelectionInfo(false, false));
    }

    private final class PackagesEntry
    extends DataEntry<AggregatedNumbers> {
        private PackagesEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            if (total != null) {
                this.setTotal(Integer.toString(total.getPackageCount()));
            }
            if (filtered != null) {
                this.setFiltered(Integer.toString(filtered.getPackageCount()));
            }
            if (selected != null) {
                this.setSelected(Integer.toString(selected.getPackageCount()));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_PACKAGE_COUNT_VISIBLE;
        }
    }

    private final class BytesTotalEntry
    extends DataEntry<AggregatedNumbers> {
        private BytesTotalEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            boolean includeDisabled = DownloadOverview.this.isIncludeDisabled();
            if (total != null) {
                this.setTotal(total.getTotalBytesString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getTotalBytesString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getTotalBytesString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_TOTAL_BYTES_VISIBLE;
        }
    }

    private final class BytesRemainingEntry
    extends DataEntry<AggregatedNumbers> {
        private BytesRemainingEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            boolean includeDisabled = DownloadOverview.this.isIncludeDisabled();
            if (total != null) {
                this.setTotal(total.getRemainingBytesString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getRemainingBytesString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getRemainingBytesString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_BYTES_REMAINING_VISIBLE;
        }
    }

    private final class BytesLoadedEntry
    extends DataEntry<AggregatedNumbers> {
        private BytesLoadedEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            boolean includeDisabled = DownloadOverview.this.isIncludeDisabled();
            if (total != null) {
                this.setTotal(total.getLoadedBytesString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getLoadedBytesString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getLoadedBytesString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_BYTES_LOADED_VISIBLE;
        }
    }

    private final class DownloadsEntry
    extends DataEntry<AggregatedNumbers> {
        private DownloadsEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            if (total != null) {
                this.setTotal(Long.toString(total.getRunning()));
            }
            if (filtered != null) {
                this.setFiltered(Long.toString(filtered.getRunning()));
            }
            if (selected != null) {
                this.setSelected(Long.toString(selected.getRunning()));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_RUNNING_DOWNLOADS_COUNT_VISIBLE;
        }
    }

    private final class LinksCountEntry
    extends DataEntry<AggregatedNumbers> {
        private LinksCountEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            if (total != null) {
                this.setTotal(Integer.toString(total.getLinkCount()));
            }
            if (filtered != null) {
                this.setFiltered(Integer.toString(filtered.getLinkCount()));
            }
            if (selected != null) {
                this.setSelected(Integer.toString(selected.getLinkCount()));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_LINK_COUNT_VISIBLE;
        }
    }

    private final class SpeedEntry
    extends DataEntry<AggregatedNumbers> {
        private SpeedEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            if (total != null) {
                this.setTotal(total.getDownloadSpeedString());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getDownloadSpeedString());
            }
            if (selected != null) {
                this.setSelected(selected.getDownloadSpeedString());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_SPEED_VISIBLE;
        }
    }

    private final class ETAEntry
    extends DataEntry<AggregatedNumbers> {
        private ETAEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            if (total != null) {
                this.setTotal(total.getEtaString());
            }
            if (filtered != null) {
                this.setFiltered(filtered.getEtaString());
            }
            if (selected != null) {
                this.setSelected(selected.getEtaString());
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_ETAVISIBLE;
        }
    }

    private final class ConnectionsEntry
    extends DataEntry<AggregatedNumbers> {
        private ConnectionsEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            if (total != null) {
                this.setTotal(Long.toString(total.getConnections()));
            }
            if (filtered != null) {
                this.setFiltered(Long.toString(filtered.getConnections()));
            }
            if (selected != null) {
                this.setSelected(Long.toString(selected.getConnections()));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_CONNECTIONS_VISIBLE;
        }
    }

    private final class FinishedEntry
    extends DataEntry<AggregatedNumbers> {
        private FinishedEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            boolean includeDisabled = DownloadOverview.this.isIncludeDisabled();
            if (total != null) {
                this.setTotal(total.getFinishedString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getFinishedString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getFinishedString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_LINKS_FINISHED_COUNT_VISIBLE;
        }
    }

    private final class SkippedEntry
    extends DataEntry<AggregatedNumbers> {
        private SkippedEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            boolean includeDisabled = DownloadOverview.this.isIncludeDisabled();
            if (total != null) {
                this.setTotal(total.getSkippedString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getSkippedString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getSkippedString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_LINKS_SKIPPED_COUNT_VISIBLE;
        }
    }

    private final class FailedEntry
    extends DataEntry<AggregatedNumbers> {
        private FailedEntry(String label) {
            super(label);
        }

        @Override
        public void setData(AggregatedNumbers total, AggregatedNumbers filtered, AggregatedNumbers selected) {
            boolean includeDisabled = DownloadOverview.this.isIncludeDisabled();
            if (total != null) {
                this.setTotal(total.getFailedString(includeDisabled));
            }
            if (filtered != null) {
                this.setFiltered(filtered.getFailedString(includeDisabled));
            }
            if (selected != null) {
                this.setSelected(selected.getFailedString(includeDisabled));
            }
        }

        @Override
        public BooleanKeyHandler getVisibleKeyHandler() {
            return CFG_GUI.OVERVIEW_PANEL_DOWNLOAD_LINKS_FAILED_COUNT_VISIBLE;
        }
    }
}

