/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.download.HashInfo;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.action.SetDownloadFolderInDownloadTableAction;
import org.jdownloader.gui.views.downloads.properties.AbstractNodeProperties;
import org.jdownloader.settings.GeneralSettings;

public class DownloadLinkNodeProperties
extends AbstractNodeProperties<DownloadLink> {
    private final DownloadLink currentLink;
    private final FilePackage currentPackage;
    private List<Archive> archives = null;

    public DownloadLinkNodeProperties(DownloadLink downloadLink) {
        this.currentLink = downloadLink;
        this.currentPackage = downloadLink.getFilePackage();
    }

    @Override
    protected List<Archive> loadArchives() {
        if (this.archives == null) {
            ArrayList<DownloadLink> children = new ArrayList<DownloadLink>();
            children.add(this.currentLink);
            this.archives = ArchiveValidator.getArchivesFromPackageChildren(children);
        }
        return this.archives;
    }

    @Override
    protected String loadComment() {
        return this.currentLink.getComment();
    }

    protected DownloadLink getDownloadLink() {
        return this.currentLink;
    }

    protected FilePackage getFilePackage() {
        return this.currentPackage;
    }

    @Override
    protected String loadDownloadFrom() {
        String dlLink = this.currentLink.getView().getDisplayUrl();
        if (dlLink == null) {
            return "*******************************";
        }
        return dlLink;
    }

    @Override
    protected String loadDownloadPassword() {
        return this.currentLink.getDownloadPassword();
    }

    @Override
    protected String loadFilename() {
        return this.currentLink.getView().getDisplayName();
    }

    @Override
    protected String loadPackageName() {
        if (this.currentPackage != null) {
            return this.currentPackage.getName();
        }
        return "";
    }

    @Override
    protected void savePackageName(String text) {
        if (this.currentPackage != null) {
            this.currentPackage.setName(text);
        }
    }

    @Override
    protected Priority loadPriority() {
        return this.currentLink.getPriorityEnum();
    }

    @Override
    protected String loadSaveTo() {
        if (this.currentPackage != null) {
            return LinkTreeUtils.getRawDownloadDirectory(this.currentPackage).getAbsolutePath();
        }
        return ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder();
    }

    @Override
    protected void saveComment(String text) {
        this.currentLink.getDownloadLink().setComment(text);
    }

    @Override
    protected void saveDownloadPassword(String text) {
        this.currentLink.getDownloadLink().setDownloadPassword(text);
    }

    @Override
    protected void saveFilename(String name) {
        String curForced = this.currentLink.getForcedFileName();
        if (StringUtils.equals((String)name, (String)curForced)) {
            return;
        }
        String curName = this.currentLink.getName(false, true);
        if (StringUtils.equals((String)name, (String)curName) && curForced == null) {
            return;
        }
        DownloadWatchDog.getInstance().renameLink(this.currentLink, name);
    }

    @Override
    protected void savePriority(Priority priop) {
        this.currentLink.setPriorityEnum(priop);
    }

    @Override
    protected void saveSaveTo(final String stringpath) {
        if (this.currentPackage != null) {
            new SetDownloadFolderInDownloadTableAction(new SelectionInfo(this.currentLink)){
                private static final long serialVersionUID = -3767832209839199384L;

                @Override
                protected File dialog(File path) throws DialogClosedException, DialogCanceledException {
                    return new File(stringpath);
                }
            }.actionPerformed(null);
        }
    }

    @Override
    protected void saveArchivePasswords(List<String> hashSet) {
        List<Archive> archives = this.archives;
        if (archives != null && archives.size() == 1) {
            archives.get(0).getSettings().setPasswords(hashSet);
        }
    }

    @Override
    protected void saveAutoExtract(BooleanStatus selectedItem) {
        List<Archive> archives = this.archives;
        if (archives != null && archives.size() == 1) {
            archives.get(0).getSettings().setAutoExtract(selectedItem);
        }
    }

    @Override
    protected boolean samePackage(AbstractPackageNode pkg) {
        return this.currentPackage == pkg;
    }

    @Override
    protected boolean isDifferent(AbstractNode node) {
        if (node != null && node instanceof AbstractPackageChildrenNode) {
            AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)node;
            return this.currentLink != child || child.getParentNode() != this.currentPackage;
        }
        return true;
    }

    @Override
    protected boolean hasLoadedArchives() {
        return this.archives != null;
    }

    @Override
    protected HashInfo loadHashInfo() {
        return this.currentLink.getHashInfo();
    }

    @Override
    protected void saveHashInfo(HashInfo hashInfo) {
        this.currentLink.setHashInfo(hashInfo);
    }

    @Override
    protected DownloadLink getCurrentNode() {
        return this.currentLink;
    }
}

