/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.utils.ClipboardUtils;
import org.jdownloader.gui.views.components.packagetable.dragdrop.PackageControllerTableTransferable;

public class LinkGrabberTransferable
extends PackageControllerTableTransferable<CrawledPackage, CrawledLink> {
    public LinkGrabberTransferable(PackageControllerTableTransferable<CrawledPackage, CrawledLink> transferable) {
        super(transferable);
        ArrayList<DataFlavor> availableFlavors = new ArrayList<DataFlavor>();
        availableFlavors.add(FLAVOR);
        availableFlavors.add(ClipboardUtils.stringFlavor);
        this.flavors = availableFlavors.toArray(new DataFlavor[0]);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.equals(FLAVOR)) {
            return this.getSelectionInfo();
        }
        if (flavor.equals(ClipboardUtils.stringFlavor)) {
            if (this.stringContent != null) {
                return this.stringContent;
            }
            StringBuilder sb = new StringBuilder();
            Set<String> urls = this.getURLs();
            if (urls != null) {
                Iterator<String> it = urls.iterator();
                while (it.hasNext()) {
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(it.next());
                }
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

