/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jd.controlling.packagecontroller.AbstractNode;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.components.OverviewHeaderScrollPane;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.WidgetContainer;
import org.jdownloader.gui.views.downloads.bottombar.CustomizeableActionBar;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.overview.LinkgrabberOverViewHeader;
import org.jdownloader.gui.views.linkgrabber.overview.LinkgrabberOverview;
import org.jdownloader.gui.views.linkgrabber.properties.LinkgrabberProperties;
import org.jdownloader.gui.views.linkgrabber.properties.LinkgrabberPropertiesHeader;
import org.jdownloader.gui.views.linkgrabber.properties.LinkgrabberPropertiesScrollPane;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class LinkgrabberWidgetContainer
extends WidgetContainer
implements GenericConfigEventListener<Boolean> {
    private boolean propertiesPanelVisible;
    private CustomizeableActionBar rightBar;
    private LinkgrabberPropertiesScrollPane propertiesPanelScrollPane;
    private OverviewHeaderScrollPane overviewScrollPane;

    @Override
    public void refreshAfterTabSwitch() {
        new EDTRunner(){

            protected void runInEDT() {
                if (LinkgrabberWidgetContainer.this.propertiesPanelScrollPane != null) {
                    LinkgrabberWidgetContainer.this.propertiesPanelScrollPane.refreshAfterTabSwitch();
                }
            }
        };
    }

    @Override
    protected void setPropertiesPanelVisible(boolean propertiesPanelVisible) {
        this.propertiesPanelVisible = propertiesPanelVisible;
    }

    public LinkGrabberTable getTable() {
        return (LinkGrabberTable)super.getTable();
    }

    public LinkgrabberWidgetContainer(LinkGrabberTable table, CustomizeableActionBar leftBar, CustomizeableActionBar rightBar) {
        super(table, CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE);
        this.rightBar = rightBar;
        CFG_GUI.LINKGRABBER_TAB_OVERVIEW_VISIBLE.getEventSender().addListener((EventListener)((Object)this));
        CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.getEventSender().addListener((EventListener)((Object)this));
    }

    @Override
    public void relayout() {
        Container p;
        boolean showProperties;
        if (this.propertiesPanelScrollPane != null) {
            this.propertiesPanelScrollPane.save();
        }
        this.removeAll();
        this.setVisible(true);
        AbstractNode selectedObject = this.getTable().getModel().hasSelectedObjects() ? (AbstractNode)this.getTable().getModel().getObjectbyRow(this.getTable().getSelectionModel().getLeadSelectionIndex()) : null;
        boolean bl = showProperties = CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.isEnabled() && this.propertiesPanelVisible && selectedObject != null;
        if (CFG_GUI.LINKGRABBER_TAB_OVERVIEW_VISIBLE.isEnabled()) {
            if (showProperties) {
                this.setLayout((LayoutManager)new MigLayout("ins " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + " 0 0 0, wrap 1", "[grow,fill]", "[]" + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + "[]"));
                this.add(this.wrap(this.createPropertiesPanel()), "");
                this.add(this.wrap(this.getOverView()), "");
                this.createPropertiesPanel().update(selectedObject);
            } else {
                this.setLayout((LayoutManager)new MigLayout("ins " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + " 0 0 0, wrap 1", "[grow,fill]", "[]"));
                this.add(this.wrap(this.getOverView()), "");
            }
        } else if (showProperties) {
            this.setLayout((LayoutManager)new MigLayout("ins 2 0 0 0, wrap 1", "[grow,fill]", "[]"));
            this.add(this.wrap(this.createPropertiesPanel()), "");
            this.createPropertiesPanel().update(selectedObject);
        } else {
            this.setVisible(false);
        }
        if (!showProperties) {
            this.createPropertiesPanel().update((AbstractNode)null);
        }
        if ((p = this.getParent()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LinkgrabberWidgetContainer.this.revalidate();
                    if (Application.getJavaVersion() >= Application.JAVA17) {
                        p.revalidate();
                    } else {
                        p.invalidate();
                        p.validate();
                    }
                    LinkgrabberWidgetContainer.this.doLayout();
                    p.doLayout();
                }
            });
        }
    }

    @Override
    protected LinkgrabberPropertiesScrollPane createPropertiesPanel() {
        if (this.propertiesPanelScrollPane != null) {
            return this.propertiesPanelScrollPane;
        }
        final LinkgrabberProperties loverView = new LinkgrabberProperties(this.getTable());
        LinkgrabberPropertiesScrollPane propertiesScrollPane = new LinkgrabberPropertiesScrollPane(loverView, this.getTable()){

            @Override
            public void setVisible(boolean aFlag) {
                if (!aFlag) {
                    loverView.save();
                }
                super.setVisible(aFlag);
            }
        };
        propertiesScrollPane.setColumnHeaderView(new LinkgrabberPropertiesHeader(loverView){

            @Override
            protected void onCloseAction() {
                CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.setValue((Object)false);
                CustomizeableActionBar iconComp = LinkgrabberWidgetContainer.this.rightBar;
                Point loc = iconComp.getLocationOnScreen();
                if (CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
                    HelpDialog.show(false, false, new Point(loc.x + iconComp.getWidth() - iconComp.getHeight() / 2, loc.y + iconComp.getHeight() / 2), "propertiesclosed", 32, _GUI.T.DownloadsPanel_onCloseAction(), _GUI.T.Linkgrabber_properties_onCloseAction_help(), new AbstractIcon("bottombar", 32));
                }
            }
        });
        LAFOptions.getInstance().applyPanelBackground((JComponent)propertiesScrollPane);
        this.propertiesPanelScrollPane = propertiesScrollPane;
        return propertiesScrollPane;
    }

    private OverviewHeaderScrollPane getOverView() {
        if (this.overviewScrollPane != null) {
            return this.overviewScrollPane;
        }
        LinkgrabberOverview overview = new LinkgrabberOverview(this.getTable());
        final OverviewHeaderScrollPane ret = new OverviewHeaderScrollPane((JComponent)((Object)overview));
        LAFOptions.getInstance().applyPanelBackground((JComponent)ret);
        ret.setColumnHeaderView((Component)((Object)new LinkgrabberOverViewHeader(overview){

            @Override
            protected void onCloseAction() {
                if (LinkgrabberWidgetContainer.this.overviewScrollPane == ret) {
                    LinkgrabberWidgetContainer.this.overviewScrollPane = null;
                }
                CFG_GUI.LINKGRABBER_TAB_OVERVIEW_VISIBLE.setValue((Object)false);
                CustomizeableActionBar iconComp = LinkgrabberWidgetContainer.this.rightBar;
                Point loc = LinkgrabberWidgetContainer.this.rightBar.getLocationOnScreen();
                if (CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
                    HelpDialog.show(false, false, new Point(loc.x + iconComp.getWidth() - iconComp.getHeight() / 2, loc.y + iconComp.getHeight() / 2), "overviewclosed", 32, _GUI.T.DownloadsPanel_onCloseAction(), _GUI.T.DownloadsPanel_onCloseAction_help(), new AbstractIcon("bottombar", 32));
                }
            }
        }));
        this.overviewScrollPane = ret;
        return this.overviewScrollPane;
    }

    public void save() {
        new EDTRunner(){

            protected void runInEDT() {
                if (LinkgrabberWidgetContainer.this.propertiesPanelScrollPane != null) {
                    LinkgrabberWidgetContainer.this.propertiesPanelScrollPane.save();
                }
            }
        };
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(final KeyHandler<Boolean> keyHandler, final Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                if (Boolean.TRUE.equals(newValue) && keyHandler == CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE) {
                    LinkgrabberWidgetContainer.this.setPropertiesPanelVisible(true);
                }
                LinkgrabberWidgetContainer.this.relayout();
            }
        };
    }
}

