/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.addlinksdialog;

import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import jd.controlling.ClipboardMonitoring;
import jd.parser.html.HTMLParser;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ReflectionUtils;
import org.jdownloader.logging.LogController;

public class DragAndDropDelegater
extends TransferHandler {
    private final TransferHandler org;
    private static boolean REFLECTION = true;

    public DragAndDropDelegater(JComponent input) {
        this.org = input.getTransferHandler();
    }

    @Override
    public void setDragImage(Image img) {
        this.org.setDragImage(img);
    }

    @Override
    public Image getDragImage() {
        return this.org.getDragImage();
    }

    @Override
    public void setDragImageOffset(Point p) {
        this.org.setDragImageOffset(p);
    }

    @Override
    public Point getDragImageOffset() {
        return this.org.getDragImageOffset();
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        this.org.exportAsDrag(comp, e, action);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        this.org.exportToClipboard(comp, clip, action);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            String[] links;
            ClipboardMonitoring.HTMLFragment htmlFragment = ClipboardMonitoring.getHTMLFragment(support.getTransferable(), support.getDataFlavors());
            if (htmlFragment != null && (links = HTMLParser.getHttpLinks(htmlFragment.getFragment(), htmlFragment.getSourceURL())) != null && links.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (String link : links) {
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(link);
                }
                TransferHandler.TransferSupport ret = new TransferHandler.TransferSupport(support.getComponent(), new StringSelection(sb.toString()));
                return this.org.importData(ret);
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.org.importData(support);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return this.org.importData(comp, t);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return this.org.canImport(support);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return this.org.canImport(comp, transferFlavors);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.org.getSourceActions(c);
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        return this.org.getVisualRepresentation(t);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        block3: {
            try {
                if (REFLECTION) {
                    return (Transferable)ReflectionUtils.invoke(TransferHandler.class, (String)"createTransferable", (Object)this.org, Transferable.class, (Object[])new Object[]{c});
                }
            }
            catch (Throwable e) {
                REFLECTION = false;
                if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) break block3;
                LogController.CL().log(e);
            }
        }
        Clipboard clip = new Clipboard("dummyClipboard");
        this.org.exportToClipboard(c, clip, 1);
        return clip.getContents(null);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        block3: {
            try {
                if (REFLECTION) {
                    ReflectionUtils.invoke(TransferHandler.class, (String)"exportDone", (Object)this.org, Void.TYPE, (Object[])new Object[]{source, data, action});
                }
            }
            catch (Throwable e) {
                REFLECTION = false;
                if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) break block3;
                LogController.CL().log(e);
            }
        }
    }
}

