/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.bottombar;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.bottombar.SelfComponentFactoryInterface;
import org.jdownloader.gui.views.downloads.bottombar.SelfLayoutInterface;
import org.jdownloader.translate._JDT;

public class AddFilteredStuffAction
extends CustomizableAppAction
implements ActionContext,
SelfComponentFactoryInterface,
SelfLayoutInterface {
    private boolean onlyVisibleIfThereIsFilteredStuff = true;

    public AddFilteredStuffAction() {
        this.setIconKey("filter");
    }

    public static String getTranslationForOnlyVisibleIfThereIsFilteredStuff() {
        return _JDT.T.AddFilteredStuffAction_getTranslationForOnlyVisibleIfThereIsFilteredStuff();
    }

    @Customizer(link="#getTranslationForOnlyVisibleIfThereIsFilteredStuff")
    public boolean isOnlyVisibleIfThereIsFilteredStuff() {
        return this.onlyVisibleIfThereIsFilteredStuff;
    }

    public void setOnlyVisibleIfThereIsFilteredStuff(boolean onlyVisibleIfThereIsFilteredStuff) {
        this.onlyVisibleIfThereIsFilteredStuff = onlyVisibleIfThereIsFilteredStuff;
    }

    public void actionPerformed(ActionEvent e) {
        LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                List<CrawledLink> filteredStuff = LinkCollector.getInstance().getFilteredStuff(true);
                HashMap<LinkCollectingJob, ArrayList<CrawledLink>> jobs = new HashMap<LinkCollectingJob, ArrayList<CrawledLink>>();
                if (filteredStuff != null && filteredStuff.size() > 0) {
                    for (CrawledLink crawledLink : filteredStuff) {
                        LinkCollectingJob job = crawledLink.getSourceJob();
                        ArrayList<CrawledLink> list = (ArrayList<CrawledLink>)jobs.get(job);
                        if (list == null) {
                            list = new ArrayList<CrawledLink>();
                            jobs.put(job, list);
                        }
                        list.add(crawledLink);
                    }
                    for (Map.Entry entry : jobs.entrySet()) {
                        LinkCollector.getInstance().addCrawlerJob((List)entry.getValue(), (LinkCollectingJob)entry.getKey());
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String createConstraints() {
        return "height 24!,aligny top,hidemode 3";
    }

    @Override
    public JComponent createComponent() {
        Button ret = new Button(this);
        ret.setEnabled(true);
        return ret;
    }

    public class Button
    extends ExtButton
    implements LinkCollectorListener {
        public Button(AddFilteredStuffAction addFilteredStuffAction) {
            super((AbstractAction)((Object)addFilteredStuffAction));
            LinkCollector.getInstance().getEventsender().addListener(this, true);
            this.setFilteredAvailable(LinkCollector.getInstance().getfilteredStuffSize());
        }

        private void setFilteredAvailable(final int size) {
            if (size > 0) {
                new EDTRunner(){

                    protected void runInEDT() {
                        Button.this.setText(_GUI.T.RestoreFilteredLinksAction_(size));
                        Button.this.setVisible(true);
                    }
                };
            } else {
                new EDTRunner(){

                    protected void runInEDT() {
                        Button.this.setText(_GUI.T.RestoreFilteredLinksAction_(0));
                        Button.this.setVisible(!AddFilteredStuffAction.this.isOnlyVisibleIfThereIsFilteredStuff());
                    }
                };
            }
        }

        @Override
        public void onLinkCollectorAbort(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
            this.setFilteredAvailable(LinkCollector.getInstance().getfilteredStuffSize());
        }

        @Override
        public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
            this.setFilteredAvailable(0);
        }

        @Override
        public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
        }

        @Override
        public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
        }

        @Override
        public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
        }

        @Override
        public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
        }

        @Override
        public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
        }

        @Override
        public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
        }

        @Override
        public void onLinkCrawlerNewJob(LinkCollectingJob job) {
        }

        @Override
        public void onLinkCrawlerFinished() {
        }
    }
}

