/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.bottombar;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.KeyStroke;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.plugins.DownloadLink;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.action.ByPassDialogSetup;
import org.jdownloader.gui.views.downloads.action.Modifier;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.bottombar.IncludedSelectionSetup;
import org.jdownloader.translate._JDT;

public class GenericDeleteFromLinkgrabberAction
extends CustomizableAppAction
implements ExtTableListener,
ActionContext,
ExtTableModelListener {
    public static final String CLEAR_FILTERED_LINKS = "clearFilteredLinks";
    public static final String CLEAR_SEARCH_FILTER = "clearSearchFilter";
    public static final String RESET_TABLE_SORTER = "resetTableSorter";
    public static final String CANCEL_LINKCRAWLER_JOBS = "cancelLinkcrawlerJobs";
    public static final String DELETE_ALL = "deleteAll";
    public static final String DELETE_DISABLED = "deleteDisabled";
    public static final String DELETE_OFFLINE = "deleteOffline";
    public static final String DELETE_DUPES = "deleteDupes";
    private static final long serialVersionUID = 1L;
    private final DelayedRunnable delayer;
    private boolean deleteAll = false;
    private boolean deleteDisabled = false;
    private boolean deleteOffline = false;
    private boolean cancelLinkcrawlerJobs = false;
    private boolean resetTableSorter = false;
    private boolean deleteDupes;
    private boolean clearSearchFilter = false;
    private boolean clearFilteredLinks = false;
    private boolean ignoreFiltered = true;
    protected volatile WeakReference<CrawledLink> lastLink = new WeakReference<Object>(null);
    private final ByPassDialogSetup byPassDialog;
    protected IncludedSelectionSetup includedSelection;
    protected volatile WeakReference<PackageControllerTable.SelectionInfoCallback> lastCallBack = new WeakReference<Object>(null);

    @Override
    public void loadContextSetups() {
        super.loadContextSetups();
        new EDTRunner(){

            protected void runInEDT() {
                GenericDeleteFromLinkgrabberAction.this.setName(GenericDeleteFromLinkgrabberAction.this.createName());
            }
        }.getReturnValue();
    }

    public static String getTranslationForCancelLinkcrawlerJobs() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForCancelLinkcrawlerJobs();
    }

    @Customizer(link="#getTranslationForCancelLinkcrawlerJobs")
    public boolean isCancelLinkcrawlerJobs() {
        return this.cancelLinkcrawlerJobs;
    }

    public void setCancelLinkcrawlerJobs(boolean cancelLinkcrawlerJobs) {
        this.cancelLinkcrawlerJobs = cancelLinkcrawlerJobs;
    }

    public static String getTranslationForDeleteDupesEnabled() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForDeleteDupesEnabled();
    }

    @Customizer(link="#getTranslationForDeleteDupesEnabled")
    public boolean isdeleteDupes() {
        return this.deleteDupes;
    }

    public void setdeleteDupes(boolean deleteDupes) {
        this.deleteDupes = deleteDupes;
    }

    public static String getTranslationForResetTableSorter() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForResetTableSorter();
    }

    @Customizer(link="#getTranslationForResetTableSorter")
    public boolean isResetTableSorter() {
        return this.resetTableSorter;
    }

    public void setResetTableSorter(boolean resetTableSorter) {
        this.resetTableSorter = resetTableSorter;
    }

    public static String getTranslationForClearSearchFilter() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForClearSearchFilter();
    }

    @Customizer(link="#getTranslationForClearSearchFilter")
    public boolean isClearSearchFilter() {
        return this.clearSearchFilter;
    }

    public void setClearSearchFilter(boolean clearSearchFilter) {
        this.clearSearchFilter = clearSearchFilter;
    }

    public static String getTranslationForClearFilteredLinks() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForClearFilteredLinks();
    }

    @Customizer(link="#getTranslationForClearFilteredLinks")
    public boolean isClearFilteredLinks() {
        return this.clearFilteredLinks;
    }

    public void setClearFilteredLinks(boolean clearFilteredLinks) {
        this.clearFilteredLinks = clearFilteredLinks;
    }

    public GenericDeleteFromLinkgrabberAction() {
        this.byPassDialog = new ByPassDialogSetup();
        this.addContextSetup(this.byPassDialog);
        this.delayer = new DelayedRunnable(TaskQueue.TIMINGQUEUE, 500L, 1500L){

            public void delayedrun() {
                GenericDeleteFromLinkgrabberAction.this.update();
            }
        };
        this.initIncludeSelectionSupport();
        this.setIconKey("delete");
    }

    protected void initIncludeSelectionSupport() {
        this.includedSelection = new IncludedSelectionSetup(LinkGrabberTable.getInstance(), this, this){

            @Override
            public PackageControllerTable.SelectionType getSelectionType() {
                PackageControllerTable.SelectionType ret = super.getSelectionType();
                if (PackageControllerTable.SelectionType.ALL.equals((Object)ret) && !GenericDeleteFromLinkgrabberAction.this.isIgnoreFiltered()) {
                    return PackageControllerTable.SelectionType.BACKEND;
                }
                return ret;
            }
        };
        this.addContextSetup(this.includedSelection);
    }

    public void actionPerformed(ActionEvent e) {
        final PackageControllerTable.SelectionType selectionType = this.includedSelection.getSelectionType();
        LinkGrabberTable table = LinkGrabberTable.getInstance();
        table.getSelectionInfo(new PackageControllerTable.QueueSelectionInfoCallback<CrawledPackage, CrawledLink>(){

            @Override
            public void onSelectionInfo(SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
                ArrayList<CrawledLink> nodesToDelete = new ArrayList<CrawledLink>();
                AtomicBoolean containsOnline = new AtomicBoolean(false);
                switch (selectionType) {
                    case NONE: {
                        return;
                    }
                    case UNSELECTED: {
                        for (CrawledLink child : selectionInfo.getUnselectedChildren()) {
                            CrawledPackage parentNode = child.getParentNode();
                            if (parentNode == null || !GenericDeleteFromLinkgrabberAction.this.checkLink(child)) continue;
                            if (child.getDownloadLink().getAvailableStatus() != DownloadLink.AvailableStatus.FALSE) {
                                containsOnline.set(true);
                            }
                            nodesToDelete.add(child);
                        }
                        break;
                    }
                    default: {
                        for (CrawledLink dl : selectionInfo.getChildren()) {
                            CrawledPackage parentNode = dl.getParentNode();
                            if (parentNode == null || !GenericDeleteFromLinkgrabberAction.this.checkLink(dl)) continue;
                            nodesToDelete.add(dl);
                            if (CrawledPackage.TYPE.OFFLINE == parentNode.getType() || CrawledPackage.TYPE.POFFLINE == parentNode.getType() || dl.getDownloadLink().getAvailableStatus() == DownloadLink.AvailableStatus.FALSE) continue;
                            containsOnline.set(true);
                        }
                    }
                }
                GenericDeleteFromLinkgrabberAction.this.finalDelete(nodesToDelete, containsOnline.get());
            }

            @Override
            public Queue getQueue() {
                return TaskQueue.getQueue();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        }, selectionType);
    }

    protected void finalDelete(List<CrawledLink> nodesToDelete, boolean containsOnline) {
        LinkCollector.requestDeleteLinks(nodesToDelete, containsOnline, this.getLabelForAreYouSureDialog(), this.byPassDialog.isBypassDialog(), this.isCancelLinkcrawlerJobs(), this.isResetTableSorter(), this.isClearSearchFilter(), this.isClearFilteredLinks());
    }

    protected String getLabelForAreYouSureDialog() {
        return this.createName();
    }

    @Override
    public List<KeyStroke> getAdditionalShortcuts(KeyStroke keystroke) {
        if (keystroke == null) {
            return null;
        }
        ArrayList<KeyStroke> ret = new ArrayList<KeyStroke>();
        Modifier mod = this.byPassDialog.getByPassDialogToggleModifier();
        if (mod != null) {
            ret.add(KeyStroke.getKeyStroke(keystroke.getKeyCode(), keystroke.getModifiers() | mod.getModifier()));
        }
        return ret;
    }

    public boolean checkLink(CrawledLink cl) {
        if (this.isDeleteAll()) {
            return true;
        }
        if (this.isdeleteDupes() && DownloadController.getInstance().hasDownloadLinkByID(cl.getLinkID())) {
            return true;
        }
        if (this.isDeleteDisabled() && !cl.isEnabled()) {
            return true;
        }
        return this.isDeleteOffline() && cl.getDownloadLink().isAvailabilityStatusChecked() && cl.getDownloadLink().getAvailableStatus() == DownloadLink.AvailableStatus.FALSE;
    }

    protected String createName() {
        StringBuilder sb = new StringBuilder();
        if (this.isClearFilteredLinks()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(_GUI.T.GenericDeleteFromLinkgrabberAction_clearFiltered());
        }
        if (this.isCancelLinkcrawlerJobs()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(_GUI.T.GenericDeleteFromLinkgrabberAction_cancelCrawler());
        }
        if (this.isClearSearchFilter()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(_GUI.T.GenericDeleteFromLinkgrabberAction_clearSearch());
        }
        if (this.isResetTableSorter()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(_GUI.T.GenericDeleteFromLinkgrabberAction_resetSorter());
        }
        if (sb.length() > 0) {
            sb.append(" & ");
        }
        if (this.isDeleteAll()) {
            switch (this.includedSelection.getSelectionType()) {
                case ALL: 
                case BACKEND: {
                    sb.append(_GUI.T.GenericDeleteFromLinkgrabberAction_createName_updateName_object_all());
                    break;
                }
                case SELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected_all());
                    break;
                }
                case UNSELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_keep_selected_all());
                    break;
                }
                case NONE: {
                    sb.append("Bad Action Setup");
                }
            }
        } else {
            switch (this.includedSelection.getSelectionType()) {
                case ALL: 
                case BACKEND: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object());
                    break;
                }
                case SELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected());
                    break;
                }
                case UNSELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_keep_selected_selected());
                    break;
                }
                case NONE: {
                    sb.append("Bad Action Setup");
                }
            }
            boolean first = true;
            if (this.isdeleteDupes()) {
                if (!first) {
                    sb.append(" & ");
                }
                sb.append(_GUI.T.lit_duplicates_links());
                first = false;
            }
            if (this.isDeleteDisabled()) {
                if (!first) {
                    sb.append(" & ");
                }
                sb.append(_GUI.T.lit_disabled());
                first = false;
            }
            if (this.isDeleteOffline()) {
                if (!first) {
                    sb.append(" & ");
                }
                first = false;
                sb.append(_GUI.T.lit_offline());
            }
        }
        return sb.toString();
    }

    public static String getTranslationForDeleteAll() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForDeleteAll();
    }

    @Customizer(link="#getTranslationForDeleteAll")
    public boolean isDeleteAll() {
        return this.deleteAll;
    }

    public static String getTranslationForDeleteDisabled() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForDeleteDisabled();
    }

    @Customizer(link="#getTranslationForDeleteDisabled")
    public boolean isDeleteDisabled() {
        return this.deleteDisabled;
    }

    public static String getTranslationForDeleteOffline() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForDeleteOffline();
    }

    @Customizer(link="#getTranslationForDeleteOffline")
    public boolean isDeleteOffline() {
        return this.deleteOffline;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public static String getTranslationForIgnoreFiltered() {
        return _JDT.T.GenericDeleteFromLinkgrabberAction_getTranslationForIgnoreFiltered();
    }

    @Customizer(link="#getTranslationForIgnoreFiltered")
    public boolean isIgnoreFiltered() {
        return this.ignoreFiltered;
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
        if (event.getType() == ExtTableEvent.Types.SELECTION_CHANGED) {
            this.update();
        }
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.update();
    }

    public void setDeleteAll(boolean deleteIdle) {
        this.deleteAll = deleteIdle;
    }

    public void setDeleteDisabled(boolean deleteDisabled) {
        this.deleteDisabled = deleteDisabled;
    }

    public void setDeleteOffline(boolean deleteOffline) {
        this.deleteOffline = deleteOffline;
    }

    public void setIgnoreFiltered(boolean ignoreFiltered) {
        this.ignoreFiltered = ignoreFiltered;
    }

    protected void update() {
        if (this.lastLink != null) {
            final PackageControllerTable.SelectionType selectionType = this.includedSelection.getSelectionType();
            LinkGrabberTable table = LinkGrabberTable.getInstance();
            table.getSelectionInfo(new PackageControllerTable.EDTSelectionInfoCallback<CrawledPackage, CrawledLink>(){
                {
                    GenericDeleteFromLinkgrabberAction.this.lastCallBack = new WeakReference<5>(this);
                }

                @Override
                public boolean isCancelled() {
                    WeakReference<PackageControllerTable.SelectionInfoCallback> lastCallBack = GenericDeleteFromLinkgrabberAction.this.lastCallBack;
                    return lastCallBack.get() != this;
                }

                @Override
                public void onSelectionInfo(SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
                    GenericDeleteFromLinkgrabberAction.this.onUpdate(selectionType, selectionInfo);
                }
            }, selectionType);
        }
    }

    protected void onUpdate(PackageControllerTable.SelectionType selectionType, SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
        switch (selectionType) {
            case UNSELECTED: {
                CrawledLink lastCrawledLink = (CrawledLink)this.lastLink.get();
                if (lastCrawledLink != null && !selectionInfo.contains(lastCrawledLink) && this.checkLink(lastCrawledLink)) {
                    this.setEnabled(true);
                    return;
                }
                if (selectionInfo.getUnselectedChildren() != null) {
                    for (CrawledLink child : selectionInfo.getUnselectedChildren()) {
                        if (!this.checkLink(child)) continue;
                        this.setEnabled(true);
                        this.lastLink = new WeakReference<CrawledLink>(child);
                        return;
                    }
                }
                this.setEnabled(false);
                return;
            }
        }
        if (this.isCancelLinkcrawlerJobs()) {
            this.setEnabled(true);
        } else if (this.isClearFilteredLinks()) {
            this.setEnabled(true);
        } else if (this.isClearSearchFilter()) {
            this.setEnabled(true);
        } else if (this.isResetTableSorter()) {
            this.setEnabled(true);
        } else if (this.isClearSearchFilter()) {
            this.setEnabled(true);
        } else {
            CrawledLink lastCrawledLink = (CrawledLink)this.lastLink.get();
            if (lastCrawledLink != null && !selectionInfo.contains(lastCrawledLink) && this.checkLink(lastCrawledLink)) {
                this.setEnabled(true);
                return;
            }
            for (CrawledLink child : selectionInfo.getChildren()) {
                if (!this.checkLink(child)) continue;
                this.setEnabled(true);
                this.lastLink = new WeakReference<CrawledLink>(child);
                return;
            }
            this.setEnabled(false);
        }
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper listener) {
        this.delayer.resetAndStart();
    }
}

