/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.columns;

import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.LinkInfo;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.jdownloader.gui.translate._GUI;

public class PartColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;

    public PartColumn() {
        super(_GUI.T.LinkGrabberTableModel_partcolumn());
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                int l2;
                LinkInfo p1 = PartColumn.this.getLinkInfo(o1);
                LinkInfo p2 = PartColumn.this.getLinkInfo(o2);
                int l1 = p1 == null ? -1 : p1.getPartNum();
                int n = l2 = p2 == null ? -1 : p2.getPartNum();
                if (l1 == l2) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return l1 > l2 ? -1 : 1;
                }
                return l1 < l2 ? -1 : 1;
            }
        });
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public int getDefaultWidth() {
        return 75;
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public boolean isHidable() {
        return true;
    }

    public String getStringValue(AbstractNode value) {
        int num;
        LinkInfo linkInfo = this.getLinkInfo(value);
        if (linkInfo != null && (num = linkInfo.getPartNum()) >= 0) {
            return String.valueOf(num);
        }
        return null;
    }

    public LinkInfo getLinkInfo(AbstractNode value) {
        if (value instanceof CrawledLink) {
            return ((CrawledLink)value).getLinkInfo();
        }
        if (value instanceof DownloadLink) {
            return ((DownloadLink)value).getLinkInfo();
        }
        return null;
    }
}

