/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.swing.MigPanel;
import org.appwork.uio.ComboBoxDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ComboBoxDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.extensions.extraction.gui.DummyArchiveDialog;
import org.jdownloader.gui.KeyObserver;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkgrabberSearchField;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.translate._JDT;

public class ConfirmLinksContextAction
extends CustomizableTableContextAppAction<CrawledPackage, CrawledLink>
implements GUIListener,
ActionContext {
    public static final String SELECTION_ONLY = "selectionOnly";
    private boolean ctrlToggle = true;
    private boolean forceDownloads = false;
    private Priority piority = Priority.DEFAULT;
    private boolean assignPriorityEnabled = false;
    private PackageExpandBehavior packageExpandBehavior = PackageExpandBehavior.UNCHANGED;
    private OnOfflineLinksAction handleOffline = OnOfflineLinksAction.GLOBAL;
    private OnDupesLinksAction handleDupes = OnDupesLinksAction.GLOBAL;
    private AutoStartOptions autoStart = AutoStartOptions.AUTO;
    private boolean clearListAfterConfirm = false;
    private boolean metaCtrl = false;
    private ConfirmationDialogBehavior confirmationDialogBehavior = ConfirmationDialogBehavior.DISABLED;
    private int minNumberofPackagesForConfirmMoveToDownloadlistDialog = 1;
    private int minNumberofLinksForConfirmMoveToDownloadlistDialog = 1;
    public static final String FORCE_START = "forceDownloads";
    public static final String AUTO_START = "autoStart";
    private static final long serialVersionUID = -3937346180905569896L;
    private boolean selectionOnly = true;

    public static String getTranslationForCtrlToggle() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForCtrlToggle();
    }

    @Customizer(link="#getTranslationForCtrlToggle")
    @Order(value=301)
    public boolean isCtrlToggle() {
        return this.ctrlToggle;
    }

    public void setCtrlToggle(boolean ctrlToggle) {
        this.ctrlToggle = ctrlToggle;
    }

    public static String getTranslationForForceDownloads() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForForceDownloads();
    }

    @Customizer(link="#getTranslationForForceDownloads")
    public boolean isForceDownloads() {
        return this.forceDownloads;
    }

    public void setForceDownloads(boolean forceDownloads) {
        this.forceDownloads = forceDownloads;
    }

    public static String getTranslationForAssignPriorityEnabled() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForAssignPriorityEnabled();
    }

    @Customizer(link="#getTranslationForAssignPriorityEnabled")
    @Order(value=20)
    public boolean isAssignPriorityEnabled() {
        return this.assignPriorityEnabled;
    }

    public void setAssignPriorityEnabled(boolean assignPriorityEnabled) {
        this.assignPriorityEnabled = assignPriorityEnabled;
    }

    public static String getTranslationForPriority() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForPriority();
    }

    @Customizer(link="#getTranslationForPriority")
    @Order(value=21)
    public Priority getPriority() {
        return this.piority;
    }

    public void setPriority(Priority priority) {
        this.piority = priority;
    }

    public static String getTranslationForPackageExpandBehavior() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForPackageExpandBehavior();
    }

    @Customizer(link="#getTranslationForPackageExpandBehavior")
    @Order(value=30)
    public PackageExpandBehavior getPackageExpandBehavior() {
        return this.packageExpandBehavior;
    }

    public void setPackageExpandBehavior(PackageExpandBehavior packageExpandBehavior) {
        this.packageExpandBehavior = packageExpandBehavior;
    }

    public static String getTranslationForConfirmationDialogBehavior() {
        return "Add links conformation dialog behavior";
    }

    @Customizer(link="#getTranslationForConfirmationDialogBehavior")
    @Order(value=40)
    @SpinnerValidator(min=1L, max=0x7FFFFFFFL, step=1L)
    public ConfirmationDialogBehavior getConfirmationDialogBehavior() {
        return this.confirmationDialogBehavior;
    }

    public void setConfirmationDialogBehavior(ConfirmationDialogBehavior behavior) {
        this.confirmationDialogBehavior = behavior;
    }

    public static String getTranslationForMinNumberofPackagesForMoveToDownloadlistConfirmDialog() {
        return "Min number of packages for confirm dialog";
    }

    @Customizer(link="#getTranslationForMinNumberofPackagesForMoveToDownloadlistConfirmDialog")
    @Order(value=41)
    @SpinnerValidator(min=1L, max=0x7FFFFFFFL, step=1L)
    public int getMinNumberofPackagesForMoveToDownloadlistConfirmDialog() {
        return this.minNumberofPackagesForConfirmMoveToDownloadlistDialog;
    }

    public void setMinNumberofPackagesForMoveToDownloadlistConfirmDialog(int num) {
        this.minNumberofPackagesForConfirmMoveToDownloadlistDialog = num;
    }

    public static String getTranslationForMinNumberofLinksForMoveToDownloadlistConfirmDialog() {
        return "Min number of links for confirm dialog";
    }

    @Customizer(link="#getTranslationForMinNumberofLinksForMoveToDownloadlistConfirmDialog")
    @Order(value=42)
    public int getMinNumberofLinksForMoveToDownloadlistConfirmDialog() {
        return this.minNumberofLinksForConfirmMoveToDownloadlistDialog;
    }

    public void setMinNumberofLinksForMoveToDownloadlistConfirmDialog(int num) {
        this.minNumberofLinksForConfirmMoveToDownloadlistDialog = num;
    }

    public static void confirmSelection(final SelectionInfo<CrawledPackage, CrawledLink> selection, final LinkCollector.ConfirmLinksSettings settings) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                OnOfflineLinksAction handleOfflineLoc = settings.getHandleOffline();
                OnDupesLinksAction handleDupesLoc = settings.getHandleDupes();
                boolean alreadyDisplayedOtherDialogToUser = false;
                HashSet<Object> toDelete = new HashSet<Object>();
                HashSet<Object> toKeepInLinkgrabber = new HashSet<Object>();
                ExtractionExtension extractionExtension = ExtractionExtension.getInstance();
                GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction doAction = CFG_GUI.CFG.getConfirmIncompleteArchiveAction();
                if (extractionExtension != null && !GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction.MOVE_TO_DOWNLOADLIST.equals((Object)doAction)) {
                    try {
                        ArchiveValidator.ArchiveValidation result = ArchiveValidator.validate((SelectionInfo)selection, (boolean)false);
                        block20: for (Archive a : result.getArchives()) {
                            GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction doActionForTheCurrentArchive = doAction;
                            final DummyArchive da = extractionExtension.createDummyArchive(a);
                            if (da.isComplete()) continue;
                            if (doAction == GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction.ASK) {
                                GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction[] options = new GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction[]{GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction.DELETE, GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction.KEEP_IN_LINKGRABBER, GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction.MOVE_TO_DOWNLOADLIST};
                                int def = 0;
                                GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction s = CFG_LINKGRABBER.CFG.getHandleIncompleteArchiveOnConfirmLatestSelection();
                                for (int i = 0; i < options.length; ++i) {
                                    if (s != options[i]) continue;
                                    def = i;
                                    break;
                                }
                                ComboBoxDialog guiDialog = new ComboBoxDialog(32, _GUI.T.ConfirmAction_run_incomplete_archive_title_(a.getName()), _GUI.T.ConfirmAction_run_incomplete_archive_msg(), (Object[])options, def, new AbstractIcon("stop", 32), _GUI.T.lit_continue(), null, null){

                                    public String getDontShowAgainKey() {
                                        return null;
                                    }

                                    protected MigPanel createBottomPanel() {
                                        return new MigPanel("ins 0", "[]20[grow,fill][]", "[]");
                                    }

                                    protected DefaultButtonPanel createBottomButtonPanel() {
                                        DefaultButtonPanel ret = new DefaultButtonPanel("ins 0", "[][][]", "0[]0");
                                        ret.add((Component)new JButton((Action)((Object)new AppAction(){
                                            {
                                                this.setName(_GUI.T.ConfirmAction_run_incomplete_archive_details());
                                            }

                                            public void actionPerformed(ActionEvent e) {
                                                try {
                                                    Dialog.getInstance().showDialog((AbstractDialog)new DummyArchiveDialog(da));
                                                }
                                                catch (DialogClosedException e1) {
                                                    e1.printStackTrace();
                                                }
                                                catch (DialogCanceledException e1) {
                                                    e1.printStackTrace();
                                                }
                                            }
                                        })), (Object)"");
                                        return ret;
                                    }

                                    protected String getDontShowAgainLabelText() {
                                        return _GUI.T.ConfirmLinksContextAction_getDontShowAgainLabelText_object_();
                                    }

                                    protected ListCellRenderer getRenderer(final ListCellRenderer orgRenderer) {
                                        return new ListCellRenderer(){

                                            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                                if (value == null) {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.AddActionAction_getListCellRendererComponent_no_action_(), index, isSelected, cellHasFocus);
                                                }
                                                switch ((GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction)((Object)value)) {
                                                    // Empty switch
                                                }
                                                JLabel ret = (JLabel)orgRenderer.getListCellRendererComponent(list, ((GraphicalUserInterfaceSettings.ConfirmIncompleteArchiveAction)((Object)value)).getLabel(), index, isSelected, cellHasFocus);
                                                return ret;
                                            }
                                        };
                                    }
                                };
                                ComboBoxDialogInterface response = (ComboBoxDialogInterface)UIOManager.I().show(ComboBoxDialogInterface.class, (UserIODefinition)guiDialog);
                                response.throwCloseExceptions();
                                doActionForTheCurrentArchive = options[response.getSelectedIndex()];
                                CFG_LINKGRABBER.CFG.setHandleIncompleteArchiveOnConfirmLatestSelection(doActionForTheCurrentArchive);
                                if (response.isDontShowAgainSelected()) {
                                    doAction = doActionForTheCurrentArchive;
                                }
                                alreadyDisplayedOtherDialogToUser = true;
                            }
                            switch (doActionForTheCurrentArchive) {
                                case DELETE: {
                                    for (ArchiveFile af : a.getArchiveFiles()) {
                                        if (!(af instanceof CrawledLinkArchiveFile)) continue;
                                        toDelete.addAll(((CrawledLinkArchiveFile)af).getLinks());
                                    }
                                    continue block20;
                                }
                                case KEEP_IN_LINKGRABBER: {
                                    for (ArchiveFile af : a.getArchiveFiles()) {
                                        if (!(af instanceof CrawledLinkArchiveFile)) continue;
                                        toKeepInLinkgrabber.addAll(((CrawledLinkArchiveFile)af).getLinks());
                                    }
                                    continue block20;
                                }
                                case MOVE_TO_DOWNLOADLIST: {
                                    break;
                                }
                            }
                        }
                    }
                    catch (DialogNoAnswerException e) {
                        return;
                    }
                    catch (Throwable ignore) {
                        LoggerFactory.getDefaultLogger().log(ignore);
                    }
                }
                if (handleOfflineLoc != OnOfflineLinksAction.INCLUDE_OFFLINE) {
                    ArrayList<Object> offline = new ArrayList<Object>();
                    for (Object cl : selection.getChildren()) {
                        if (toKeepInLinkgrabber.contains(cl) || toDelete.contains(cl) || !((CrawledLink)cl).getDownloadLink().isAvailabilityStatusChecked() || ((CrawledLink)cl).getDownloadLink().isAvailable()) continue;
                        offline.add(cl);
                        if (handleOfflineLoc == OnOfflineLinksAction.ASK) {
                            OnOfflineLinksAction[] options = new OnOfflineLinksAction[]{OnOfflineLinksAction.INCLUDE_OFFLINE, OnOfflineLinksAction.EXCLUDE_OFFLINE, OnOfflineLinksAction.EXCLUDE_OFFLINE_AND_REMOVE};
                            ComboBoxDialog combo = new ComboBoxDialog(0, _GUI.T.ConfirmLinksContextAction_run_offline_ask_title(), _GUI.T.ConfirmLinksContextAction_run_offline_ask_question(), (Object[])options, 1, null, null, null, null){

                                protected JComboBox getComboBox(Object[] options2) {
                                    OnOfflineLinksAction s = CFG_LINKGRABBER.CFG.getHandleOfflineOnConfirmLatestSelection();
                                    JComboBox ret = super.getComboBox(options2);
                                    if (s != null) {
                                        ret.setSelectedItem((Object)s);
                                    }
                                    return ret;
                                }

                                protected ListCellRenderer getRenderer(final ListCellRenderer orgRenderer) {
                                    return new ListCellRenderer(){

                                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                            if (value == null) {
                                                return orgRenderer.getListCellRendererComponent(list, _GUI.T.AddActionAction_getListCellRendererComponent_no_action_(), index, isSelected, cellHasFocus);
                                            }
                                            switch ((OnOfflineLinksAction)((Object)value)) {
                                                case EXCLUDE_OFFLINE: {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.ConfirmLinksContextAction_getListCellRendererComponent_EXCLUDE_OFFLINE(), index, isSelected, cellHasFocus);
                                                }
                                                case EXCLUDE_OFFLINE_AND_REMOVE: {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.ConfirmLinksContextAction_getListCellRendererComponent_EXCLUDE_OFFLINE_AND_REMOVE(), index, isSelected, cellHasFocus);
                                                }
                                                case INCLUDE_OFFLINE: {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.ConfirmLinksContextAction_getListCellRendererComponent_INCLUDE_OFFLINE(), index, isSelected, cellHasFocus);
                                                }
                                            }
                                            JLabel ret = (JLabel)orgRenderer.getListCellRendererComponent(list, ((OnOfflineLinksAction)((Object)value)).getLabel(), index, isSelected, cellHasFocus);
                                            return ret;
                                        }
                                    };
                                }
                            };
                            ComboBoxDialogInterface result = (ComboBoxDialogInterface)UIOManager.I().show(ComboBoxDialogInterface.class, (UserIODefinition)combo);
                            try {
                                result.throwCloseExceptions();
                            }
                            catch (Exception e) {
                                return;
                            }
                            handleOfflineLoc = options[result.getSelectedIndex()];
                            CFG_LINKGRABBER.CFG.setHandleOfflineOnConfirmLatestSelection(handleOfflineLoc);
                            alreadyDisplayedOtherDialogToUser = true;
                        }
                        switch (handleOfflineLoc) {
                            case EXCLUDE_OFFLINE: {
                                toKeepInLinkgrabber.add(cl);
                                break;
                            }
                            case EXCLUDE_OFFLINE_AND_REMOVE: {
                                toDelete.add(cl);
                            }
                        }
                    }
                }
                if (handleDupesLoc != OnDupesLinksAction.INCLUDE) {
                    ArrayList<Object> dupes = new ArrayList<Object>();
                    for (Object cl : selection.getChildren()) {
                        String id = ((CrawledLink)cl).getLinkID();
                        if (toKeepInLinkgrabber.contains(cl) || toDelete.contains(cl) || !DownloadController.getInstance().hasDownloadLinkByID(id)) continue;
                        dupes.add(cl);
                        if (handleDupesLoc == OnDupesLinksAction.ASK) {
                            OnDupesLinksAction[] options = new OnDupesLinksAction[]{OnDupesLinksAction.INCLUDE, OnDupesLinksAction.EXCLUDE, OnDupesLinksAction.EXCLUDE_AND_REMOVE};
                            ComboBoxDialog combo = new ComboBoxDialog(0, _GUI.T.ConfirmLinksContextAction_run_dupes_ask_title(), _GUI.T.ConfirmLinksContextAction_run_dupes_ask_question(), (Object[])options, 0, null, null, null, null){

                                protected JComboBox getComboBox(Object[] options2) {
                                    OnDupesLinksAction s = CFG_LINKGRABBER.CFG.getHandleDupesOnConfirmLatestSelection();
                                    JComboBox ret = super.getComboBox(options2);
                                    if (s != null) {
                                        ret.setSelectedItem((Object)s);
                                    }
                                    return ret;
                                }

                                protected ListCellRenderer getRenderer(final ListCellRenderer orgRenderer) {
                                    return new ListCellRenderer(){

                                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                            if (value == null) {
                                                return orgRenderer.getListCellRendererComponent(list, _GUI.T.AddActionAction_getListCellRendererComponent_no_action_(), index, isSelected, cellHasFocus);
                                            }
                                            switch ((OnDupesLinksAction)((Object)value)) {
                                                case EXCLUDE: {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.ConfirmLinksContextAction_getListCellRendererComponent_EXCLUDE_DUPES(), index, isSelected, cellHasFocus);
                                                }
                                                case EXCLUDE_AND_REMOVE: {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.ConfirmLinksContextAction_getListCellRendererComponent_EXCLUDE_DUPES_AND_REMOVE(), index, isSelected, cellHasFocus);
                                                }
                                                case INCLUDE: {
                                                    return orgRenderer.getListCellRendererComponent(list, _GUI.T.ConfirmLinksContextAction_getListCellRendererComponent_INCLUDE_DUPES(), index, isSelected, cellHasFocus);
                                                }
                                            }
                                            JLabel ret = (JLabel)orgRenderer.getListCellRendererComponent(list, ((OnDupesLinksAction)((Object)value)).getLabel(), index, isSelected, cellHasFocus);
                                            return ret;
                                        }
                                    };
                                }
                            };
                            ComboBoxDialogInterface result = (ComboBoxDialogInterface)UIOManager.I().show(ComboBoxDialogInterface.class, (UserIODefinition)combo);
                            try {
                                result.throwCloseExceptions();
                            }
                            catch (Exception e) {
                                return;
                            }
                            handleDupesLoc = options[result.getSelectedIndex()];
                            CFG_LINKGRABBER.CFG.setHandleDupesOnConfirmLatestSelection(handleDupesLoc);
                            alreadyDisplayedOtherDialogToUser = true;
                        }
                        switch (handleDupesLoc) {
                            case EXCLUDE: {
                                toKeepInLinkgrabber.add(cl);
                                break;
                            }
                            case EXCLUDE_AND_REMOVE: {
                                toDelete.add(cl);
                            }
                        }
                    }
                }
                ArrayList<CrawledLink> toMove = new ArrayList<CrawledLink>();
                boolean createNewSelectionInfo = false;
                for (CrawledLink cl : selection.getChildren()) {
                    if (toDelete.contains(cl)) {
                        createNewSelectionInfo = true;
                        continue;
                    }
                    if (toKeepInLinkgrabber.contains(cl)) {
                        createNewSelectionInfo = true;
                        continue;
                    }
                    toMove.add(cl);
                }
                if (toDelete.size() > 0) {
                    LinkCollector.getInstance().removeChildren((List<CrawledLink>)new ArrayList<CrawledLink>(toDelete));
                }
                if (toMove.size() == 0) {
                    return;
                }
                SelectionInfo<CrawledPackage, CrawledLink> finalSelection = createNewSelectionInfo ? new SelectionInfo<CrawledPackage, CrawledLink>(null, toMove) : selection;
                int numberofPackages = selection.getPackageViews().size();
                int numberofLinks = selection.getChildren().size();
                ConfirmationDialogBehavior confirmationDialogBehavior = settings.getConfirmationDialogBehavior();
                if ((confirmationDialogBehavior == ConfirmationDialogBehavior.ENABLED_THRESHOLD_AUTO && !alreadyDisplayedOtherDialogToUser || confirmationDialogBehavior == ConfirmationDialogBehavior.ENABLED_THRESHOLD_SIMPLE) && numberofPackages >= 1 && numberofLinks >= 1 && !UIOManager.I().showConfirmDialog(0, _GUI.T.literall_are_you_sure(), _GUI.T.ConfirmContextmenuAction_confirmation_dialog_text(numberofPackages, numberofLinks), (Icon)new AbstractIcon("question", 32), _GUI.T.literally_yes(), _GUI.T.literall_no())) {
                    return;
                }
                LinkCollector.getInstance().moveLinksToDownloadList(finalSelection, settings);
                if (Boolean.TRUE.equals(settings.isSwitchToDownloadlistOnConfirm())) {
                    ConfirmLinksContextAction.switchToDownloadTab();
                }
                if (Boolean.TRUE.equals(settings.isClearLinkgrabberlistOnConfirm())) {
                    ConfirmLinksContextAction.clearLinkgrabber();
                }
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.setName(ConfirmLinksContextAction.class.getName());
        thread.start();
    }

    protected static void switchToDownloadTab() {
        if (!Application.isHeadless()) {
            new EDTRunner(){

                protected void runInEDT() {
                    JDGui.getInstance().requestPanel(JDGui.Panels.DOWNLOADLIST);
                }
            };
        }
    }

    protected static void clearLinkgrabber() {
        LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (!Application.isHeadless()) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            LinkgrabberSearchField.getInstance().setText("");
                            LinkgrabberSearchField.getInstance().onChanged();
                        }
                    };
                }
                LinkCollector.getInstance().clear();
                return null;
            }
        });
    }

    public static String getTranslationForHandleOffline() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForHandleOffline();
    }

    @Customizer(link="#getTranslationForHandleOffline")
    @Order(value=10)
    public OnOfflineLinksAction getHandleOffline() {
        return this.handleOffline;
    }

    public ConfirmLinksContextAction setHandleOffline(OnOfflineLinksAction handleOffline) {
        if (handleOffline == null) {
            handleOffline = OnOfflineLinksAction.GLOBAL;
        }
        this.handleOffline = handleOffline;
        return this;
    }

    public static String getTranslationForHandleDupes() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForHandleDupes();
    }

    @Customizer(link="#getTranslationForHandleDupes")
    @Order(value=11)
    public OnDupesLinksAction getHandleDupes() {
        return this.handleDupes;
    }

    public ConfirmLinksContextAction setHandleDupes(OnDupesLinksAction handleDupes) {
        if (handleDupes == null) {
            handleDupes = OnDupesLinksAction.GLOBAL;
        }
        this.handleDupes = handleDupes;
        return this;
    }

    public ConfirmLinksContextAction() {
        super(false, true);
        GUIEventSender.getInstance().addListener(this, true);
        this.metaCtrl = KeyObserver.getInstance().isMetaDown(true) || KeyObserver.getInstance().isControlDown(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LinkCollector.ConfirmLinksSettings cls = new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.MANUAL);
        cls.setAutoStartDownloads(this.doAutostart());
        cls.setClearLinkgrabberlistOnConfirm(this.isClearListAfterConfirm());
        if (this.isAssignPriorityEnabled()) {
            cls.setPriority(this.getPriority());
        }
        cls.setPackageExpandBehavior(this.getPackageExpandBehavior());
        cls.setForceDownloads(this.isForceDownloads());
        cls.setHandleOffline(this.getHandleOffline());
        cls.setHandleDupes(this.getHandleDupes());
        cls.setConfirmationDialogBehavior(this.getConfirmationDialogBehavior());
        cls.setConfirmationDialogThresholdMinPackages(this.getMinNumberofPackagesForMoveToDownloadlistConfirmDialog());
        cls.setConfirmationDialogThresholdMinLinks(this.getMinNumberofLinksForMoveToDownloadlistConfirmDialog());
        SelectionInfo<CrawledPackage, CrawledLink> si = this.isSelectionOnly() ? this.getSelection() : this.getAllLinkgrabberItems();
        ConfirmLinksContextAction.confirmSelection(si, cls);
    }

    public SelectionInfo<CrawledPackage, CrawledLink> getAllLinkgrabberItems() {
        return LinkGrabberTable.getInstance().getSelectionInfo(false, true);
    }

    protected boolean doAutostart() {
        boolean ret;
        boolean bl = ret = this.autoStart != null && this.autoStart.isEnabled();
        if (this.metaCtrl && this.isCtrlToggle()) {
            return !ret;
        }
        return ret;
    }

    @Order(value=300)
    public AutoStartOptions getAutoStart() {
        return this.autoStart;
    }

    @Override
    public void initContextDefaults() {
        this.setAutoStart(AutoStartOptions.AUTO);
    }

    public static String getTranslationForClearListAfterConfirm() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForClearListAfterConfirm();
    }

    @Customizer(link="#getTranslationForClearListAfterConfirm")
    @Order(value=200)
    public boolean isClearListAfterConfirm() {
        return this.clearListAfterConfirm;
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
    }

    @Override
    public void onKeyModifier(int parameter) {
        this.metaCtrl = KeyObserver.getInstance().isControlDown(false) || KeyObserver.getInstance().isMetaDown(false);
        this.updateLabelAndIcon();
    }

    @Override
    protected SelectionInfo<CrawledPackage, CrawledLink> getSelection() {
        if (!this.isSelectionOnly()) {
            return LinkGrabberTable.getInstance().getSelectionInfo(false, true);
        }
        return LinkGrabberTable.getInstance().getSelectionInfo(true, true);
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.onKeyModifier(-1);
        this.updateLabelAndIcon();
    }

    public static String getTranslationForAutoStart() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForAutoStart();
    }

    @Customizer(link="#getTranslationForAutoStart")
    public ConfirmLinksContextAction setAutoStart(AutoStartOptions autoStart) {
        if (autoStart == null) {
            autoStart = AutoStartOptions.AUTO;
        }
        this.autoStart = autoStart;
        this.updateLabelAndIcon();
        return this;
    }

    public void setClearListAfterConfirm(boolean clearListAfterConfirm) {
        this.clearListAfterConfirm = clearListAfterConfirm;
    }

    public static String getTranslationForSelectionOnly() {
        return _JDT.T.ConfirmLinksContextAction_getTranslationForSelectionOnly();
    }

    @Customizer(link="#getTranslationForSelectionOnly")
    @Order(value=1)
    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public void setSelectionOnly(boolean selectionOnly) {
        this.selectionOnly = selectionOnly;
        this.updateLabelAndIcon();
    }

    protected void updateLabelAndIcon() {
        if (this.isForceDownloads()) {
            if (this.isSelectionOnly()) {
                this.setName(this.getTextForForcedSelectionOnly());
            } else {
                this.setName(this.getTextForForcedAll());
            }
            Image add = NewTheme.I().getImage("media-playback-start", 20);
            Image play = NewTheme.I().getImage("prio_3", 14);
            this.setSmallIcon(new ImageIcon(ImageProvider.merge((Image)add, (Image)play, (int)-4, (int)0, (int)6, (int)10)));
            this.setIconKey(null);
        } else if (this.doAutostart()) {
            if (this.isSelectionOnly()) {
                this.setName(this.getTextForAutoStartSelectionOnly());
            } else {
                this.setName(this.getTextForAutoStartAll());
            }
            Image add = NewTheme.I().getImage("media-playback-start", 16);
            Image play = NewTheme.I().getImage("add", 14);
            this.setSmallIcon(new ImageIcon(ImageProvider.merge((Image)add, (Image)play, (int)0, (int)0, (int)6, (int)6)));
            this.setIconKey(null);
        } else {
            if (this.isSelectionOnly()) {
                this.setName(this.getTextForNoAutoStartSelectionOnly());
            } else {
                this.setName(this.getTextForNoAutoStartAll());
            }
            this.setSmallIcon(NewTheme.I().getIcon("go-next", 20));
        }
    }

    protected String getTextForForcedAll() {
        return _GUI.T.ConfirmAllContextmenuAction_context_add_and_force();
    }

    protected String getTextForForcedSelectionOnly() {
        return _GUI.T.ConfirmAction_ConfirmAction_context_add_and_force();
    }

    protected String getTextForNoAutoStartAll() {
        return _GUI.T.ConfirmAllContextmenuAction_context_add();
    }

    protected String getTextForNoAutoStartSelectionOnly() {
        return _GUI.T.ConfirmAction_ConfirmAction_context_add();
    }

    protected String getTextForAutoStartAll() {
        return _GUI.T.ConfirmAllContextmenuAction_context_add_and_start();
    }

    protected String getTextForAutoStartSelectionOnly() {
        return _GUI.T.ConfirmAction_ConfirmAction_context_add_and_start();
    }

    public boolean isEnabled() {
        if (this.isSelectionOnly() && !this.hasSelection()) {
            return false;
        }
        SelectionInfo<CrawledPackage, CrawledLink> allItems = this.getAllLinkgrabberItems();
        if (allItems == null || allItems.isEmpty()) {
            return false;
        }
        return super.isEnabled();
    }

    public static enum ConfirmationDialogBehavior implements LabelInterface
    {
        DISABLED{

            public String getLabel() {
                return "Disabled";
            }
        }
        ,
        ENABLED_THRESHOLD_AUTO{

            public String getLabel() {
                return "Auto: Threshold & if no other dialogs were shown";
            }
        }
        ,
        ENABLED_THRESHOLD_SIMPLE{

            public String getLabel() {
                return "Enabled: Threshold";
            }
        };

    }

    public static enum PackageExpandBehavior implements LabelInterface
    {
        UNCHANGED{

            public String getLabel() {
                return _JDT.T.PackageExpandBehavior_UNCHANGED();
            }
        }
        ,
        EXPANDED{

            public String getLabel() {
                return _JDT.T.PackageExpandBehavior_EXPANDED();
            }
        }
        ,
        COLLAPSED{

            public String getLabel() {
                return _JDT.T.PackageExpandBehavior_COLLAPSED();
            }
        };

    }

    public static enum AutoStartOptions implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return _JDT.T.AutoStartOptions_AUTO();
            }

            @Override
            public boolean isEnabled() {
                return CFG_LINKGRABBER.LINKGRABBER_AUTO_START_ENABLED.isEnabled();
            }
        }
        ,
        DISABLED{

            public String getLabel() {
                return _JDT.T.AutoStartOptions_DISABLED();
            }

            @Override
            public boolean isEnabled() {
                return false;
            }
        }
        ,
        ENABLED{

            public String getLabel() {
                return _JDT.T.AutoStartOptions_ENABLED();
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        };


        public abstract boolean isEnabled();
    }

    public static enum OnDupesLinksAction implements LabelInterface
    {
        INCLUDE{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleDupesLinksOptions_INCLUDE();
            }

            @Override
            public OnDupesLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        EXCLUDE{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleDupesLinksOptions_EXCLUDE();
            }

            @Override
            public OnDupesLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        EXCLUDE_AND_REMOVE{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleDupesLinksOptions_EXCLUDE_AND_REMOVE();
            }

            @Override
            public OnDupesLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        ASK{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleDupesLinksOptions_ASK();
            }

            @Override
            public OnDupesLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        GLOBAL{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleDupesLinksOptions_GLOBAL(this.getSelectedAction().getLabel());
            }

            @Override
            public OnDupesLinksAction getSelectedAction() {
                OnDupesLinksAction dflt = CFG_LINKGRABBER.CFG.getDefaultOnAddedDupesLinksAction();
                if (dflt == this || dflt == null) {
                    return ASK;
                }
                return dflt;
            }
        };


        public abstract OnDupesLinksAction getSelectedAction();
    }

    public static enum OnOfflineLinksAction implements LabelInterface
    {
        INCLUDE_OFFLINE{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleOfflineLinksOptions_INCLUDE_OFFLINE();
            }

            @Override
            public OnOfflineLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        EXCLUDE_OFFLINE{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleOfflineLinksOptions_EXCLUDE_OFFLINE();
            }

            @Override
            public OnOfflineLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        EXCLUDE_OFFLINE_AND_REMOVE{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleOfflineLinksOptions_EXCLUDE_OFFLINE_AND_REMOVE();
            }

            @Override
            public OnOfflineLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        ASK{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleOfflineLinksOptions_ASK();
            }

            @Override
            public OnOfflineLinksAction getSelectedAction() {
                return this;
            }
        }
        ,
        GLOBAL{

            public String getLabel() {
                return _JDT.T.ConfirmLinksContextAction_HandleOfflineLinksOptions_GLOBAL(this.getSelectedAction().getLabel());
            }

            @Override
            public OnOfflineLinksAction getSelectedAction() {
                OnOfflineLinksAction dflt = CFG_LINKGRABBER.CFG.getDefaultOnAddedOfflineLinksAction();
                if (dflt == this || dflt == null) {
                    return ASK;
                }
                return dflt;
            }
        };


        public abstract OnOfflineLinksAction getSelectedAction();
    }
}

