/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.LocationInList;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.gui.views.linkgrabber.contextmenu.NewPackageDialog;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;
import org.jdownloader.translate._JDT;

public class SplitPackagesByHost
extends CustomizableTableContextAppAction<CrawledPackage, CrawledLink>
implements ActionContext {
    private static final long serialVersionUID = 2636706677433058054L;
    private LocationInList location = LocationInList.AFTER_SELECTION;
    private boolean mergePackages = false;
    private boolean askForNewDownloadFolderAndPackageName = true;

    public SplitPackagesByHost() {
        this.setName(_GUI.T.SplitPackagesByHost_SplitPackagesByHost_object_());
        this.setIconKey("split_packages");
    }

    public static String getTranslationForMergePackages() {
        return _JDT.T.SplitPackagesByHost_getTranslationForMergePackages();
    }

    @Customizer(link="#getTranslationForMergePackages")
    public boolean isMergePackages() {
        return this.mergePackages;
    }

    public void setMergePackages(boolean mergePackages) {
        this.mergePackages = mergePackages;
    }

    public static String getTranslationForAskForNewDownloadFolderAndPackageName() {
        return _JDT.T.SplitPackagesByHost_getTranslationForAskForNewDownloadFolderAndPackageName();
    }

    @Customizer(link="#getTranslationForAskForNewDownloadFolderAndPackageName")
    public boolean isAskForNewDownloadFolderAndPackageName() {
        return this.askForNewDownloadFolderAndPackageName;
    }

    public void setAskForNewDownloadFolderAndPackageName(boolean askForNewDownloadFolderIfMerging) {
        this.askForNewDownloadFolderAndPackageName = askForNewDownloadFolderIfMerging;
    }

    public static String getTranslationForLocation() {
        return _JDT.T.SplitPackagesByHost_getTranslationForLocation();
    }

    @Customizer(link="#getTranslationForLocation")
    public LocationInList getLocation() {
        return this.location;
    }

    public void setLocation(LocationInList location) {
        this.location = location;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newDownloadFolder;
        String newName;
        SelectionInfo finalSelecction;
        block6: {
            finalSelecction = this.getSelection();
            if (this.isMergePackages() && finalSelecction.getPackageViews().size() > 1) {
                if (this.isAskForNewDownloadFolderAndPackageName()) {
                    try {
                        NewPackageDialog d = new NewPackageDialog(finalSelecction){

                            public String getDontShowAgainKey() {
                                return "ABSTRACTDIALOG_DONT_SHOW_AGAIN_" + SplitPackagesByHost.this.getClass().getSimpleName();
                            }
                        };
                        Dialog.getInstance().showDialog((AbstractDialog)d);
                        newName = d.getName();
                        newDownloadFolder = d.getDownloadFolder();
                        if (StringUtils.isEmpty((String)newName)) {
                            return;
                        }
                        break block6;
                    }
                    catch (Throwable ignore) {
                        return;
                    }
                }
                newName = "";
                newDownloadFolder = ((CrawledPackage)finalSelecction.getFirstPackage()).getRawDownloadFolder();
            } else {
                newName = null;
                newDownloadFolder = null;
            }
        }
        LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                HashMap splitMap = new HashMap();
                int insertAt = -1;
                switch (SplitPackagesByHost.this.getLocation()) {
                    case BEFORE_SELECTION: {
                        insertAt = Integer.MAX_VALUE;
                    }
                }
                for (AbstractNode child : finalSelecction.getChildren()) {
                    String host;
                    ArrayList<CrawledLink> hostList;
                    if (!(child instanceof CrawledLink)) continue;
                    CrawledLink cL = (CrawledLink)child;
                    CrawledPackage parent = SplitPackagesByHost.this.isMergePackages() ? null : cL.getParentNode();
                    HashMap<String, ArrayList<CrawledLink>> parentMap = (HashMap<String, ArrayList<CrawledLink>>)splitMap.get(parent);
                    if (parentMap == null) {
                        parentMap = new HashMap<String, ArrayList<CrawledLink>>();
                        splitMap.put(parent, parentMap);
                    }
                    if ((hostList = (ArrayList<CrawledLink>)parentMap.get(host = cL.getDomainInfo().getTld())) == null) {
                        hostList = new ArrayList<CrawledLink>();
                        parentMap.put(host, hostList);
                    }
                    hostList.add(cL);
                    switch (SplitPackagesByHost.this.getLocation()) {
                        case AFTER_SELECTION: {
                            insertAt = Math.max(insertAt, LinkCollector.getInstance().indexOf(((CrawledLink)child).getParentNode()) + 1);
                            break;
                        }
                        case BEFORE_SELECTION: {
                            insertAt = Math.min(insertAt, LinkCollector.getInstance().indexOf(((CrawledLink)child).getParentNode()));
                            break;
                        }
                        case END_OF_LIST: {
                            insertAt = -1;
                            break;
                        }
                        case TOP_OF_LIST: {
                            insertAt = 0;
                        }
                    }
                }
                if (insertAt == Integer.MAX_VALUE) {
                    insertAt = 0;
                }
                String nameFactory = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).getSplitPackageNameFactoryPattern();
                boolean merge = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).isSplitPackageMergeEnabled();
                HashMap<String, CrawledPackage> mergedPackages = new HashMap<String, CrawledPackage>();
                for (Map.Entry next : splitMap.entrySet()) {
                    CrawledPackage sourcePackage = (CrawledPackage)next.getKey();
                    HashMap items = (HashMap)next.getValue();
                    for (Map.Entry next2 : items.entrySet()) {
                        CrawledPackage newPkg;
                        String host = (String)next2.getKey();
                        String newPackageName = SplitPackagesByHost.this.getNewPackageName(nameFactory, sourcePackage == null ? newName : sourcePackage.getName(), host);
                        if (merge) {
                            CrawledPackage destPackage = (CrawledPackage)mergedPackages.get(newPackageName);
                            if (destPackage == null) {
                                destPackage = new CrawledPackage();
                                destPackage.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
                                if (sourcePackage != null) {
                                    sourcePackage.copyPropertiesTo(destPackage);
                                } else {
                                    destPackage.setDownloadFolder(newDownloadFolder);
                                }
                                destPackage.setName(newPackageName);
                                mergedPackages.put(newPackageName, destPackage);
                            }
                            newPkg = destPackage;
                        } else {
                            newPkg = new CrawledPackage();
                            newPkg.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
                            if (sourcePackage != null) {
                                sourcePackage.copyPropertiesTo(newPkg);
                            } else {
                                newPkg.setDownloadFolder(newDownloadFolder);
                            }
                            newPkg.setName(newPackageName);
                        }
                        LinkCollector.getInstance().moveOrAddAt(newPkg, (List<CrawledLink>)((List)next2.getValue()), 0, insertAt);
                        ++insertAt;
                    }
                }
                return null;
            }
        });
    }

    public String getNewPackageName(String nameFactory, String oldPackageName, String host) {
        if (StringUtils.isEmpty((String)nameFactory)) {
            if (!StringUtils.isEmpty((String)oldPackageName)) {
                return oldPackageName;
            }
            return host;
        }
        nameFactory = !StringUtils.isEmpty((String)oldPackageName) ? nameFactory.replaceAll("\\{PACKAGENAME\\}", oldPackageName) : nameFactory.replaceAll("\\{PACKAGENAME\\}", _JDT.T.LinkCollector_addCrawledLink_variouspackage());
        nameFactory = nameFactory.replaceAll("\\{HOSTNAME\\}", host);
        return nameFactory;
    }
}

