/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.download.HashInfo;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.properties.AbstractNodeProperties;
import org.jdownloader.gui.views.linkgrabber.contextmenu.SetDownloadFolderInLinkgrabberAction;
import org.jdownloader.settings.GeneralSettings;

public class CrawledLinkNodeProperties
extends AbstractNodeProperties<CrawledLink> {
    private final CrawledLink currentLink;
    private final CrawledPackage currentPackage;
    private List<Archive> archives = null;

    public CrawledLinkNodeProperties(CrawledLink crawledLink) {
        this.currentLink = crawledLink;
        this.currentPackage = crawledLink.getParentNode();
    }

    @Override
    protected List<Archive> loadArchives() {
        if (this.archives == null) {
            ArrayList<CrawledLink> children = new ArrayList<CrawledLink>();
            CrawledLink lCurrentLink = this.currentLink;
            if (lCurrentLink != null) {
                children.add(lCurrentLink);
            }
            this.archives = ArchiveValidator.getArchivesFromPackageChildren(children);
        }
        return this.archives;
    }

    @Override
    protected String loadComment() {
        return this.currentLink.getDownloadLink().getComment();
    }

    @Override
    protected String loadDownloadFrom() {
        String dlLink = this.currentLink.getDownloadLink().getView().getDisplayUrl();
        if (dlLink == null) {
            return "*******************************";
        }
        return dlLink;
    }

    @Override
    protected String loadDownloadPassword() {
        return this.currentLink.getDownloadLink().getDownloadPassword();
    }

    @Override
    protected String loadFilename() {
        return this.currentLink.getName();
    }

    @Override
    protected Priority loadPriority() {
        return this.currentLink.getPriority();
    }

    @Override
    protected String loadSaveTo() {
        if (this.currentPackage != null) {
            return LinkTreeUtils.getRawDownloadDirectory(this.currentPackage).getAbsolutePath();
        }
        return ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder();
    }

    @Override
    protected void saveComment(String text) {
        this.currentLink.getDownloadLink().setComment(text);
    }

    @Override
    protected void saveDownloadPassword(String text) {
        this.currentLink.getDownloadLink().setDownloadPassword(text);
    }

    @Override
    protected void saveFilename(String text) {
        this.currentLink.setName(text);
    }

    @Override
    protected void savePriority(Priority priop) {
        this.currentLink.setPriority(priop);
    }

    @Override
    protected boolean samePackage(AbstractPackageNode pkg) {
        return this.currentPackage == pkg;
    }

    @Override
    protected boolean isDifferent(AbstractNode node) {
        if (node != null && node instanceof AbstractPackageChildrenNode) {
            AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)node;
            if (node == this.currentLink.getDownloadLink()) {
                return false;
            }
            return this.currentLink != child || child.getParentNode() != this.currentPackage;
        }
        return true;
    }

    @Override
    protected String loadPackageName() {
        if (this.currentPackage != null) {
            return this.currentPackage.getName();
        }
        return "";
    }

    @Override
    protected void savePackageName(String text) {
        if (this.currentPackage != null) {
            this.currentPackage.setName(text);
        }
    }

    @Override
    protected void saveSaveTo(final String str) {
        if (this.currentPackage != null) {
            new SetDownloadFolderInLinkgrabberAction(new SelectionInfo(this.currentPackage)){
                private static final long serialVersionUID = -7244902643764170242L;

                @Override
                protected File dialog(File path) throws DialogClosedException, DialogCanceledException {
                    return new File(str);
                }
            }.actionPerformed(null);
        }
    }

    @Override
    protected void saveArchivePasswords(List<String> hashSet) {
        List<Archive> archives = this.archives;
        if (archives != null && archives.size() == 1) {
            archives.get(0).getSettings().setPasswords(hashSet);
        }
    }

    @Override
    protected void saveAutoExtract(BooleanStatus selectedItem) {
        List<Archive> archives = this.archives;
        if (archives != null && archives.size() == 1) {
            archives.get(0).getSettings().setAutoExtract(selectedItem);
        }
    }

    @Override
    protected boolean hasLoadedArchives() {
        return this.archives != null;
    }

    @Override
    protected HashInfo loadHashInfo() {
        return this.currentLink.getDownloadLink().getHashInfo();
    }

    @Override
    protected void saveHashInfo(HashInfo hashInfo) {
        this.currentLink.getDownloadLink().setHashInfo(hashInfo);
    }

    @Override
    protected CrawledLink getCurrentNode() {
        return this.currentLink;
    }
}

