/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.properties;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import org.appwork.swing.MigPanel;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.properties.CrawledLinkPropertiesPanel;
import org.jdownloader.gui.views.linkgrabber.properties.CrawledPackagePropertiesPanel;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class LinkgrabberProperties
extends MigPanel {
    private static final long serialVersionUID = -195024600818162517L;
    private final CrawledPackagePropertiesPanel pkgPanel;
    private final CrawledLinkPropertiesPanel linkPanel;

    public LinkgrabberProperties(LinkGrabberTable table) {
        super(LAFOptions.getInstance().getExtension().customizeLinkPropertiesPanelLayout(), "[grow,fill]", "[grow,fill]");
        LAFOptions.getInstance().applyPanelBackground((JComponent)((Object)this));
        this.pkgPanel = new CrawledPackagePropertiesPanel();
        this.linkPanel = new CrawledLinkPropertiesPanel();
        this.add((Component)((Object)this.pkgPanel), "hidemode 3");
        this.add((Component)((Object)this.linkPanel), "hidemode 3");
        this.pkgPanel.setVisible(false);
        this.linkPanel.setVisible(false);
        LAFOptions.getInstance().getExtension().customizeLinkPropertiesPanel((JPanel)((Object)this));
    }

    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        if (CFG_GUI.CFG.isPropertiesPanelHeightNormalized()) {
            ret.height = Math.max(this.pkgPanel.getPreferredSize().height, this.linkPanel.getPreferredSize().height);
        }
        return ret;
    }

    public void update(AbstractNode objectbyRow) {
        if (objectbyRow != null) {
            if (objectbyRow instanceof CrawledPackage) {
                CrawledPackage pkg = (CrawledPackage)objectbyRow;
                this.linkPanel.setVisible(false);
                this.pkgPanel.setVisible(true);
                this.linkPanel.setSelectedItem(null);
                this.pkgPanel.setSelectedItem(pkg);
            } else if (objectbyRow instanceof CrawledLink) {
                CrawledLink link = (CrawledLink)objectbyRow;
                this.linkPanel.setVisible(true);
                this.pkgPanel.setVisible(false);
                this.pkgPanel.setSelectedItem(null);
                this.linkPanel.setSelectedItem(link);
            }
        } else {
            this.linkPanel.setVisible(false);
            this.pkgPanel.setVisible(false);
            this.linkPanel.setSelectedItem(null);
            this.pkgPanel.setSelectedItem(null);
        }
    }

    public void fillPopup(JPopupMenu pu) {
        if (this.linkPanel.isVisible()) {
            this.linkPanel.fillPopup(pu);
        } else if (this.pkgPanel.isVisible()) {
            this.pkgPanel.fillPopup(pu);
        }
    }

    public void refreshAfterTabSwitch() {
        this.linkPanel.refresh();
        this.pkgPanel.refresh();
    }

    public void save() {
        if (this.linkPanel.isVisible()) {
            this.linkPanel.save();
        } else {
            this.linkPanel.removeAbstractNodeProperties();
        }
        if (this.pkgPanel.isVisible()) {
            this.pkgPanel.save();
        } else {
            this.pkgPanel.removeAbstractNodeProperties();
        }
    }
}

