/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.quickfilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import jd.controlling.linkcrawler.CrawledLink;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.views.components.Header;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.quickfilter.Filter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTable;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTableDataUpdater;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_LINKFILTER;

public class QuickFilterHosterTable
extends FilterTable {
    private static final long serialVersionUID = 658947589171018284L;
    private HashMap<String, Filter> filterMapping = new HashMap();
    private HashMap<String, Filter> enabledFilters = new HashMap();

    public QuickFilterHosterTable(Header hosterFilter, LinkGrabberTable table) {
        super(hosterFilter, table, CFG_LINKFILTER.LINKGRABBER_HOSTER_QUICKFILTER_ENABLED);
    }

    @Override
    protected FilterTableDataUpdater getFilterTableDataUpdater() {
        return new FilterTableDataUpdater(){
            Set<Filter> usedFilters = new HashSet<Filter>();
            AtomicBoolean newDisabledFilters = new AtomicBoolean(false);

            @Override
            public void updateVisible(CrawledLink link) {
                Filter filter = QuickFilterHosterTable.this.getFilter(link, this.newDisabledFilters);
                this.usedFilters.add(filter);
                filter.increaseCounter();
            }

            @Override
            public void updateFiltered(CrawledLink link) {
                this.usedFilters.add(QuickFilterHosterTable.this.getFilter(link, this.newDisabledFilters));
            }

            @Override
            public void reset() {
                for (Filter filter : QuickFilterHosterTable.this.filterMapping.values()) {
                    filter.resetCounter();
                }
            }

            @Override
            public FilterTable getFilterTable() {
                return QuickFilterHosterTable.this;
            }

            @Override
            public List<Filter> finalizeUpdater() {
                return new ArrayList<Filter>(this.usedFilters);
            }

            @Override
            public void afterVisible() {
            }

            @Override
            public boolean hasNewDisabledFilters() {
                return this.newDisabledFilters.get();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(boolean enabled, Filter filter, String ID2) {
        HashMap<String, Filter> hashMap = this.enabledFilters;
        synchronized (hashMap) {
            if (!enabled) {
                this.enabledFilters.put(ID2, filter);
            } else {
                this.enabledFilters.remove(ID2);
            }
        }
        this.getLinkgrabberTable().getModel().recreateModel(false);
    }

    private String getID(CrawledLink link) {
        DomainInfo info = link.getDomainInfo();
        if (link.isDirectHTTP()) {
            String linkHOST = info.getTld();
            return linkHOST != null ? "http_".concat(linkHOST) : "http_unknown";
        }
        if (link.isFTP()) {
            String linkHOST = info.getTld();
            return linkHOST != null ? "ftp_".concat(linkHOST) : "ftp_unknown";
        }
        return info.getTld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter getFilter(CrawledLink link, AtomicBoolean newDisabledFilters) {
        Icon favIcon;
        String ID2;
        String HOST;
        final DomainInfo info = link.getDomainInfo();
        if (link.isDirectHTTP()) {
            HOST = info.getTld();
            if (HOST == null) {
                ID2 = "http_unknown";
                favIcon = NewTheme.I().getIcon("browse", 16);
            } else {
                ID2 = "http_".concat(HOST);
                favIcon = null;
            }
        } else if (link.isFTP()) {
            HOST = info.getTld();
            if (HOST == null) {
                ID2 = "ftp_unknown";
                favIcon = NewTheme.I().getIcon("browse", 16);
            } else {
                ID2 = "ftp_".concat(HOST);
                favIcon = null;
            }
        } else {
            ID2 = info.getTld();
            favIcon = null;
        }
        Filter ret = this.filterMapping.get(ID2);
        if (ret == null) {
            ret = new Filter(ID2, null){

                @Override
                protected String getID() {
                    return "Hoster_" + ID2;
                }

                @Override
                public Icon getIcon() {
                    Icon icon = super.getIcon();
                    if (icon == null) {
                        return info;
                    }
                    return icon;
                }

                @Override
                public boolean isFiltered(CrawledLink link) {
                    return ID2.equals(QuickFilterHosterTable.this.getID(link));
                }

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    QuickFilterHosterTable.this.setEnabled(enabled, this, ID2);
                }
            };
            if (favIcon != null) {
                ret.setIcon(favIcon);
            }
            this.filterMapping.put(ID2, ret);
            if (!ret.isEnabled()) {
                newDisabledFilters.set(true);
                HashMap<String, Filter> hashMap = this.enabledFilters;
                synchronized (hashMap) {
                    this.enabledFilters.put(ID2, ret);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFiltered(CrawledLink e) {
        Filter ret = null;
        HashMap<String, Filter> hashMap = this.enabledFilters;
        synchronized (hashMap) {
            ret = this.enabledFilters.get(this.getID(e));
        }
        return ret != null && !ret.isEnabled() && ret != QuickFilterHosterTable.getFilterException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFilteringChildrenNodes() {
        HashMap<String, Filter> hashMap = this.enabledFilters;
        synchronized (hashMap) {
            return this.isEnabled() && this.enabledFilters.size() > 0;
        }
    }

    @Override
    public int getComplexity() {
        return 0;
    }
}

