/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.images;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.jdownloader.images.NewTheme;

public class AbstractIcon
implements Icon,
IDIcon {
    private final String key;
    private final int size;
    private int width = -1;
    private int height = 1;
    private boolean autoDisabledIconEnabled;
    private Composite composite;

    public String getKey() {
        return this.key;
    }

    public int getSize() {
        return this.size;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public AbstractIcon(String key, int size) {
        this.key = key;
        this.size = size;
    }

    public AbstractIcon getIcon(int size) {
        if (size == this.getSize()) {
            return this;
        }
        return new AbstractIcon(this.getKey(), size);
    }

    protected void lazyUpdate() {
        if (this.width == -1 || this.height == -1) {
            Icon icon = NewTheme.I().getIcon(this.getKey(), this.getSize());
            this.width = icon.getIconWidth();
            this.height = icon.getIconHeight();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbstractIcon)) {
            return false;
        }
        return this.key.equals(((AbstractIcon)obj).key) && this.size == ((AbstractIcon)obj).size;
    }

    public int hashCode() {
        return this.key.hashCode() + this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = NewTheme.I().getIcon(this.getKey(), this.getSize());
        if (this.width == -1 || this.height == -1) {
            this.width = icon.getIconWidth();
            this.height = icon.getIconHeight();
        }
        Composite old = null;
        if (this.composite != null) {
            old = ((Graphics2D)g).getComposite();
            ((Graphics2D)g).setComposite(this.composite);
        }
        try {
            if (c != null && !c.isEnabled() && this.isAutoDisabledIconEnabled()) {
                NewTheme.I().getDisabledIcon(icon).paintIcon(c, g, x, y);
            } else {
                icon.paintIcon(c, g, x, y);
            }
        }
        finally {
            if (this.composite != null) {
                ((Graphics2D)g).setComposite(old);
            }
        }
    }

    @Override
    public int getIconWidth() {
        this.lazyUpdate();
        return this.width;
    }

    @Override
    public int getIconHeight() {
        this.lazyUpdate();
        return this.height;
    }

    public IconIdentifier getIdentifier() {
        return new IconIdentifier(null, this.key);
    }

    public void setAutoDisabledIconEnabled(boolean b) {
        this.autoDisabledIconEnabled = b;
    }

    public boolean isAutoDisabledIconEnabled() {
        return this.autoDisabledIconEnabled;
    }

    public void setAlpha(float f) {
        this.setComposite(AlphaComposite.getInstance(3, f));
    }
}

