/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client;

import java.io.IOException;
import org.jdownloader.myjdownloader.client.AccessToken;
import org.jdownloader.myjdownloader.client.BadResponseException;
import org.jdownloader.myjdownloader.client.DiffHandler;
import org.jdownloader.myjdownloader.client.SessionInfo;
import org.jdownloader.myjdownloader.client.exceptions.AuthException;
import org.jdownloader.myjdownloader.client.exceptions.ChallengeFailedException;
import org.jdownloader.myjdownloader.client.exceptions.DeviceIsOfflineException;
import org.jdownloader.myjdownloader.client.exceptions.EmailBlockedException;
import org.jdownloader.myjdownloader.client.exceptions.EmailInvalidException;
import org.jdownloader.myjdownloader.client.exceptions.EmailNotAllowedException;
import org.jdownloader.myjdownloader.client.exceptions.EmailNotValidatedException;
import org.jdownloader.myjdownloader.client.exceptions.EmailQuotaException;
import org.jdownloader.myjdownloader.client.exceptions.ExceptionResponse;
import org.jdownloader.myjdownloader.client.exceptions.MaintenanceException;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.exceptions.OutdatedException;
import org.jdownloader.myjdownloader.client.exceptions.OverloadException;
import org.jdownloader.myjdownloader.client.exceptions.TokenException;
import org.jdownloader.myjdownloader.client.exceptions.TooManyRequestsException;
import org.jdownloader.myjdownloader.client.exceptions.UnconnectedException;
import org.jdownloader.myjdownloader.client.exceptions.UnexpectedIOException;
import org.jdownloader.myjdownloader.client.exceptions.device.ApiFileNotFoundException;
import org.jdownloader.myjdownloader.client.exceptions.device.InternalServerErrorException;
import org.jdownloader.myjdownloader.client.exceptions.device.UnknownCommandException;
import org.jdownloader.myjdownloader.client.exceptions.device.UnknownInterfaceException;
import org.jdownloader.myjdownloader.client.exceptions.device.WrongParametersException;
import org.jdownloader.myjdownloader.client.json.AccessTokenResponse;
import org.jdownloader.myjdownloader.client.json.CaptchaChallenge;
import org.jdownloader.myjdownloader.client.json.ConnectResponse;
import org.jdownloader.myjdownloader.client.json.DeviceConnectResponse;
import org.jdownloader.myjdownloader.client.json.DeviceData;
import org.jdownloader.myjdownloader.client.json.DeviceErrorType;
import org.jdownloader.myjdownloader.client.json.DeviceList;
import org.jdownloader.myjdownloader.client.json.DirectConnectionInfo;
import org.jdownloader.myjdownloader.client.json.DirectConnectionInfos;
import org.jdownloader.myjdownloader.client.json.ErrorResponse;
import org.jdownloader.myjdownloader.client.json.FeedbackResponse;
import org.jdownloader.myjdownloader.client.json.JSonRequest;
import org.jdownloader.myjdownloader.client.json.MyJDJsonMapper;
import org.jdownloader.myjdownloader.client.json.NotificationRequestMessage;
import org.jdownloader.myjdownloader.client.json.NotificationRequestTypesResponse;
import org.jdownloader.myjdownloader.client.json.ObjectData;
import org.jdownloader.myjdownloader.client.json.RequestIDOnly;
import org.jdownloader.myjdownloader.client.json.RequestIDValidator;
import org.jdownloader.myjdownloader.client.json.ServerErrorType;
import org.jdownloader.myjdownloader.client.json.SessionInfoResponse;
import org.jdownloader.myjdownloader.client.json.SuccessfulResponse;

public abstract class AbstractMyJDClient<GenericType> {
    private static final int API_VERSION = 1;
    private String serverRoot = "http://api.jdownloader.org";
    private volatile SessionInfo currentSessionInfo = null;
    private final String appKey;
    private DiffHandler diffhandler;

    public static String byteArrayToHex(byte[] digest) {
        StringBuilder ret = new StringBuilder();
        for (byte d : digest) {
            String tmp = Integer.toHexString(d & 0xFF);
            if (tmp.length() < 2) {
                ret.append('0');
            }
            ret.append(tmp);
        }
        return ret.toString();
    }

    public static byte[] hexToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public AbstractMyJDClient(String appKey) {
        this.appKey = appKey;
    }

    protected abstract byte[] base64decode(String var1);

    protected abstract String base64Encode(byte[] var1);

    public DeviceData bindDevice(DeviceData device) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/binddevice?sessiontoken=" + this.urlencode(session.getSessionToken()) + "&deviceID=" + this.urlencode(device.getId()) + "&type=" + this.urlencode(device.getType()) + "&name=" + this.urlencode(device.getName());
        DeviceConnectResponse ret = this.callServer(query, null, session, DeviceConnectResponse.class);
        device.setId(ret.getDeviceid());
        return device;
    }

    protected Object callAction(String deviceID, String action, GenericType returnType, Object ... args) throws MyJDownloaderException {
        return this.callAction((String)null, deviceID, action, returnType, args);
    }

    public DiffHandler getDiffhandler() {
        return this.diffhandler;
    }

    public void setDiffhandler(DiffHandler diffhandler) {
        this.diffhandler = diffhandler;
    }

    protected Object callAction(String host, String deviceID, String action, GenericType returnType, Object ... args) throws MyJDownloaderException {
        SessionInfo session = null;
        try {
            byte[] data;
            Object ret;
            session = this.getSessionInfo();
            DiffHandler dh = this.getDiffhandler();
            String query = "/t_" + session.getSessionToken() + "_" + this.urlencode(deviceID) + action;
            Object[] params = new String[args != null ? args.length : 0];
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    params[i] = this.objectToJSon(args[i]);
                }
            }
            JSonRequest payload = new JSonRequest();
            payload.setUrl(action);
            payload.setApiVer(1);
            long i = this.getUniqueRID();
            payload.setRid(i);
            payload.setParams(params);
            if (dh != null) {
                dh.prepare(payload, deviceID, action);
            }
            String json = this.objectToJSon(payload);
            this.log("Request:\r\n" + query + "\r\n" + json);
            if (host != null) {
                query = host + query;
            }
            if ((ret = this.convertData(data = this.cryptedPost(query, this.base64Encode(this.encrypt(json.getBytes("UTF-8"), session.getDeviceEncryptionToken())), session.getDeviceEncryptionToken()), returnType)) != null) {
                if (ret instanceof RequestIDValidator && ((RequestIDValidator)ret).getRid() != i) {
                    throw new BadResponseException("RID Mismatch");
                }
                return ret;
            }
            String dec = this.toString(data);
            this.log("Response\r\n" + dec);
            if (dec.indexOf("\"data\" :") > 0) {
                ObjectData dataObject = (ObjectData)this.jsonToObject(dec, ObjectData.class);
                if (data == null) {
                    throw new MyJDownloaderException("Invalid Response: " + dec);
                }
                if (dataObject.getRid() != i) {
                    throw new BadResponseException("RID Mismatch");
                }
                if (returnType == Void.TYPE || returnType == Void.class) {
                    return null;
                }
                String actualResponseString = this.objectToJSon(dataObject.getData()) + "";
                if (dh != null) {
                    actualResponseString = dh.handle(payload, dataObject, deviceID, action, (String)this.jsonToObject(actualResponseString, String.class));
                }
                ret = this.jsonToObject(actualResponseString, returnType);
                return ret;
            }
            ret = this.jsonToObject(dec, returnType);
            if (ret instanceof RequestIDValidator && ((RequestIDValidator)ret).getRid() != i) {
                throw new BadResponseException("RID Mismatch");
            }
            return ret;
        }
        catch (ExceptionResponse e) {
            this.handleInvalidResponseCodes(e, session);
            throw e;
        }
        catch (MyJDownloaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MyJDownloaderException(e, ErrorResponse.Source.DEVICE);
        }
    }

    protected <T> T callServer(String query, JSonRequest jsonRequest, SessionInfo session, Class<T> class1) throws MyJDownloaderException {
        try {
            byte[] data;
            long rid;
            byte[] key = null;
            if (session != null) {
                key = session.getServerEncryptionToken();
            }
            query = query + (query.contains("?") ? "&" : "?");
            if (jsonRequest != null) {
                jsonRequest.setApiVer(1);
                if (jsonRequest.getRid() <= 0L) {
                    rid = this.getUniqueRID();
                    jsonRequest.setRid(rid);
                } else {
                    rid = jsonRequest.getRid();
                }
            } else {
                rid = this.getUniqueRID();
            }
            query = query + "rid=" + rid;
            if (jsonRequest == null) {
                data = this.cryptedPost(query + "&signature=" + this.sign(key, query), null, key);
            } else {
                String json = this.objectToJSon(jsonRequest);
                this.log("Request:\r\n" + query + "\r\n" + json);
                String postData = key != null ? this.base64Encode(this.encrypt(json.getBytes("UTF-8"), key)) : json;
                data = this.cryptedPost(query + "&signature=" + this.sign(key, query), postData, key);
            }
            T ret = this.convertData(data, class1);
            if (ret != null) {
                if (ret instanceof RequestIDValidator && ((RequestIDValidator)ret).getRid() != rid) {
                    throw new BadResponseException("RID Mismatch");
                }
                return ret;
            }
            String dec = this.toString(data);
            ret = this.jsonToObject(dec, class1);
            this.log("Response\r\n" + dec);
            if (ret instanceof RequestIDValidator && ((RequestIDValidator)ret).getRid() != rid) {
                throw new BadResponseException("RID Mismatch");
            }
            return ret;
        }
        catch (ExceptionResponse e) {
            this.handleInvalidResponseCodes(e, session);
            throw e;
        }
        catch (MyJDownloaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MyJDownloaderException(e, ErrorResponse.Source.MYJD);
        }
    }

    public void cancelRegistrationEmail(String email, String key) throws MyJDownloaderException {
        if (email == null || !email.matches("^.+?@.+$") || key == null || key.trim().length() == 0) {
            throw new AuthException();
        }
        this.uncryptedPost("/my/cancelregistrationemail?email=" + this.urlencode(email) + "&key=" + this.urlencode(key), new Object[0]);
    }

    public synchronized SessionInfo connect(String email, String password) throws MyJDownloaderException {
        String retString = null;
        try {
            if (email == null || !email.matches("^.+?@.+$") || password == null || password.trim().length() == 0) {
                throw new AuthException();
            }
            byte[] loginSecret = this.createSecret(email, password, "server");
            byte[] deviceSecret = this.createSecret(email, password, "device");
            long rid = this.getUniqueRID();
            StringBuilder query = new StringBuilder().append("/my/connect?email=").append(this.urlencode(email)).append("&appkey=").append(this.urlencode(this.appKey)).append("&rid=").append(rid);
            String signature = this.sign(loginSecret, query.toString());
            query.append("&signature=").append(this.urlencode(signature));
            retString = this.toString(this.cryptedPost(query.toString(), "", loginSecret));
            ConnectResponse ret = (ConnectResponse)this.jsonToObject(retString, ConnectResponse.class);
            if (ret == null) {
                throw new ExceptionResponse(new IOException("empty response"));
            }
            if (ret.getRid() != rid) {
                throw new BadResponseException("RID Mismatch");
            }
            String sessionToken = ret.getSessiontoken();
            String regainToken = ret.getRegaintoken();
            byte[] serverEncryptionToken = this.updateEncryptionToken(loginSecret, AbstractMyJDClient.hexToByteArray(sessionToken));
            byte[] deviceEncryptionToken = this.updateEncryptionToken(deviceSecret, AbstractMyJDClient.hexToByteArray(sessionToken));
            SessionInfo newSessionInfo = this.createSessionInfo(deviceSecret, serverEncryptionToken, deviceEncryptionToken, sessionToken, regainToken);
            this.setSessionInfo(newSessionInfo);
            return newSessionInfo;
        }
        catch (ExceptionResponse e) {
            this.handleInvalidResponseCodes(e, null);
            throw e;
        }
        catch (MyJDownloaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MyJDownloaderException(e, ErrorResponse.Source.MYJD);
        }
    }

    protected <T> T convertData(byte[] data, GenericType returnType) throws MyJDownloaderException {
        if (returnType == byte[].class) {
            return (T)data;
        }
        return null;
    }

    protected abstract byte[] createSecret(String var1, String var2, String var3) throws MyJDownloaderException;

    protected SessionInfo createSessionInfo(byte[] deviceSecret, byte[] serverEncryptionToken, byte[] deviceEncryptionToken, String sessionToken, String regainToken) {
        return new SessionInfo(deviceSecret, serverEncryptionToken, deviceEncryptionToken, sessionToken, regainToken);
    }

    private byte[] cryptedPost(String url, String objectToJSon, byte[] keyAndIV) throws MyJDownloaderException {
        return this.post(url, objectToJSon, keyAndIV);
    }

    protected abstract byte[] decrypt(byte[] var1, byte[] var2) throws MyJDownloaderException;

    public synchronized void disconnect() throws MyJDownloaderException {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean removeSession) throws MyJDownloaderException {
        try {
            SessionInfo session = this.getSessionInfo();
            String query = "/my/disconnect?sessiontoken=" + this.urlencode(session.getSessionToken());
            this.callServer(query, null, session, RequestIDOnly.class);
        }
        finally {
            if (removeSession) {
                this.setSessionInfo(null);
            }
        }
    }

    protected abstract byte[] encrypt(byte[] var1, byte[] var2) throws MyJDownloaderException;

    public String feedback(String message) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        JSonRequest re = new JSonRequest();
        re.setApiVer(1);
        re.setRid(this.getUniqueRID());
        re.setParams(new Object[]{message});
        String url = "/my/feedback?sessiontoken=" + this.urlencode(session.getSessionToken());
        re.setUrl(url);
        FeedbackResponse ret = this.callServer(url, re, session, FeedbackResponse.class);
        return ret.getFeedbackID();
    }

    public void finishPasswordReset(String email, String key, String newPassword) throws MyJDownloaderException {
        byte[] k = AbstractMyJDClient.hexToByteArray(key);
        if (k.length != 32) {
            throw new IllegalArgumentException("Bad Key. Expected: 64 hexchars");
        }
        byte[] newLoginSecret = this.createSecret(email, newPassword, "server");
        String encryptedNewSecret = AbstractMyJDClient.byteArrayToHex(this.encrypt(newLoginSecret, k));
        SessionInfo session = new SessionInfo();
        session.setServerEncryptionToken(k);
        this.callServer("/my/finishpasswordreset?email=" + this.urlencode(email) + "&encryptedLoginSecret=" + encryptedNewSecret, null, session, RequestIDOnly.class);
        this.connect(email, newPassword);
    }

    public void finishRegistration(String key, String email, String password) throws MyJDownloaderException {
        byte[] k = AbstractMyJDClient.hexToByteArray(key);
        if (k.length != 32) {
            throw new IllegalArgumentException("Bad Key. Expected: 64 hexchars");
        }
        byte[] loginSecret = this.createSecret(email, password, "server");
        String pw = AbstractMyJDClient.byteArrayToHex(this.encrypt(loginSecret, k));
        SessionInfo session = new SessionInfo();
        session.setServerEncryptionToken(k);
        this.callServer("/my/finishregistration?email=" + this.urlencode(email) + "&loginsecret=" + this.urlencode(pw), null, session, RequestIDOnly.class);
    }

    public void finishTermination(String key, String email, String password, CaptchaChallenge challenge) throws MyJDownloaderException {
        byte[] k = AbstractMyJDClient.hexToByteArray(key);
        if (k.length != 32) {
            throw new IllegalArgumentException("Bad Key. Expected: 64 hexchars");
        }
        byte[] loginSecret = this.createSecret(email, password, "server");
        String pw = AbstractMyJDClient.byteArrayToHex(this.encrypt(loginSecret, k));
        SessionInfo session = new SessionInfo();
        session.setServerEncryptionToken(k);
        this.callServer("/my/finishtermination?email=" + this.urlencode(email) + "&loginsecret=" + this.urlencode(pw) + "&captchaResponse=" + this.urlencode(challenge.getCaptchaResponse()) + "&captchaChallenge=" + this.urlencode(challenge.getCaptchaChallenge()), null, session, RequestIDOnly.class);
    }

    public CaptchaChallenge getChallenge() throws MyJDownloaderException {
        return (CaptchaChallenge)this.jsonToObject(this.toString(this.uncryptedPost("/captcha/getCaptcha", null)), CaptchaChallenge.class);
    }

    public byte[] getDeviceEncryptionTokenBySession(String sessionToken) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        return this.updateEncryptionToken(session.getDeviceSecret(), AbstractMyJDClient.hexToByteArray(sessionToken));
    }

    public DirectConnectionInfos getDirectConnectionInfos(String deviceID) throws MyJDownloaderException {
        return (DirectConnectionInfos)this.callAction((String)null, deviceID, "/device/getDirectConnectionInfos", (GenericType)DirectConnectionInfos.class, (Object[])null);
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public SessionInfo getSessionInfo() throws UnconnectedException {
        SessionInfo ret = this.currentSessionInfo;
        if (ret == null || !ret.isValid()) {
            throw new UnconnectedException();
        }
        return ret;
    }

    protected abstract long getUniqueRID();

    protected void handleInvalidResponseCodes(ExceptionResponse e, SessionInfo session) throws MyJDownloaderException {
        if (e != null && e.getContent() != null && e.getContent().trim().length() != 0) {
            ErrorResponse error = null;
            try {
                error = (ErrorResponse)this.jsonToObject(e.getContent(), ErrorResponse.class);
                if (error != null) {
                    block1 : switch (error.getSrc()) {
                        case DEVICE: {
                            if (error.getType() == null) break;
                            DeviceErrorType type = DeviceErrorType.valueOf(error.getType());
                            switch (type) {
                                case INTERNAL_SERVER_ERROR: {
                                    throw new InternalServerErrorException((Object)null);
                                }
                                case API_COMMAND_NOT_FOUND: {
                                    throw new UnknownCommandException((Object)null);
                                }
                                case API_INTERFACE_NOT_FOUND: {
                                    throw new UnknownInterfaceException((Object)null);
                                }
                                case AUTH_FAILED: {
                                    throw new AuthException(e);
                                }
                                case BAD_PARAMETERS: {
                                    throw new WrongParametersException((Object)null);
                                }
                                case FILE_NOT_FOUND: {
                                    throw new ApiFileNotFoundException((Object)null);
                                }
                                case TOKEN_INVALID: {
                                    throw new TokenException(e, session);
                                }
                            }
                            throw new MyJDownloaderException(e);
                        }
                        case MYJD: {
                            if ("API_COMMAND_NOT_FOUND".equals(error.getType())) {
                                throw new UnknownCommandException((Object)null);
                            }
                            if ("BAD_PARAMETERS".equals(error.getType())) {
                                throw new WrongParametersException((Object)null);
                            }
                            if ("API_INTERFACE_NOT_FOUND".equals(error.getType())) {
                                throw new UnknownInterfaceException((Object)null);
                            }
                            if ("INTERNAL_SERVER_ERROR".equals(error.getType())) {
                                throw new InternalServerErrorException((Object)null);
                            }
                            ServerErrorType type = ServerErrorType.valueOf(error.getType());
                            switch (type) {
                                case AUTH_FAILED: {
                                    throw new AuthException(e);
                                }
                                case ERROR_EMAIL_NOT_CONFIRMED: {
                                    throw new EmailNotValidatedException();
                                }
                                case OUTDATED: {
                                    throw new OutdatedException();
                                }
                                case OFFLINE: {
                                    throw new DeviceIsOfflineException();
                                }
                                case TOKEN_INVALID: {
                                    throw new TokenException(e, session);
                                }
                                case UNKNOWN: {
                                    throw new RuntimeException("Not Implemented: unkown");
                                }
                                case CHALLENGE_FAILED: {
                                    throw new ChallengeFailedException();
                                }
                                case EMAIL_FORBIDDEN: {
                                    throw new EmailNotAllowedException();
                                }
                                case EMAIL_INVALID: {
                                    throw new EmailInvalidException();
                                }
                                case EMAIL_BLOCKED: {
                                    throw new EmailBlockedException();
                                }
                                case EMAIL_QUOTA: {
                                    throw new EmailQuotaException();
                                }
                                case OVERLOAD: {
                                    throw new OverloadException(e);
                                }
                                case TOO_MANY_REQUESTS: {
                                    throw new TooManyRequestsException();
                                }
                                case MAINTENANCE: {
                                    throw new MaintenanceException(e);
                                }
                                case BAD_REQUEST: {
                                    break block1;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            catch (MyJDownloaderException my) {
                if (error != null) {
                    my.setSource(error.getSrc());
                }
                throw my;
            }
            catch (Exception ex) {
                throw new UnexpectedIOException(e.getContent(), ex);
            }
        }
        switch (e.getResponseCode()) {
            case 403: {
                throw new AuthException(e);
            }
            case 502: {
                throw new MaintenanceException(e);
            }
            case 503: {
                throw new OverloadException(e);
            }
            case 401: {
                throw new EmailNotValidatedException(e);
            }
            case 407: {
                throw new TokenException(e, session);
            }
        }
        throw new UnexpectedIOException(e.getContent(), e);
    }

    protected abstract byte[] hmac(byte[] var1, byte[] var2) throws MyJDownloaderException;

    protected <T> T jsonToObject(String dec, GenericType clazz) {
        return MyJDJsonMapper.HANDLER.jsonToObject(dec, clazz);
    }

    public void keepalive() throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/keepalive?sessiontoken=" + this.urlencode(session.getSessionToken());
        this.callServer(query, null, session, RequestIDOnly.class);
    }

    public DeviceList listDevices() throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/listdevices?sessiontoken=" + this.urlencode(session.getSessionToken());
        DeviceList ret = this.callServer(query, null, session, DeviceList.class);
        return ret;
    }

    public NotificationRequestMessage.TYPE[] listrequesteddevicesnotifications() throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/notify/list?sessiontoken=" + this.urlencode(session.getSessionToken());
        NotificationRequestTypesResponse ret = this.callServer(query, null, session, NotificationRequestTypesResponse.class);
        return ret.getTypes();
    }

    protected void log(String json) {
    }

    protected String objectToJSon(Object payload) {
        return MyJDJsonMapper.HANDLER.objectToJSon(payload);
    }

    protected abstract byte[] post(String var1, String var2, byte[] var3) throws ExceptionResponse;

    public boolean pushNotification(NotificationRequestMessage message) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/notify/push?sessiontoken=" + this.urlencode(session.getSessionToken());
        JSonRequest re = new JSonRequest();
        re.setApiVer(1);
        re.setRid(this.getUniqueRID());
        re.setParams(new Object[]{message});
        re.setUrl(query);
        return this.callServer(query, re, session, SuccessfulResponse.class).isSuccessful();
    }

    public synchronized SessionInfo reconnect() throws MyJDownloaderException {
        try {
            SessionInfo session = this.getSessionInfo();
            String query = "/my/reconnect?appkey=" + this.urlencode(this.appKey) + "&sessiontoken=" + this.urlencode(session.getSessionToken()) + "&regaintoken=" + this.urlencode(session.getRegainToken());
            ConnectResponse ret = this.callServer(query, null, session, ConnectResponse.class);
            String sessionToken = ret.getSessiontoken();
            String regainToken = ret.getRegaintoken();
            byte[] serverEncryptionToken = this.updateEncryptionToken(session.getServerEncryptionToken(), AbstractMyJDClient.hexToByteArray(sessionToken));
            byte[] deviceEncryptionToken = this.updateEncryptionToken(session.getDeviceSecret(), AbstractMyJDClient.hexToByteArray(sessionToken));
            SessionInfo newSessionInfo = this.createSessionInfo(session.getDeviceSecret(), serverEncryptionToken, deviceEncryptionToken, sessionToken, regainToken);
            this.setSessionInfo(newSessionInfo);
            return newSessionInfo;
        }
        catch (AuthException e) {
            this.setSessionInfo(null);
            throw e;
        }
        catch (MyJDownloaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MyJDownloaderException(e, ErrorResponse.Source.MYJD);
        }
    }

    public void registerNotification(String receiverID, DeviceData device, NotificationRequestMessage.TYPE ... types) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/notify/register?sessiontoken=" + this.urlencode(session.getSessionToken()) + "&receiverid=" + this.urlencode(receiverID) + "&deviceid=" + this.urlencode(device.getId());
        JSonRequest re = new JSonRequest();
        re.setApiVer(1);
        re.setRid(this.getUniqueRID());
        if (types == null || types.length == 0) {
            re.setParams(new Object[]{new NotificationRequestMessage.TYPE[0]});
        } else {
            re.setParams(new Object[]{types});
        }
        re.setUrl(query);
        this.callServer(query, re, session, RequestIDOnly.class);
    }

    public AccessToken requestAccessToken(String service) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/requestaccesstoken?sessiontoken=" + this.urlencode(session.getSessionToken()) + "&service=" + this.urlencode(service);
        AccessTokenResponse tokenResponse = this.callServer(query, null, session, AccessTokenResponse.class);
        return new AccessToken(tokenResponse.getAccessToken(), tokenResponse.getAccessSecret());
    }

    public void requestPasswordResetEmail(CaptchaChallenge challenge, String email) throws MyJDownloaderException {
        if (email == null || !email.matches("^.+?@.+$")) {
            throw new EmailInvalidException();
        }
        this.uncryptedPost("/my/requestpasswordresetemail?email=" + this.urlencode(email) + "&captchaResponse=" + this.urlencode(challenge.getCaptchaResponse()) + "&captchaChallenge=" + this.urlencode(challenge.getCaptchaChallenge()), new Object[0]);
    }

    public void requestRegistrationEmail(CaptchaChallenge challenge, String email, String referer) throws MyJDownloaderException {
        if (email == null || !email.matches("^.+?@.+$")) {
            throw new EmailInvalidException();
        }
        this.uncryptedPost("/my/requestregistrationemail?email=" + this.urlencode(email) + "&captchaResponse=" + this.urlencode(challenge.getCaptchaResponse()) + "&captchaChallenge=" + this.urlencode(challenge.getCaptchaChallenge()) + "&referer=" + this.urlencode(referer == null ? this.appKey : referer), new Object[0]);
    }

    public void requestTerminationEmail(CaptchaChallenge challenge) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/requestterminationemail?sessiontoken=" + this.urlencode(session.getSessionToken()) + "&captchaResponse=" + this.urlencode(challenge.getCaptchaResponse()) + "&captchaChallenge=" + this.urlencode(challenge.getCaptchaChallenge());
        this.callServer(query, null, session, RequestIDOnly.class);
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public synchronized void setSessionInfo(SessionInfo info) {
        SessionInfo old = this.currentSessionInfo;
        if (old != null && !old.equals(info)) {
            old.setValid(false);
        }
        this.currentSessionInfo = info;
    }

    private String sign(byte[] key, String data) throws MyJDownloaderException {
        try {
            return AbstractMyJDClient.byteArrayToHex(this.hmac(key, data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw MyJDownloaderException.get(e);
        }
    }

    public synchronized void terminateSession() throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/terminate?sessiontoken=" + this.urlencode(session.getSessionToken());
        this.callServer(query, null, session, RequestIDOnly.class);
    }

    public synchronized SessionInfoResponse getSessionInfo(String queryToken) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/my/getsessioninfo?sessiontoken=" + this.urlencode(session.getSessionToken()) + "&queryToken=" + this.urlencode(queryToken);
        SessionInfoResponse ret = this.callServer(query, null, session, SessionInfoResponse.class);
        if (ret != null && queryToken.equals(ret.getSessionToken())) {
            return ret;
        }
        return null;
    }

    public synchronized void kill(String email, String password, String killToken) throws MyJDownloaderException {
        String retString = null;
        try {
            if (email == null || !email.matches("^.+?@.+$") || password == null || password.trim().length() == 0) {
                throw new AuthException();
            }
            byte[] loginSecret = this.createSecret(email, password, "server");
            long rid = this.getUniqueRID();
            StringBuilder query = new StringBuilder().append("/my/kill?email=").append(this.urlencode(email)).append("&killtoken=").append(this.urlencode(killToken)).append("&rid=").append(rid);
            String signature = this.sign(loginSecret, query.toString());
            query.append("&signature=").append(this.urlencode(signature));
            retString = this.toString(this.cryptedPost(query.toString(), "", loginSecret));
            RequestIDOnly ret = (RequestIDOnly)this.jsonToObject(retString, RequestIDOnly.class);
            if (ret.getRid() != rid) {
                throw new BadResponseException("RID Mismatch");
            }
        }
        catch (ExceptionResponse e) {
            this.handleInvalidResponseCodes(e, null);
            throw e;
        }
        catch (MyJDownloaderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MyJDownloaderException(e, ErrorResponse.Source.MYJD);
        }
    }

    protected String toString(byte[] data) throws MyJDownloaderException {
        try {
            return new String(data, "UTF-8");
        }
        catch (Exception e) {
            throw MyJDownloaderException.get(e);
        }
    }

    private byte[] uncryptedPost(String path, Object ... params) throws MyJDownloaderException {
        JSonRequest re = new JSonRequest();
        re.setApiVer(1);
        re.setRid(this.getUniqueRID());
        re.setParams(params);
        re.setUrl(path);
        return this.post(path, this.objectToJSon(re), null);
    }

    public void unregisterNotification(String receiverID, DeviceData device) throws MyJDownloaderException {
        SessionInfo session = this.getSessionInfo();
        String query = "/notify/unregister?sessiontoken=" + this.urlencode(session.getSessionToken()) + "&receiverid=" + this.urlencode(receiverID) + "&deviceid=" + this.urlencode(device.getId());
        this.callServer(query, null, session, RequestIDOnly.class);
    }

    protected abstract byte[] updateEncryptionToken(byte[] var1, byte[] var2) throws MyJDownloaderException;

    public abstract String urlencode(String var1) throws MyJDownloaderException;

    public boolean verifyDirectConnectionInfo(String deviceID, DirectConnectionInfo directConnectionInfo) throws MyJDownloaderException {
        if (directConnectionInfo == null) {
            throw new IllegalStateException("directConnectionInfo is null");
        }
        String host = "http://" + directConnectionInfo.getIp() + ":" + directConnectionInfo.getPort();
        try {
            Boolean ret = (Boolean)this.callAction(host, deviceID, "/device/ping", (GenericType)Boolean.class, (Object[])null);
            if (Boolean.TRUE.equals(ret)) {
                return true;
            }
        }
        catch (UnexpectedIOException unexpectedIOException) {
            // empty catch block
        }
        return false;
    }
}

