/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jdownloader.myjdownloader.client.AbstractMyJDClient;
import org.jdownloader.myjdownloader.client.AbstractMyJDDeviceClient;
import org.jdownloader.myjdownloader.client.bindings.ClientApiNameSpace;
import org.jdownloader.myjdownloader.client.bindings.interfaces.Linkable;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;

public abstract class AbstractMyJDClientForBasicJVM
extends AbstractMyJDClient<Type> {
    private static AtomicLong RID_COUNTER = new AtomicLong(System.currentTimeMillis());
    private final HashMap<String, AbstractMyJDDeviceClient> deviceClients = new HashMap();

    public AbstractMyJDClientForBasicJVM(String appKey) {
        super(appKey);
    }

    @Override
    public <T> T callAction(String deviceID, String action, Class<T> returnType, Object ... args) throws MyJDownloaderException {
        return (T)super.callAction(deviceID, action, returnType, args);
    }

    protected AbstractMyJDDeviceClient createDeviceClient(String deviceID) {
        return new AbstractMyJDDeviceClient<Type>(deviceID, this);
    }

    @Override
    protected byte[] createSecret(String username, String password, String domain) throws MyJDownloaderException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest((username.toLowerCase(Locale.ENGLISH) + password + domain.toLowerCase(Locale.ENGLISH)).getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (UnsupportedEncodingException e) {
            throw MyJDownloaderException.get(e);
        }
    }

    @Override
    protected byte[] decrypt(byte[] crypted, byte[] keyAndIV) throws MyJDownloaderException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[16];
            byte[] key = new byte[16];
            System.arraycopy(keyAndIV, 0, iv, 0, 16);
            System.arraycopy(keyAndIV, 16, key, 0, 16);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            cipher.init(2, (Key)skeySpec, ivSpec);
            return cipher.doFinal(crypted);
        }
        catch (NoSuchAlgorithmException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (NoSuchPaddingException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (InvalidKeyException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (IllegalBlockSizeException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (BadPaddingException e) {
            throw MyJDownloaderException.get(e);
        }
    }

    @Override
    protected byte[] encrypt(byte[] data, byte[] keyAndIV) throws MyJDownloaderException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[16];
            byte[] key = new byte[16];
            System.arraycopy(keyAndIV, 0, iv, 0, 16);
            System.arraycopy(keyAndIV, 16, key, 0, 16);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            cipher.init(1, (Key)skeySpec, ivSpec);
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (NoSuchPaddingException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (InvalidKeyException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (IllegalBlockSizeException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (BadPaddingException e) {
            throw MyJDownloaderException.get(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMyJDDeviceClient getDeviceClient(String deviceID) {
        HashMap<String, AbstractMyJDDeviceClient> hashMap = this.deviceClients;
        synchronized (hashMap) {
            AbstractMyJDDeviceClient client = this.deviceClients.get(deviceID);
            if (client == null) {
                client = this.createDeviceClient(deviceID);
                this.deviceClients.put(deviceID, client);
            }
            return client;
        }
    }

    @Override
    protected long getUniqueRID() {
        return RID_COUNTER.incrementAndGet();
    }

    @Override
    protected byte[] hmac(byte[] key, byte[] content) throws MyJDownloaderException {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key, "HmacSHA256");
            sha256_HMAC.init(secret_key);
            return sha256_HMAC.doFinal(content);
        }
        catch (NoSuchAlgorithmException e) {
            throw MyJDownloaderException.get(e);
        }
        catch (InvalidKeyException e) {
            throw MyJDownloaderException.get(e);
        }
    }

    public <T extends Linkable> T link(Class<T> class1, String deviceID) {
        ClientApiNameSpace ann = class1.getAnnotation(ClientApiNameSpace.class);
        if (ann == null) {
            throw new NullPointerException("ApiNameSpace missing in " + class1.getName());
        }
        return this.link(class1, ann.value(), deviceID);
    }

    public <T extends Linkable> T link(Class<T> class1, final String namespace, String deviceID) {
        final AbstractMyJDDeviceClient finalClient = this.getDeviceClient(deviceID);
        return (T)((Linkable)Proxy.newProxyInstance(class1.getClassLoader(), new Class[]{class1}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    String action = "/" + namespace + "/" + method.getName();
                    Type returnType = method.getGenericReturnType();
                    return finalClient.callAction(action, returnType, args);
                }
                catch (Throwable e) {
                    Class<?>[] exceptions = method.getExceptionTypes();
                    if (exceptions != null) {
                        for (Class<?> c : exceptions) {
                            if (!c.isAssignableFrom(e.getClass())) continue;
                            throw e;
                        }
                    }
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    @Override
    protected byte[] updateEncryptionToken(byte[] oldSecret, byte[] update) throws MyJDownloaderException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(oldSecret);
            md.update(update);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw MyJDownloaderException.get(e);
        }
    }
}

