/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.jdownloader.net.BCSSLSocketStreamFactory;

public class AutoBCSSLSocketStreamFactory
implements SSLSocketStreamFactory {
    private static final String BC_FACTORY = "BC_Factory";
    private final BCSSLSocketStreamFactory bc = new BCSSLSocketStreamFactory();
    private final JavaSSLSocketStreamFactory jsse = new JavaSSLSocketStreamFactory();
    private final boolean jsseTLS13Supported = this.jsse.isTLSSupported(JavaSSLSocketStreamFactory.TLS.TLS_1_3, null, null);

    protected boolean preferBC(SSLSocketStreamOptions options) {
        return options.getCustomFactorySettings().contains(BC_FACTORY) || options.getCustomFactorySettings().contains("JSSE_TLS1.3_ENABLED") && !this.jsseTLS13Supported;
    }

    public SSLSocketStreamInterface create(SocketStreamInterface socketStream, String host, int port, boolean autoclose, SSLSocketStreamOptions options) throws IOException {
        final SSLSocketStreamInterface ret = this.preferBC(options) ? this.bc.create(socketStream, host, port, autoclose, options) : this.jsse.create(socketStream, host, port, autoclose, options);
        return new AutoSwitchSSLSocketStreamInterface(){

            public Socket getSocket() {
                return this.getInternalSSLSocketStreamInterface().getSocket();
            }

            public InputStream getInputStream() throws IOException {
                return this.getInternalSSLSocketStreamInterface().getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                return this.getInternalSSLSocketStreamInterface().getOutputStream();
            }

            public void close() throws IOException {
                this.getInternalSSLSocketStreamInterface().close();
            }

            public String getCipherSuite() {
                return "AutoSwitch|" + this.getInternalSSLSocketStreamInterface().getCipherSuite();
            }

            public SocketStreamInterface getParentSocketStream() {
                return this.getInternalSSLSocketStreamInterface().getParentSocketStream();
            }

            public SSLSocketStreamOptions getOptions() {
                return this.getInternalSSLSocketStreamInterface().getOptions();
            }

            @Override
            public SSLSocketStreamFactory getInternalSSLSocketStreamFactory() {
                return this.getInternalSSLSocketStreamInterface().getSSLSocketStreamFactory();
            }

            @Override
            public SSLSocketStreamInterface getInternalSSLSocketStreamInterface() {
                return ret;
            }

            public SSLSocketStreamFactory getSSLSocketStreamFactory() {
                return AutoBCSSLSocketStreamFactory.this;
            }
        };
    }

    public String retry(SSLSocketStreamOptions options, Exception e) {
        String jsseRetry = this.jsse.retry(options, e);
        if (jsseRetry != null) {
            options.getCustomFactorySettings().remove(BC_FACTORY);
            return jsseRetry;
        }
        String bcRetry = this.bc.retry(options, e);
        if (bcRetry != null) {
            options.getCustomFactorySettings().add(BC_FACTORY);
            return bcRetry;
        }
        if (!options.getCustomFactorySettings().contains(BC_FACTORY)) {
            options.getCustomFactorySettings().add(BC_FACTORY);
            return options.addRetryReason("fallback BouncyCastle");
        }
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory(SSLSocketStreamOptions options, String sniHostName) throws IOException {
        if (this.preferBC(options)) {
            return this.bc.getSSLSocketFactory(options, sniHostName);
        }
        return this.jsse.getSSLSocketFactory(options, sniHostName);
    }

    public static interface AutoSwitchSSLSocketStreamInterface
    extends SSLSocketStreamInterface {
        public SSLSocketStreamInterface getInternalSSLSocketStreamInterface();

        public SSLSocketStreamFactory getInternalSSLSocketStreamFactory();
    }
}

