/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jdownloader.par2.Packet;
import org.jdownloader.par2.RawPacket;

public class AsciiCommentPacket
extends Packet {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 32, 50, 46, 48, 0, 67, 111, 109, 109, 65, 83, 67, 73};
    protected final RawPacket rawPacket;
    protected static final Charset ASCII = Charset.forName("ASCII");

    public AsciiCommentPacket(RawPacket rawPacket) {
        this.rawPacket = rawPacket;
    }

    public String toString() {
        return "AsciiCommentPacket|Comment:" + this.getComment();
    }

    public ByteBuffer getCommentAsByteBuffer(boolean ignoreNullTermination) {
        return this.getByteBuffer(0, this.getRawPacket().getBody().length, ignoreNullTermination);
    }

    public String getComment() {
        return ASCII.decode(this.getCommentAsByteBuffer(false)).toString();
    }

    @Override
    public byte[] getType() {
        return MAGIC;
    }

    @Override
    public RawPacket getRawPacket() {
        return this.rawPacket;
    }
}

