/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jdownloader.par2.Packet;
import org.jdownloader.par2.RawPacket;

public class CreatorPacket
extends Packet {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 32, 50, 46, 48, 0, 67, 114, 101, 97, 116, 111, 114, 0};
    protected final RawPacket rawPacket;
    protected static final Charset ASCII = Charset.forName("ASCII");

    public CreatorPacket(RawPacket rawPacket) {
        this.rawPacket = rawPacket;
    }

    public String toString() {
        return "CreatorPacket|Creator:" + this.getCreator();
    }

    public ByteBuffer getCreatorAsByteBuffer(boolean ignoreNullTermination) {
        return this.getByteBuffer(0, this.rawPacket.getBody().length, ignoreNullTermination);
    }

    public String getCreator() {
        return ASCII.decode(this.getCreatorAsByteBuffer(false)).toString();
    }

    @Override
    public byte[] getType() {
        return MAGIC;
    }

    @Override
    public RawPacket getRawPacket() {
        return this.rawPacket;
    }
}

