/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.translate._JDT;

public enum FinalLinkState {
    FINISHED(_GUI.T.TaskColumn_getStringValue_finished_(), "true"),
    FINISHED_MIRROR(_GUI.T.TaskColumn_getStringValue_finished_mirror(), "true-orange"),
    FINISHED_CRC32(_JDT.T.system_download_doCRC2_success("CRC32"), "ok"),
    FINISHED_MD5(_JDT.T.system_download_doCRC2_success("MD5"), "ok"),
    FINISHED_SHA1(_JDT.T.system_download_doCRC2_success("SHA1"), "ok"),
    FINISHED_SHA224(_JDT.T.system_download_doCRC2_success("SHA224"), "ok"),
    FINISHED_SHA256(_JDT.T.system_download_doCRC2_success("SHA256"), "ok"),
    FINISHED_SHA384(_JDT.T.system_download_doCRC2_success("SHA384"), "ok"),
    FINISHED_SHA512(_JDT.T.system_download_doCRC2_success("SHA512"), "ok"),
    FINISHED_WHIRLPOOL(_JDT.T.system_download_doCRC2_success("WHIRLPOOL"), "ok"),
    FAILED(_JDT.T.downloadlink_status_error_downloadfailed(), "false"),
    FAILED_CRC32(_JDT.T.system_download_doCRC2_failed("CRC32"), "false"),
    FAILED_MD5(_JDT.T.system_download_doCRC2_failed("MD5"), "false"),
    FAILED_SHA1(_JDT.T.system_download_doCRC2_failed("SHA1"), "false"),
    FAILED_SHA224(_JDT.T.system_download_doCRC2_failed("SHA224"), "false"),
    FAILED_SHA256(_JDT.T.system_download_doCRC2_failed("SHA256"), "false"),
    FAILED_SHA384(_JDT.T.system_download_doCRC2_failed("SHA384"), "false"),
    FAILED_SHA512(_JDT.T.system_download_doCRC2_failed("SHA512"), "false"),
    FAILED_WHIRLPOOL(_JDT.T.system_download_doCRC2_failed("WHIRLPOOL"), "false"),
    FAILED_EXISTS(_JDT.T.downloadlink_status_error_file_exists(), "false"),
    OFFLINE(_JDT.T.downloadlink_status_error_file_not_found(), "false"),
    FAILED_FATAL(_JDT.T.downloadlink_status_error_fatal(), "false"),
    PLUGIN_DEFECT(_JDT.T.downloadlink_status_error_defect(), "false");

    private final String exp;
    private final String iconKey;
    private final AbstractIcon icon16;

    public final String getIconKey() {
        return this.iconKey;
    }

    private FinalLinkState(String exp, String iconKey) {
        this.exp = exp;
        this.iconKey = iconKey;
        this.icon16 = new AbstractIcon(iconKey, 16);
    }

    public final Icon getIcon(int size) {
        switch (size) {
            case 16: {
                return this.icon16;
            }
        }
        return new AbstractIcon(this.iconKey, 16);
    }

    public final String getExplanation(Object requestor, DownloadLink link) {
        String msg;
        if (link == null) {
            return this.exp;
        }
        if (this == FAILED_FATAL && (msg = link.getCustomMessage(this)) != null) {
            return msg;
        }
        return this.exp;
    }

    public final boolean isFinished() {
        switch (this) {
            case FINISHED: 
            case FINISHED_MIRROR: 
            case FINISHED_CRC32: 
            case FINISHED_MD5: 
            case FINISHED_SHA1: 
            case FINISHED_SHA224: 
            case FINISHED_SHA256: 
            case FINISHED_SHA384: 
            case FINISHED_SHA512: 
            case FINISHED_WHIRLPOOL: {
                return true;
            }
        }
        return false;
    }

    public final boolean isFailed() {
        return !this.isFinished();
    }

    public final boolean isFailedHash() {
        switch (this) {
            case FAILED_CRC32: 
            case FAILED_MD5: 
            case FAILED_SHA1: 
            case FAILED_SHA224: 
            case FAILED_SHA256: 
            case FAILED_SHA384: 
            case FAILED_SHA512: 
            case FAILED_WHIRLPOOL: {
                return true;
            }
        }
        return false;
    }

    public static final boolean CheckFinished(FinalLinkState state) {
        return state != null && state.isFinished();
    }

    public static final boolean CheckFailed(FinalLinkState state) {
        return state != null && state.isFailed();
    }
}

