/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.DownloadLinkCondition;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.translate._JDT;

public class MirrorLoading
implements ConditionalSkipReason,
DownloadLinkCondition {
    private final DownloadLink dependency;
    private final Icon icon;
    private final String message;

    public Icon getIcon() {
        return this.icon;
    }

    public String getMessage() {
        return this.message;
    }

    public MirrorLoading(DownloadLink dependency) {
        this.dependency = dependency;
        this.icon = new AbstractIcon("download", 16);
        this.message = _JDT.T.system_download_errors_linkisBlocked(dependency.getHost());
    }

    @Override
    public void finalize(DownloadLink link) {
        if (FinalLinkState.CheckFinished(this.getDownloadLink().getFinalLinkState())) {
            link.setSkipReason(null);
            link.setFinalLinkState(FinalLinkState.FINISHED_MIRROR);
            link.setFinishedDate(this.getDownloadLink().getFinishedDate());
            link.setName(this.getDownloadLink().getView().getDisplayName());
            long fileSize = this.getDownloadLink().getView().getBytesTotal();
            if (fileSize >= 0L) {
                link.setDownloadSize(fileSize);
            }
            link.setDownloadCurrent(this.getDownloadLink().getView().getBytesLoaded());
        }
    }

    @Override
    public boolean isConditionReached() {
        return this.getDownloadLink().getDownloadLinkController() == null;
    }

    @Override
    public DownloadLink getDownloadLink() {
        return this.dependency;
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        if (requestor instanceof ETAColumn) {
            return null;
        }
        return this.getMessage();
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getIcon(this, node);
        }
        if (requestor instanceof ETAColumn) {
            return null;
        }
        return this.getIcon();
    }
}

