/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.appwork.swing.components.ExtMergedIcon;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.translate._JDT;

public enum SkipReason {
    CONNECTION_UNAVAILABLE(_JDT.T.DownloadLink_setSkipped_statusmessage_noconnectionavailable(), "error"),
    TOO_MANY_RETRIES(_JDT.T.DownloadLink_setSkipped_statusmessage_toomanyretries(), "error"),
    CAPTCHA(_JDT.T.DownloadLink_setSkipped_statusmessage_captcha(), "ocr"),
    MANUAL(_JDT.T.DownloadLink_setSkipped_statusmessage()),
    DISK_FULL(_JDT.T.DownloadLink_setSkipped_statusmessage_disk_full(), "save"),
    NO_ACCOUNT(_JDT.T.DownloadLink_setSkipped_statusmessage_account(), "premium"),
    INVALID_DESTINATION(_JDT.T.DownloadLink_setSkipped_statusmessage_invalid_path(), "saveto"),
    INVALID_DESTINATION_PERMISSION_ISSUE(_JDT.T.DownloadLink_setSkipped_statusmessage_invalid_path_permission_issue(), "saveto"),
    INVALID_DESTINATION_TOO_LONG_FILENAME(_JDT.T.DownloadLink_setSkipped_statusmessage_invalid_path_too_long_filename(), "saveto"),
    INVALID_DESTINATION_TOO_LONG_PATH(_JDT.T.DownloadLink_setSkipped_statusmessage_invalid_path_too_long_path(), "saveto"),
    FILE_EXISTS(_JDT.T.DownloadLink_setSkipped_statusmessage_file_exists(), "copy"),
    UPDATE_RESTART_REQUIRED(_JDT.T.DownloadLink_setSkipped_statusmessage_update_restart(), "restart"),
    FFMPEG_MISSING(_JDT.T.DownloadLink_setSkipped_statusmessage_ffmpeg(), "logo/ffmpeg"),
    FFPROBE_MISSING(_JDT.T.DownloadLink_setSkipped_statusmessage_ffprobe(), "logo/ffmpeg"),
    PHANTOM_JS_MISSING(_JDT.T.DownloadLink_setSkipped_statusmessage_phantom(), "logo/phantomjs-logo"),
    PLUGIN_DEFECT(_JDT.T.downloadlink_status_error_defect(), "false");

    private final String exp;
    private final String iconKey;

    private SkipReason(String exp, String iconKey) {
        this.exp = exp;
        this.iconKey = iconKey;
    }

    public Icon getIcon(Object requestor, int size) {
        String id = "Skipped" + this.iconKey + "-" + size;
        Icon ret = NewTheme.I().getCached(id);
        if (this.iconKey == null) {
            ret = new AbstractIcon("skipped", size);
            NewTheme.I().cache(ret, id);
            return ret;
        }
        int main = (int)((double)size * 0.75);
        int badge = (int)((double)size * 0.75);
        ret = new ExtMergedIcon((Icon)new AbstractIcon("skipped", main), -1, -1).add((Icon)new AbstractIcon(this.iconKey, badge), size - badge, size - badge).crop(size, size);
        NewTheme.I().cache(ret, id);
        return ret;
    }

    private SkipReason(String exp) {
        this.exp = exp;
        this.iconKey = "skipped";
    }

    public String getExplanation(Object requestor) {
        return this.exp;
    }

    public final String getExplanation(Object requestor, DownloadLink link) {
        String msg;
        if (link == null) {
            return this.getExplanation(requestor);
        }
        if (this == NO_ACCOUNT && (msg = link.getCustomMessage(this)) != null) {
            return msg;
        }
        return this.exp;
    }
}

