/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.MultiHostHost;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.IgnorableConditionalSkipReason;
import org.jdownloader.translate._JDT;

public class WaitForAccountTrafficSkipReasonMultihostLinksRequired
implements ConditionalSkipReason,
IgnorableConditionalSkipReason {
    private final Account account;
    private final String host;
    private long linksMax;
    private final Icon icon;

    public Icon getIcon() {
        return this.icon;
    }

    public WaitForAccountTrafficSkipReasonMultihostLinksRequired(Account account, String host, long linksMax) {
        this.account = account;
        this.host = host;
        this.linksMax = linksMax;
        this.icon = new AbstractIcon("wait", 16);
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public boolean canIgnore() {
        return false;
    }

    private final boolean hasEnoughTraffic() {
        AccountInfo ai = this.getAccount().getAccountInfo();
        if (ai == null) {
            return true;
        }
        MultiHostHost mhost = ai.getMultihostSupportedHost(this.host);
        if (mhost == null) {
            return true;
        }
        return mhost.isUnlimitedLinks() || mhost.getLinksLeft() > 0L;
    }

    public String toString() {
        return "WaitForAccountMultiHostHostTrafficSkipReason(Account:" + this.getAccount() + "|" + this.getMessage(this, null) + ")";
    }

    @Override
    public boolean isConditionReached() {
        return !this.getAccount().isEnabled() || !this.getAccount().isValid() || this.getAccount().getAccountController() == null || this.hasEnoughTraffic();
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        return _JDT.T.gui_download_waittime_notenoughtraffic_links_multihost(this.getAccount().getHoster(), "0/" + this.linksMax);
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getIcon(this, node);
        }
        return this.getIcon();
    }

    @Override
    public void finalize(DownloadLink link) {
    }
}

