/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jd.PluginWrapper;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountRequiredException;
import jd.plugins.AccountUnavailableException;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.components.PluginJSonUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.jdownloader.plugins.components.XFileSharingProBasic;
import org.jdownloader.scripting.JavaScriptEngineFactory;

@HostPlugin(revision="$Revision: 50639 $", interfaceVersion=3, names={}, urls={})
public class XFileSharingProBasicSpecialFilejoker
extends XFileSharingProBasic {
    private static final String PROPERTY_SESSIONID = "cookie_zeus_cloud_sessionid";
    private static final String PROPERTY_EMAIL = "cookie_email";
    private static final String PROPERTY_USERNAME = "cookie_username";
    private static final String PROPERTY_LAST_API_LOGIN_FAILURE_IN_WEBSITE_MODE = "timestamp_last_api_login_failure_in_website_mode";
    private static final String PROPERTY_LASTDOWNLOAD_API = "lastdownload_timestamp_api";
    private static final String PROPERTY_LASTDOWNLOAD_WEBSITE = "lastdownload_timestamp_website";
    private static final String PROPERTY_COOKIES_API = "PROPERTY_COOKIES_API";
    public static final String PROPERTY_SETTING_USE_API = "USE_API_2020_05_20";
    public static final String PROPERTY_API_FAILURE_TOGGLE_WEBSITE_FALLBACK = "PROPERTY_API_FAILURE_TOGGLE_WEBSITE_FALLBACK";
    public static final boolean default_PROPERTY_SETTING_USE_API = true;

    public XFileSharingProBasicSpecialFilejoker(PluginWrapper wrapper) {
        super(wrapper);
        this.enablePremium(super.getPurchasePremiumURL());
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformationWebsite(DownloadLink link, Account account) throws Exception {
        if (!link.isNameSet()) {
            this.setWeakFilename(link, null);
        }
        return this.requestFileInformationWebsiteXFSOld(link, account);
    }

    @Override
    protected String buildURLPath(DownloadLink link, String fuid, XFileSharingProBasic.URL_TYPE type) {
        if (link != null && link.getPluginPatternMatcher() != null && link.getPluginPatternMatcher().matches("(?i)https?://[^/]+/file/.+")) {
            return "/file/" + fuid;
        }
        return super.buildURLPath(link, fuid, type);
    }

    @Override
    protected String getDllink(DownloadLink link, Account account, Browser br, String src) {
        String dllink = new Regex(src, "\"(https?://f?s\\d+[^/]+/[^\"]+)\"").getMatch(0);
        if (StringUtils.isEmpty((String)dllink)) {
            dllink = new Regex(src, "href\\s*=\\s*\"(https?://[^<>\"]+)\"\\s*class\\s*=\\s*\"btn btn[^\"]*\"").getMatch(0);
        }
        if (StringUtils.isEmpty((String)dllink)) {
            dllink = new Regex(src, "\"(https?://[^/]+/[a-z0-9]{50,100}/[^\"]+)\"").getMatch(0);
        }
        if (StringUtils.isEmpty((String)dllink)) {
            dllink = super.getDllink(link, account, br, src);
        }
        if (account != null && !StringUtils.isEmpty((String)dllink)) {
            account.setProperty(PROPERTY_LASTDOWNLOAD_WEBSITE, System.currentTimeMillis());
        }
        return dllink;
    }

    public static final String getFileJokerAnnotationPatternPart() {
        return "/(?:embed-|file/)?[a-z0-9]{12}(?:/[^/]+(?:\\.html)?)?";
    }

    public static String[] buildAnnotationUrls(List<String[]> pluginDomains) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] domains : pluginDomains) {
            ret.add("https?://(?:www\\.)?" + XFileSharingProBasicSpecialFilejoker.buildHostsPatternPart(domains) + XFileSharingProBasicSpecialFilejoker.getFileJokerAnnotationPatternPart());
        }
        return ret.toArray(new String[0]);
    }

    @Override
    public Form findFormDownload2Premium(DownloadLink downloadLink, Account account, Browser br) throws Exception {
        this.handleSecurityVerification(br);
        return super.findFormDownload2Premium(downloadLink, account, br);
    }

    @Override
    public Form findFormDownload1Free(Browser br) throws Exception {
        this.handleSecurityVerification(br);
        return super.findFormDownload1Free(br);
    }

    @Override
    protected void getPage(String page) throws Exception {
        super.getPage(page);
        this.handleSecurityVerification(this.br);
    }

    @Override
    protected void postPage(String page, String data) throws Exception {
        super.postPage(page, data);
        this.handleSecurityVerification(this.br);
    }

    @Override
    protected void submitForm(Form form) throws Exception {
        super.submitForm(form);
        this.handleSecurityVerification(this.br);
    }

    protected boolean isSecurityVerificationRequired(Browser br) {
        return StringUtils.containsIgnoreCase((String)br.getURL(), (String)"op=captcha&id=") || br.containsHTML("(?i)<h1>\\s*Security Verification\\s*</h1>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSecurityVerification(Browser br) throws Exception {
        if (this.isSecurityVerificationRequired(br)) {
            Form securityVerification = this.getSecurityVerificationForm(br);
            if (securityVerification != null && securityVerification.containsHTML("data-sitekey")) {
                this.logger.info("Handling securityVerification");
                if (this.containsHCaptcha(this.getCorrectBR(br))) {
                    this.handleHCaptcha(this.getDownloadLink(), br, securityVerification);
                } else if (this.containsRecaptchaV2Class(this.getCorrectBR(br))) {
                    this.handleRecaptchaV2(this.getDownloadLink(), br, securityVerification);
                } else {
                    throw new PluginException(0x400000);
                }
                boolean redirectBehavior = br.isFollowingRedirects();
                br.setFollowRedirects(true);
                try {
                    this.submitForm(br, securityVerification);
                }
                finally {
                    br.setFollowRedirects(redirectBehavior);
                }
                if (this.isSecurityVerificationRequired(br)) {
                    throw new PluginException(8);
                }
            } else {
                this.logger.warning("Failed to process security verification - subsequent handling may fail");
            }
        }
    }

    protected Form getSecurityVerificationForm(Browser br) {
        Form form = br.getFormbyProperty("name", "F1");
        if (form == null) {
            form = br.getFormbyProperty("id", "f1");
        }
        return form;
    }

    protected boolean useRandomUserAgentWebsite() {
        return false;
    }

    protected boolean useAPIZeusCloudManager(Account account) {
        if (account != null) {
            Cookies userCookies = account.loadUserCookies();
            return userCookies == null;
        }
        return true;
    }

    protected boolean internal_useAPIZeusCloudManager(DownloadLink link, Account account) {
        return (link == null || !XFileSharingProBasic.URL_TYPE.FILE.equals((Object)this.getURLType(link))) && this.useAPIZeusCloudManager(account) && !this.isAPITempDisabled(account);
    }

    protected boolean tryAPILoginInWebsiteMode(Account account) {
        return false;
    }

    protected boolean tryAPILoginInWebsiteMode_get_account_info_from_api(Account account) {
        return true;
    }

    protected String getRelativeAPIBaseAPIZeusCloudManager() {
        return null;
    }

    protected String getRelativeAPILoginParamsFormatAPIZeusCloudManager() {
        return null;
    }

    protected boolean useRandomUserAgentAPI() {
        return false;
    }

    private final Browser prepAPIZeusCloudManager(Browser br) {
        if (!this.useRandomUserAgentAPI()) {
            br.getHeaders().put("User-Agent", "okhttp/3.8.0");
        }
        br.setAllowedResponseCodes(new int[]{418});
        return br;
    }

    @Override
    protected boolean useRUA() {
        if (this.internal_useAPIZeusCloudManager(null, null)) {
            return this.useRandomUserAgentAPI();
        }
        return this.useRandomUserAgentWebsite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean loginAPIZeusCloudManager(Browser apibr, Account account, boolean validateSession) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            this.prepAPIZeusCloudManager(apibr);
            boolean validatedSession = false;
            String sessionid = this.getAPIZeusCloudManagerSession(account);
            try {
                if (!StringUtils.isEmpty((String)sessionid)) {
                    long timeStamp = account.getCookiesTimeStamp("");
                    long age = System.currentTimeMillis() - timeStamp;
                    if (age <= 3600000L && !validateSession) {
                        this.logger.info("Trust login-sessionid without checking as it should still be fresh: age=" + TimeFormatter.formatMilliSeconds((long)age, (int)0));
                        boolean bl = false;
                        return bl;
                    }
                    this.logger.info("Verify login-sessionid: age=" + TimeFormatter.formatMilliSeconds((long)age, (int)0));
                    this.getPage(apibr, this.getMainPage() + this.getRelativeAPIBaseAPIZeusCloudManager() + "?op=my_account&session=" + sessionid);
                    String error = PluginJSonUtils.getJson(apibr, "error");
                    if (!StringUtils.equalsIgnoreCase((String)error, (String)"invalid session") && apibr.getHttpConnection().getResponseCode() == 200) {
                        validatedSession = true;
                        this.checkErrorsAPIZeusCloudManager(apibr, null, account);
                    }
                }
                if (!validatedSession) {
                    this.getPage(apibr, this.getMainPage() + this.getRelativeAPIBaseAPIZeusCloudManager() + String.format(this.getRelativeAPILoginParamsFormatAPIZeusCloudManager(), Encoding.urlEncode((String)account.getUser()), Encoding.urlEncode((String)account.getPass())));
                    sessionid = PluginJSonUtils.getJson(apibr, "session");
                    this.checkErrorsAPIZeusCloudManager(apibr, null, account);
                    if (StringUtils.isEmpty((String)sessionid)) {
                        this.logger.info("Login failed for unknown reasons");
                        throw new PluginException(256, PluginException.VALUE_ID_PREMIUM_DISABLE);
                    }
                    validatedSession = true;
                }
                account.setRefreshTimeout(0x6DDD00L);
                boolean timeStamp = validatedSession;
                return timeStamp;
            }
            catch (PluginException e) {
                if (e.getLinkStatus() != 256) throw e;
                this.dumpAPISessionInfo(account);
                throw e;
            }
            finally {
                if (validatedSession) {
                    this.logger.info("convertSpecialAPICookiesToWebsiteCookiesAndSaveThem(" + sessionid + "):" + this.convertSpecialAPICookiesToWebsiteCookiesAndSaveThem(account, sessionid));
                }
            }
        }
    }

    private final AccountInfo fetchAccountInfoAPIZeusCloudManager(Browser br, Account account) throws Exception {
        String expireStr;
        AccountInfo ai = new AccountInfo();
        if (br.getURL() == null || !br.getURL().contains(this.getRelativeAPIBaseAPIZeusCloudManager() + "?op=my_account")) {
            this.loginAPIZeusCloudManager(br, account, true);
        }
        String sessionid = this.getAPIZeusCloudManagerSession(account);
        if (br.getURL() == null || !br.getURL().contains(this.getRelativeAPIBaseAPIZeusCloudManager() + "?op=my_account&session=")) {
            this.getPage(br, this.getMainPage() + this.getRelativeAPIBaseAPIZeusCloudManager() + "?op=my_account&session=" + sessionid);
        }
        Map<String, Object> entries = JavaScriptEngineFactory.jsonToJavaMap(br.toString());
        String server_timeStr = (String)entries.get("server_time");
        long expire_milliseconds_precise_to_the_second = 0L;
        String email = (String)entries.get("usr_email");
        String username = (String)entries.get("usr_login");
        long currentTime = server_timeStr != null && server_timeStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}") ? TimeFormatter.getMilliSeconds((String)server_timeStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH) : System.currentTimeMillis();
        Long trafficleft = JavaScriptEngineFactory.toLong(entries.get("traffic_left"), Long.MIN_VALUE);
        if (trafficleft == Long.MIN_VALUE) {
            trafficleft = null;
        }
        if ((expireStr = (String)entries.get("usr_premium_expire")) != null && expireStr.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            expire_milliseconds_precise_to_the_second = TimeFormatter.getMilliSeconds((String)expireStr, (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.ENGLISH);
        }
        boolean isPremium = false;
        if (expire_milliseconds_precise_to_the_second <= currentTime) {
            if (expire_milliseconds_precise_to_the_second > 0L) {
                this.logger.info("Premium expired --> Free account");
            }
            this.setAccountLimitsByType(account, Account.AccountType.FREE);
        } else {
            isPremium = true;
            ai.setValidUntil(expire_milliseconds_precise_to_the_second);
            this.setAccountLimitsByType(account, Account.AccountType.PREMIUM);
        }
        if (trafficleft != null) {
            ai.setTrafficLeft(trafficleft * 1024L * 1024L);
        }
        if (!StringUtils.isEmpty((String)email)) {
            account.setProperty(PROPERTY_EMAIL, email);
        }
        if (!StringUtils.isEmpty((String)username)) {
            account.setProperty(PROPERTY_USERNAME, username);
        }
        this.logger.info("convertSpecialAPICookiesToWebsiteCookiesAndSaveThem(" + sessionid + "):" + this.convertSpecialAPICookiesToWebsiteCookiesAndSaveThem(account, sessionid));
        return ai;
    }

    private final void handlePremiumAPIZeusCloudManager(Browser br, DownloadLink link, Account account) throws Exception {
        this.loginAPIZeusCloudManager(br, account, false);
        String directlinkproperty = this.getDownloadModeDirectlinkProperty(account);
        String dllink = this.checkDirectLinkAPIZeusCloudManager(link, directlinkproperty);
        if (StringUtils.isEmpty((String)dllink)) {
            String sessionid = this.getAPIZeusCloudManagerSession(account);
            this.getPage(br, this.getMainPage() + this.getRelativeAPIBaseAPIZeusCloudManager() + "?op=download1&session=" + sessionid + "&file_code=" + this.getFUIDFromURL(link));
            this.checkErrorsAPIZeusCloudManager(this.br, link, account);
            String download_id = PluginJSonUtils.getJson(br, "download_id");
            String waittimeSecondsStr = PluginJSonUtils.getJson(br, "countdown");
            if (StringUtils.isEmpty((String)download_id)) {
                throw new PluginException(2048, "download_id is missing");
            }
            if (!StringUtils.isEmpty((String)waittimeSecondsStr) && waittimeSecondsStr.matches("\\d+")) {
                int waittimeSeconds = Integer.parseInt(waittimeSecondsStr);
                this.sleep((long)waittimeSeconds * 1001L, link);
            }
            this.getPage(br, this.getMainPage() + this.getRelativeAPIBaseAPIZeusCloudManager() + "?op=download2&session=" + sessionid + "&file_code=" + this.getFUIDFromURL(link) + "&download_id=" + download_id);
            this.checkErrorsAPIZeusCloudManager(this.br, link, account);
            dllink = PluginJSonUtils.getJson(br, "direct_link");
            if (!StringUtils.isEmpty((String)dllink)) {
                account.setProperty(PROPERTY_LASTDOWNLOAD_API, System.currentTimeMillis());
            }
        }
        this.handleDownload(link, account, dllink, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String checkDirectLinkAPIZeusCloudManager(DownloadLink link, String property) {
        block20: {
            String string;
            String directurl = link.getStringProperty(property, null);
            if (StringUtils.isEmpty((String)directurl) || !directurl.startsWith("http")) {
                return null;
            }
            URLConnectionAdapter con = null;
            try {
                boolean isDownload;
                Browser br2 = this.br.cloneBrowser();
                br2.setFollowRedirects(true);
                con = this.openAntiDDoSRequestConnection(br2, (Request)br2.createHeadRequest(directurl));
                boolean bl = isDownload = con.isContentDisposition() || StringUtils.containsIgnoreCase((String)con.getContentType(), (String)"video") || StringUtils.containsIgnoreCase((String)con.getContentType(), (String)"audio");
                if (con.getResponseCode() == 503) {
                    this.logger.info("directurl lead to 503 | too many connections");
                    String string2 = directurl;
                    return string2;
                }
                if (con.getContentType().contains("text") || con.getLongContentLength() < 0L || !con.isOK() || !isDownload) break block20;
                if (con.getLongContentLength() < 100L) {
                    throw new Exception("very likely no file but an error message!length=" + con.getLongContentLength());
                }
                string = directurl;
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
                break block20;
            }
            finally {
                if (con != null) {
                    try {
                        con.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return string;
        }
        return null;
    }

    @Override
    public void handlePremium(DownloadLink link, Account account) throws Exception {
        this.resolveShortURL(this.br.cloneBrowser(), link, account);
        if (this.internal_useAPIZeusCloudManager(link, account)) {
            this.handlePremiumAPIZeusCloudManager(this.br, link, account);
        } else {
            super.handlePremium(link, account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean convertSpecialAPICookiesToWebsiteCookiesAndSaveThem(Account account, String sessionid) {
        if (account != null && StringUtils.isNotEmpty((String)sessionid)) {
            Account account2 = account;
            synchronized (account2) {
                Cookies cookies = new Cookies();
                if (this.br != null) {
                    cookies.add(this.br.getCookies(account.getHoster()));
                }
                cookies.remove("xfss");
                cookies.add(new Cookie(account.getHoster(), "xfss", sessionid));
                String email = account.getStringProperty(PROPERTY_EMAIL, null);
                String username = account.getStringProperty(PROPERTY_USERNAME, null);
                if (!StringUtils.isEmpty((String)email)) {
                    cookies.remove("email");
                    cookies.add(new Cookie(account.getHoster(), "email", email));
                }
                if (!StringUtils.isEmpty((String)username)) {
                    cookies.remove("login");
                    cookies.add(new Cookie(account.getHoster(), "login", username));
                }
                account.saveCookies(cookies, "");
                account.saveCookies(cookies, PROPERTY_COOKIES_API);
                account.setProperty(PROPERTY_SESSIONID, sessionid);
                return true;
            }
        }
        return false;
    }

    protected void tempDisableAPI(Account account, String failure_reason) throws PluginException {
        account.setProperty(PROPERTY_API_FAILURE_TOGGLE_WEBSITE_FALLBACK, System.currentTimeMillis());
        throw new PluginException(4096, "Wait for retry via website because: " + failure_reason, 60000L);
    }

    protected boolean isAPITempDisabled(Account account) {
        if (account == null) {
            return false;
        }
        long api_failure_timestamp = account.getLongProperty(PROPERTY_API_FAILURE_TOGGLE_WEBSITE_FALLBACK, -1L);
        if (api_failure_timestamp == -1L) {
            return false;
        }
        long api_disabled_until = api_failure_timestamp + 3600000L;
        if (System.currentTimeMillis() < api_disabled_until) {
            long disabled_remaining_time = api_disabled_until - System.currentTimeMillis();
            this.logger.info("API is temporarily disabled for another: " + TimeFormatter.formatMilliSeconds((long)disabled_remaining_time, (int)0));
            return true;
        }
        return false;
    }

    @Override
    protected AccountInfo fetchAccountInfoWebsite(Account account) throws Exception {
        if (this.internal_useAPIZeusCloudManager(null, account)) {
            return this.fetchAccountInfoAPIZeusCloudManager(this.br, account);
        }
        long timestamp_last_api_login_failure_in_website_mode = account.getLongProperty(PROPERTY_LAST_API_LOGIN_FAILURE_IN_WEBSITE_MODE, 0L);
        boolean try_api_login_in_website_mode = this.tryAPILoginInWebsiteMode(account);
        if (try_api_login_in_website_mode) {
            long api_login_retry_limit = 86400000L;
            long timestamp_api_login_retry_allowed = timestamp_last_api_login_failure_in_website_mode + 86400000L;
            if (System.currentTimeMillis() < timestamp_api_login_retry_allowed) {
                long time_until_new_api_login_in_website_mode_allowed = timestamp_api_login_retry_allowed - System.currentTimeMillis();
                this.logger.info("try_api_login is not allowed because last API login attempt failed - retry allowed in: " + TimeFormatter.formatMilliSeconds((long)time_until_new_api_login_in_website_mode_allowed, (int)0));
                try_api_login_in_website_mode = false;
            }
        }
        if (try_api_login_in_website_mode) {
            this.logger.info("Trying API fetchAccountInfoAPIZeusCloudManager in website as an attempt to avoid login captchas and get more precise account information");
            try {
                Browser apiBR = this.createNewBrowserInstance();
                AccountInfo ai = null;
                try {
                    if (this.tryAPILoginInWebsiteMode_get_account_info_from_api(account)) {
                        this.logger.info("API in website mode is allowed to login and fetchAccountInfo");
                        ai = this.fetchAccountInfoAPIZeusCloudManager(apiBR, account);
                        this.logger.info("API login successful --> Verifying cookies via website because if we're unlucky they are not valid for website mode");
                    } else {
                        this.logger.info("API in website mode is only allowed to login - AccountInfo will be obtained from website");
                        this.loginAPIZeusCloudManager(this.br, account, true);
                        this.logger.info("Requesting AccountInfo from API anyways but only to set correct website cookies --> API AccountInfo will not be set!");
                        this.fetchAccountInfoAPIZeusCloudManager(apiBR, account);
                    }
                    this.br.setCookies(this.getMainPage(), account.loadCookies(""));
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    this.logger.info("API handling in website handling failed");
                }
                this.getPage(this.getMainPage() + this.getRelativeAccountInfoURL());
                if (!this.isLoggedin(this.br)) {
                    this.logger.info("We are NOT loggedIN according to website --> Either wrong logindata or some other kind of issue");
                    throw new AccountInvalidException();
                }
                this.logger.info("Successfully logged in via API and used API cookies for website");
                if (ai != null) {
                    long trafficleftFromAPI;
                    long trafficleftWebsiteBytes;
                    this.logger.info("Returning AccountInfo from API");
                    String trafficleftWebsiteStr = this.regExTrafficLeft(this.br);
                    if (trafficleftWebsiteStr != null && (trafficleftWebsiteBytes = SizeFormatter.getSize((String)trafficleftWebsiteStr)) > (trafficleftFromAPI = ai.getTrafficLeft())) {
                        this.logger.info("Prefer traffic left from website: " + trafficleftWebsiteStr + " | API would be: " + SizeFormatter.formatBytes((long)trafficleftFromAPI));
                        ai.setTrafficLeft(trafficleftWebsiteBytes);
                    }
                    return ai;
                }
                this.logger.info("NOT returning AccountInfo from API --> Continue via website handling from now on");
            }
            catch (PluginException e) {
                if (e.getLinkStatus() == 256) {
                    this.logger.warning("API login failed --> Falling back to website");
                    account.setProperty(PROPERTY_LAST_API_LOGIN_FAILURE_IN_WEBSITE_MODE, System.currentTimeMillis());
                }
                this.logger.info("Error happened during API login in website mode");
                throw e;
            }
        }
        return super.fetchAccountInfoWebsite(account);
    }

    @Override
    public boolean loginWebsite(DownloadLink downloadLink, Account account, boolean force) throws Exception {
        if (this.internal_useAPIZeusCloudManager(downloadLink, account)) {
            return this.loginAPIZeusCloudManager(this.br, account, force);
        }
        return super.loginWebsite(downloadLink, account, force);
    }

    @Override
    public String getLoginURL() {
        return this.getMainPage() + "/login";
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkErrorsAPIZeusCloudManager(Browser apibr, DownloadLink link, Account account) throws NumberFormatException, PluginException {
        block23: {
            String message;
            block24: {
                String error;
                block25: {
                    String wait;
                    error = PluginJSonUtils.getJson(apibr, "error");
                    message = PluginJSonUtils.getJson(apibr, "message");
                    String waittimeRegex = ".*(You have reached the download(\\-| )limit|You have to wait|Wait .*? to download for free|You will not be able to download for).*";
                    String string = wait = !StringUtils.isEmpty((String)error) ? new Regex(error, ".*(You have reached the download(\\-| )limit|You have to wait|Wait .*? to download for free|You will not be able to download for).*").getMatch(-1) : null;
                    if (StringUtils.isEmpty(wait) && !StringUtils.isEmpty((String)message)) {
                        wait = new Regex(message, ".*(You have reached the download(\\-| )limit|You have to wait|Wait .*? to download for free|You will not be able to download for).*").getMatch(-1);
                    }
                    if (wait != null) {
                        int waittime;
                        String tmphrs = new Regex(wait, "\\s+(\\d+)\\s+hours?").getMatch(0);
                        String tmpmin = new Regex(wait, "\\s+(\\d+)\\s+minutes?").getMatch(0);
                        String tmpsec = new Regex(wait, "\\s+(\\d+)\\s+seconds?").getMatch(0);
                        String tmpdays = new Regex(wait, "\\s+(\\d+)\\s+days?").getMatch(0);
                        if (tmphrs == null && tmpmin == null && tmpsec == null && tmpdays == null) {
                            this.logger.info("Waittime RegExes seem to be broken - using default waittime");
                            waittime = 3600000;
                        } else {
                            int minutes = 0;
                            int seconds = 0;
                            int hours = 0;
                            int days = 0;
                            if (tmphrs != null) {
                                hours = Integer.parseInt(tmphrs);
                            }
                            if (tmpmin != null) {
                                minutes = Integer.parseInt(tmpmin);
                            }
                            if (tmpsec != null) {
                                seconds = Integer.parseInt(tmpsec);
                            }
                            if (tmpdays != null) {
                                days = Integer.parseInt(tmpdays);
                            }
                            waittime = (days * 24 * 3600 + 3600 * hours + 60 * minutes + seconds + 1) * 1000;
                        }
                        this.logger.info("Detected reconnect waittime (milliseconds): " + waittime);
                        if (waittime < 180000) {
                            throw new PluginException(4096, "Wait until new downloads can be started", waittime);
                        }
                        if (account != null) {
                            throw new AccountUnavailableException("Download limit reached", (long)waittime);
                        }
                        throw new PluginException(16, null, waittime);
                    }
                    if (StringUtils.isEmpty((String)error)) break block24;
                    if (error.equalsIgnoreCase("Login failed")) {
                        this.dumpAPISessionInfo(account);
                        throw new PluginException(256, PluginException.VALUE_ID_PREMIUM_DISABLE);
                    }
                    if (!error.equalsIgnoreCase("invalid session")) break block25;
                    this.invalidateAPIZeusCloudManagerSession(account);
                    break block23;
                }
                if (error.equalsIgnoreCase("no file")) {
                    throw new PluginException(32);
                }
                if (error.equalsIgnoreCase("Download session expired")) {
                    throw new PluginException(2048, error, 60000L);
                }
                if (error.equalsIgnoreCase("Skipped countdown")) {
                    throw new PluginException(131072);
                }
                if (error.equalsIgnoreCase("hack activity detected")) {
                    throw new AccountUnavailableException("Try again later: API error '" + error + "'", 900000L);
                }
                if (error.equalsIgnoreCase("API downloads disabled for you")) {
                    this.tempDisableAPI(account, error);
                    break block23;
                } else if (error.equalsIgnoreCase("API download disabled for your account")) {
                    this.tempDisableAPI(account, error);
                    break block23;
                } else {
                    if (!error.equalsIgnoreCase("session error")) {
                        this.logger.warning("Unknown API error:" + error);
                        throw new PluginException(256, "Unknown API error: " + error, PluginException.VALUE_ID_PREMIUM_TEMP_DISABLE);
                    }
                    this.tempDisableAPI(account, error);
                }
                break block23;
            }
            if (!StringUtils.isEmpty((String)message)) {
                if (message.contains("This file can only be downloaded by Premium")) {
                    throw new AccountRequiredException();
                }
                if (message.equalsIgnoreCase("Premium Only file")) {
                    throw new AccountRequiredException();
                }
                this.logger.warning("Possibly unhandled API errormessage: " + message);
            }
        }
        this.checkResponseCodeErrors(apibr.getHttpConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getAPIZeusCloudManagerSession(Account account) {
        Account account2 = account;
        synchronized (account2) {
            String api_sessionid = account.getStringProperty(PROPERTY_SESSIONID, null);
            return api_sessionid;
        }
    }

    private final void invalidateAPIZeusCloudManagerSession(Account account) throws PluginException {
        this.dumpAPISessionInfo(account);
        throw new AccountUnavailableException("Invalid sessionid", 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpAPISessionInfo(Account account) {
        Account account2 = account;
        synchronized (account2) {
            Cookie sessionid_api;
            Cookies cookies_website = account.loadCookies("");
            Cookies cookies_api = account.loadCookies(PROPERTY_COOKIES_API);
            Cookie sessionid_website = cookies_website != null ? cookies_website.get("xfss", Cookies.NOTDELETEDPATTERN) : null;
            Cookie cookie = sessionid_api = cookies_api != null ? cookies_api.get("xfss", Cookies.NOTDELETEDPATTERN) : null;
            if (sessionid_website != null && sessionid_api != null && StringUtils.equals((String)sessionid_website.getValue(), (String)sessionid_api.getValue())) {
                this.logger.info("clearNormalCookies:sessionid=" + sessionid_website.getValue());
                account.clearCookies("");
            }
            this.logger.info("clearAPICookies");
            account.clearCookies(PROPERTY_COOKIES_API);
            account.removeProperty(PROPERTY_SESSIONID);
        }
    }

    @Override
    public void resetDownloadlink(DownloadLink link) {
    }
}

